/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest;
import software.amazon.awssdk.services.athena.model.ListCapacityReservationsResponse;

public class ListCapacityReservationsPublisher
implements SdkPublisher<ListCapacityReservationsResponse> {
    private final AthenaAsyncClient client;
    private final ListCapacityReservationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCapacityReservationsPublisher(AthenaAsyncClient client, ListCapacityReservationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCapacityReservationsPublisher(AthenaAsyncClient client, ListCapacityReservationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCapacityReservationsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListCapacityReservationsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListCapacityReservationsResponseFetcher
    implements AsyncPageFetcher<ListCapacityReservationsResponse> {
        private ListCapacityReservationsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListCapacityReservationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListCapacityReservationsResponse> nextPage(ListCapacityReservationsResponse previousPage) {
            if (previousPage == null) {
                return ListCapacityReservationsPublisher.this.client.listCapacityReservations(ListCapacityReservationsPublisher.this.firstRequest);
            }
            return ListCapacityReservationsPublisher.this.client.listCapacityReservations((ListCapacityReservationsRequest)ListCapacityReservationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

