/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.DataCatalogSummary;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse;

public class ListDataCatalogsPublisher
implements SdkPublisher<ListDataCatalogsResponse> {
    private final AthenaAsyncClient client;
    private final ListDataCatalogsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataCatalogsPublisher(AthenaAsyncClient client, ListDataCatalogsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataCatalogsPublisher(AthenaAsyncClient client, ListDataCatalogsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataCatalogsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListDataCatalogsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataCatalogSummary> dataCatalogsSummary() {
        Function<ListDataCatalogsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataCatalogsSummary() != null) {
                return response.dataCatalogsSummary().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListDataCatalogsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataCatalogsResponseFetcher
    implements AsyncPageFetcher<ListDataCatalogsResponse> {
        private ListDataCatalogsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListDataCatalogsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListDataCatalogsResponse> nextPage(ListDataCatalogsResponse previousPage) {
            if (previousPage == null) {
                return ListDataCatalogsPublisher.this.client.listDataCatalogs(ListDataCatalogsPublisher.this.firstRequest);
            }
            return ListDataCatalogsPublisher.this.client.listDataCatalogs((ListDataCatalogsRequest)ListDataCatalogsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

