/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest;
import software.amazon.awssdk.services.athena.model.ListEngineVersionsResponse;

public class ListEngineVersionsPublisher
implements SdkPublisher<ListEngineVersionsResponse> {
    private final AthenaAsyncClient client;
    private final ListEngineVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEngineVersionsPublisher(AthenaAsyncClient client, ListEngineVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEngineVersionsPublisher(AthenaAsyncClient client, ListEngineVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEngineVersionsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListEngineVersionsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListEngineVersionsResponseFetcher
    implements AsyncPageFetcher<ListEngineVersionsResponse> {
        private ListEngineVersionsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListEngineVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListEngineVersionsResponse> nextPage(ListEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListEngineVersionsPublisher.this.client.listEngineVersions(ListEngineVersionsPublisher.this.firstRequest);
            }
            return ListEngineVersionsPublisher.this.client.listEngineVersions((ListEngineVersionsRequest)ListEngineVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

