/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse;

public class ListQueryExecutionsIterable
implements SdkIterable<ListQueryExecutionsResponse> {
    private final AthenaClient client;
    private final ListQueryExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQueryExecutionsIterable(AthenaClient client, ListQueryExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListQueryExecutionsResponseFetcher();
    }

    @Override
    public Iterator<ListQueryExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListQueryExecutionsResponseFetcher
    implements SyncPageFetcher<ListQueryExecutionsResponse> {
        private ListQueryExecutionsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListQueryExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListQueryExecutionsResponse nextPage(ListQueryExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListQueryExecutionsIterable.this.client.listQueryExecutions(ListQueryExecutionsIterable.this.firstRequest);
            }
            return ListQueryExecutionsIterable.this.client.listQueryExecutions((ListQueryExecutionsRequest)ListQueryExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

