/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataProductItem;
import software.amazon.awssdk.services.datazone.model.DataProductItemsCopier;
import software.amazon.awssdk.services.datazone.model.DataProductStatus;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.FormOutput;
import software.amazon.awssdk.services.datazone.model.FormOutputListCopier;
import software.amazon.awssdk.services.datazone.model.GlossaryTermsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataProductRevisionResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, CreateDataProductRevisionResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("createdAt").getter(CreateDataProductRevisionResponse.getter(CreateDataProductRevisionResponse::createdAt)).setter(CreateDataProductRevisionResponse.setter(Builder::createdAt)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("createdBy").getter(CreateDataProductRevisionResponse.getter(CreateDataProductRevisionResponse::createdBy)).setter(CreateDataProductRevisionResponse.setter(Builder::createdBy)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("description").getter(CreateDataProductRevisionResponse.getter(CreateDataProductRevisionResponse::description)).setter(CreateDataProductRevisionResponse.setter(Builder::description)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainId").getter(CreateDataProductRevisionResponse.getter(CreateDataProductRevisionResponse::domainId)).setter(CreateDataProductRevisionResponse.setter(Builder::domainId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();
    private static final SdkField<Instant> FIRST_REVISION_CREATED_AT_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("firstRevisionCreatedAt").getter(CreateDataProductRevisionResponse.getter(CreateDataProductRevisionResponse::firstRevisionCreatedAt)).setter(CreateDataProductRevisionResponse.setter(Builder::firstRevisionCreatedAt)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstRevisionCreatedAt").build()).build();
    private static final SdkField<String> FIRST_REVISION_CREATED_BY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("firstRevisionCreatedBy").getter(CreateDataProductRevisionResponse.getter(CreateDataProductRevisionResponse::firstRevisionCreatedBy)).setter(CreateDataProductRevisionResponse.setter(Builder::firstRevisionCreatedBy)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstRevisionCreatedBy").build()).build();
    private static final SdkField<List<FormOutput>> FORMS_OUTPUT_FIELD = SdkField.builder(MarshallingType.LIST).memberName("formsOutput").getter(CreateDataProductRevisionResponse.getter(CreateDataProductRevisionResponse::formsOutput)).setter(CreateDataProductRevisionResponse.setter(Builder::formsOutput)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formsOutput").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(FormOutput::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("glossaryTerms").getter(CreateDataProductRevisionResponse.getter(CreateDataProductRevisionResponse::glossaryTerms)).setter(CreateDataProductRevisionResponse.setter(Builder::glossaryTerms)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("id").getter(CreateDataProductRevisionResponse.getter(CreateDataProductRevisionResponse::id)).setter(CreateDataProductRevisionResponse.setter(Builder::id)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();
    private static final SdkField<List<DataProductItem>> ITEMS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("items").getter(CreateDataProductRevisionResponse.getter(CreateDataProductRevisionResponse::items)).setter(CreateDataProductRevisionResponse.setter(Builder::items)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(DataProductItem::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("name").getter(CreateDataProductRevisionResponse.getter(CreateDataProductRevisionResponse::name)).setter(CreateDataProductRevisionResponse.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();
    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("owningProjectId").getter(CreateDataProductRevisionResponse.getter(CreateDataProductRevisionResponse::owningProjectId)).setter(CreateDataProductRevisionResponse.setter(Builder::owningProjectId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()).build();
    private static final SdkField<String> REVISION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("revision").getter(CreateDataProductRevisionResponse.getter(CreateDataProductRevisionResponse::revision)).setter(CreateDataProductRevisionResponse.setter(Builder::revision)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder(MarshallingType.STRING).memberName("status").getter(CreateDataProductRevisionResponse.getter(CreateDataProductRevisionResponse::statusAsString)).setter(CreateDataProductRevisionResponse.setter(Builder::status)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, FIRST_REVISION_CREATED_AT_FIELD, FIRST_REVISION_CREATED_BY_FIELD, FORMS_OUTPUT_FIELD, GLOSSARY_TERMS_FIELD, ID_FIELD, ITEMS_FIELD, NAME_FIELD, OWNING_PROJECT_ID_FIELD, REVISION_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDataProductRevisionResponse.memberNameToFieldInitializer();
    private final Instant createdAt;
    private final String createdBy;
    private final String description;
    private final String domainId;
    private final Instant firstRevisionCreatedAt;
    private final String firstRevisionCreatedBy;
    private final List<FormOutput> formsOutput;
    private final List<String> glossaryTerms;
    private final String id;
    private final List<DataProductItem> items;
    private final String name;
    private final String owningProjectId;
    private final String revision;
    private final String status;

    private CreateDataProductRevisionResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.firstRevisionCreatedAt = builder.firstRevisionCreatedAt;
        this.firstRevisionCreatedBy = builder.firstRevisionCreatedBy;
        this.formsOutput = builder.formsOutput;
        this.glossaryTerms = builder.glossaryTerms;
        this.id = builder.id;
        this.items = builder.items;
        this.name = builder.name;
        this.owningProjectId = builder.owningProjectId;
        this.revision = builder.revision;
        this.status = builder.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final Instant firstRevisionCreatedAt() {
        return this.firstRevisionCreatedAt;
    }

    public final String firstRevisionCreatedBy() {
        return this.firstRevisionCreatedBy;
    }

    public final boolean hasFormsOutput() {
        return this.formsOutput != null && !(this.formsOutput instanceof SdkAutoConstructList);
    }

    public final List<FormOutput> formsOutput() {
        return this.formsOutput;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<String> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<DataProductItem> items() {
        return this.items;
    }

    public final String name() {
        return this.name;
    }

    public final String owningProjectId() {
        return this.owningProjectId;
    }

    public final String revision() {
        return this.revision;
    }

    public final DataProductStatus status() {
        return DataProductStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstRevisionCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstRevisionCreatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormsOutput() ? this.formsOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataProductRevisionResponse)) {
            return false;
        }
        CreateDataProductRevisionResponse other = (CreateDataProductRevisionResponse)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.firstRevisionCreatedAt(), other.firstRevisionCreatedAt()) && Objects.equals(this.firstRevisionCreatedBy(), other.firstRevisionCreatedBy()) && this.hasFormsOutput() == other.hasFormsOutput() && Objects.equals(this.formsOutput(), other.formsOutput()) && this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && Objects.equals(this.id(), other.id()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owningProjectId(), other.owningProjectId()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder("CreateDataProductRevisionResponse").add("CreatedAt", this.createdAt()).add("CreatedBy", this.createdBy()).add("Description", this.description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", this.domainId()).add("FirstRevisionCreatedAt", this.firstRevisionCreatedAt()).add("FirstRevisionCreatedBy", this.firstRevisionCreatedBy()).add("FormsOutput", this.hasFormsOutput() ? this.formsOutput() : null).add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("Id", this.id()).add("Items", this.hasItems() ? this.items() : null).add("Name", this.name() == null ? null : "*** Sensitive Data Redacted ***").add("OwningProjectId", this.owningProjectId()).add("Revision", this.revision()).add("Status", this.statusAsString()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "firstRevisionCreatedAt": {
                return Optional.ofNullable(clazz.cast(this.firstRevisionCreatedAt()));
            }
            case "firstRevisionCreatedBy": {
                return Optional.ofNullable(clazz.cast(this.firstRevisionCreatedBy()));
            }
            case "formsOutput": {
                return Optional.ofNullable(clazz.cast(this.formsOutput()));
            }
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owningProjectId": {
                return Optional.ofNullable(clazz.cast(this.owningProjectId()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("firstRevisionCreatedAt", FIRST_REVISION_CREATED_AT_FIELD);
        map.put("firstRevisionCreatedBy", FIRST_REVISION_CREATED_BY_FIELD);
        map.put("formsOutput", FORMS_OUTPUT_FIELD);
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("id", ID_FIELD);
        map.put("items", ITEMS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("owningProjectId", OWNING_PROJECT_ID_FIELD);
        map.put("revision", REVISION_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataProductRevisionResponse, T> g) {
        return obj -> g.apply((CreateDataProductRevisionResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String createdBy;
        private String description;
        private String domainId;
        private Instant firstRevisionCreatedAt;
        private String firstRevisionCreatedBy;
        private List<FormOutput> formsOutput = DefaultSdkAutoConstructList.getInstance();
        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private List<DataProductItem> items = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String owningProjectId;
        private String revision;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataProductRevisionResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.description(model.description);
            this.domainId(model.domainId);
            this.firstRevisionCreatedAt(model.firstRevisionCreatedAt);
            this.firstRevisionCreatedBy(model.firstRevisionCreatedBy);
            this.formsOutput(model.formsOutput);
            this.glossaryTerms(model.glossaryTerms);
            this.id(model.id);
            this.items(model.items);
            this.name(model.name);
            this.owningProjectId(model.owningProjectId);
            this.revision(model.revision);
            this.status(model.status);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Instant getFirstRevisionCreatedAt() {
            return this.firstRevisionCreatedAt;
        }

        public final void setFirstRevisionCreatedAt(Instant firstRevisionCreatedAt) {
            this.firstRevisionCreatedAt = firstRevisionCreatedAt;
        }

        @Override
        public final Builder firstRevisionCreatedAt(Instant firstRevisionCreatedAt) {
            this.firstRevisionCreatedAt = firstRevisionCreatedAt;
            return this;
        }

        public final String getFirstRevisionCreatedBy() {
            return this.firstRevisionCreatedBy;
        }

        public final void setFirstRevisionCreatedBy(String firstRevisionCreatedBy) {
            this.firstRevisionCreatedBy = firstRevisionCreatedBy;
        }

        @Override
        public final Builder firstRevisionCreatedBy(String firstRevisionCreatedBy) {
            this.firstRevisionCreatedBy = firstRevisionCreatedBy;
            return this;
        }

        public final List<FormOutput.Builder> getFormsOutput() {
            List<FormOutput.Builder> result = FormOutputListCopier.copyToBuilder(this.formsOutput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFormsOutput(Collection<FormOutput.BuilderImpl> formsOutput) {
            this.formsOutput = FormOutputListCopier.copyFromBuilder(formsOutput);
        }

        @Override
        public final Builder formsOutput(Collection<FormOutput> formsOutput) {
            this.formsOutput = FormOutputListCopier.copy(formsOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsOutput(FormOutput ... formsOutput) {
            this.formsOutput(Arrays.asList(formsOutput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsOutput(Consumer<FormOutput.Builder> ... formsOutput) {
            this.formsOutput(Stream.of(formsOutput).map(c -> (FormOutput)((FormOutput.Builder)FormOutput.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (this.glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<DataProductItem.Builder> getItems() {
            List<DataProductItem.Builder> result = DataProductItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<DataProductItem.BuilderImpl> items) {
            this.items = DataProductItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<DataProductItem> items) {
            this.items = DataProductItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(DataProductItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<DataProductItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (DataProductItem)((DataProductItem.Builder)DataProductItem.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectId() {
            return this.owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public final String getRevision() {
            return this.revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataProductStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateDataProductRevisionResponse build() {
            return new CreateDataProductRevisionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataProductRevisionResponse> {
        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder firstRevisionCreatedAt(Instant var1);

        public Builder firstRevisionCreatedBy(String var1);

        public Builder formsOutput(Collection<FormOutput> var1);

        public Builder formsOutput(FormOutput ... var1);

        public Builder formsOutput(Consumer<FormOutput.Builder> ... var1);

        public Builder glossaryTerms(Collection<String> var1);

        public Builder glossaryTerms(String ... var1);

        public Builder id(String var1);

        public Builder items(Collection<DataProductItem> var1);

        public Builder items(DataProductItem ... var1);

        public Builder items(Consumer<DataProductItem.Builder> ... var1);

        public Builder name(String var1);

        public Builder owningProjectId(String var1);

        public Builder revision(String var1);

        public Builder status(String var1);

        public Builder status(DataProductStatus var1);
    }
}

