/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.Member;
import software.amazon.awssdk.services.datazone.model.UserDesignation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProjectMembershipRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateProjectMembershipRequest> {
    private static final SdkField<String> DESIGNATION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("designation").getter(CreateProjectMembershipRequest.getter(CreateProjectMembershipRequest::designationAsString)).setter(CreateProjectMembershipRequest.setter(Builder::designation)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("designation").build()).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainIdentifier").getter(CreateProjectMembershipRequest.getter(CreateProjectMembershipRequest::domainIdentifier)).setter(CreateProjectMembershipRequest.setter(Builder::domainIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();
    private static final SdkField<Member> MEMBER_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("member").getter(CreateProjectMembershipRequest.getter(CreateProjectMembershipRequest::member)).setter(CreateProjectMembershipRequest.setter(Builder::member)).constructor(Member::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build();
    private static final SdkField<String> PROJECT_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("projectIdentifier").getter(CreateProjectMembershipRequest.getter(CreateProjectMembershipRequest::projectIdentifier)).setter(CreateProjectMembershipRequest.setter(Builder::projectIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectIdentifier").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIGNATION_FIELD, DOMAIN_IDENTIFIER_FIELD, MEMBER_FIELD, PROJECT_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProjectMembershipRequest.memberNameToFieldInitializer();
    private final String designation;
    private final String domainIdentifier;
    private final Member member;
    private final String projectIdentifier;

    private CreateProjectMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.designation = builder.designation;
        this.domainIdentifier = builder.domainIdentifier;
        this.member = builder.member;
        this.projectIdentifier = builder.projectIdentifier;
    }

    public final UserDesignation designation() {
        return UserDesignation.fromValue(this.designation);
    }

    public final String designationAsString() {
        return this.designation;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final Member member() {
        return this.member;
    }

    public final String projectIdentifier() {
        return this.projectIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.designationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.member());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectMembershipRequest)) {
            return false;
        }
        CreateProjectMembershipRequest other = (CreateProjectMembershipRequest)obj;
        return Objects.equals(this.designationAsString(), other.designationAsString()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.member(), other.member()) && Objects.equals(this.projectIdentifier(), other.projectIdentifier());
    }

    public final String toString() {
        return ToString.builder("CreateProjectMembershipRequest").add("Designation", this.designationAsString()).add("DomainIdentifier", this.domainIdentifier()).add("Member", this.member()).add("ProjectIdentifier", this.projectIdentifier()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "designation": {
                return Optional.ofNullable(clazz.cast(this.designationAsString()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "member": {
                return Optional.ofNullable(clazz.cast(this.member()));
            }
            case "projectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.projectIdentifier()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("designation", DESIGNATION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("member", MEMBER_FIELD);
        map.put("projectIdentifier", PROJECT_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectMembershipRequest, T> g) {
        return obj -> g.apply((CreateProjectMembershipRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String designation;
        private String domainIdentifier;
        private Member member;
        private String projectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectMembershipRequest model) {
            super(model);
            this.designation(model.designation);
            this.domainIdentifier(model.domainIdentifier);
            this.member(model.member);
            this.projectIdentifier(model.projectIdentifier);
        }

        public final String getDesignation() {
            return this.designation;
        }

        public final void setDesignation(String designation) {
            this.designation = designation;
        }

        @Override
        public final Builder designation(String designation) {
            this.designation = designation;
            return this;
        }

        @Override
        public final Builder designation(UserDesignation designation) {
            this.designation(designation == null ? null : designation.toString());
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Member.Builder getMember() {
            return this.member != null ? this.member.toBuilder() : null;
        }

        public final void setMember(Member.BuilderImpl member) {
            this.member = member != null ? member.build() : null;
        }

        @Override
        public final Builder member(Member member) {
            this.member = member;
            return this;
        }

        public final String getProjectIdentifier() {
            return this.projectIdentifier;
        }

        public final void setProjectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
        }

        @Override
        public final Builder projectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProjectMembershipRequest build() {
            return new CreateProjectMembershipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProjectMembershipRequest> {
        public Builder designation(String var1);

        public Builder designation(UserDesignation var1);

        public Builder domainIdentifier(String var1);

        public Builder member(Member var1);

        default public Builder member(Consumer<Member.Builder> member) {
            return this.member((Member)Member.builder().applyMutation(member).build());
        }

        public Builder projectIdentifier(String var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

