/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.GlueRunConfigurationOutput;
import software.amazon.awssdk.services.datazone.model.RedshiftRunConfigurationOutput;
import software.amazon.awssdk.services.datazone.model.SageMakerRunConfigurationOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceConfigurationOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceConfigurationOutput> {
    private static final SdkField<GlueRunConfigurationOutput> GLUE_RUN_CONFIGURATION_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("glueRunConfiguration").getter(DataSourceConfigurationOutput.getter(DataSourceConfigurationOutput::glueRunConfiguration)).setter(DataSourceConfigurationOutput.setter(Builder::glueRunConfiguration)).constructor(GlueRunConfigurationOutput::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueRunConfiguration").build()).build();
    private static final SdkField<RedshiftRunConfigurationOutput> REDSHIFT_RUN_CONFIGURATION_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("redshiftRunConfiguration").getter(DataSourceConfigurationOutput.getter(DataSourceConfigurationOutput::redshiftRunConfiguration)).setter(DataSourceConfigurationOutput.setter(Builder::redshiftRunConfiguration)).constructor(RedshiftRunConfigurationOutput::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftRunConfiguration").build()).build();
    private static final SdkField<SageMakerRunConfigurationOutput> SAGE_MAKER_RUN_CONFIGURATION_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("sageMakerRunConfiguration").getter(DataSourceConfigurationOutput.getter(DataSourceConfigurationOutput::sageMakerRunConfiguration)).setter(DataSourceConfigurationOutput.setter(Builder::sageMakerRunConfiguration)).constructor(SageMakerRunConfigurationOutput::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sageMakerRunConfiguration").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLUE_RUN_CONFIGURATION_FIELD, REDSHIFT_RUN_CONFIGURATION_FIELD, SAGE_MAKER_RUN_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSourceConfigurationOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GlueRunConfigurationOutput glueRunConfiguration;
    private final RedshiftRunConfigurationOutput redshiftRunConfiguration;
    private final SageMakerRunConfigurationOutput sageMakerRunConfiguration;
    private final Type type;

    private DataSourceConfigurationOutput(BuilderImpl builder) {
        this.glueRunConfiguration = builder.glueRunConfiguration;
        this.redshiftRunConfiguration = builder.redshiftRunConfiguration;
        this.sageMakerRunConfiguration = builder.sageMakerRunConfiguration;
        this.type = builder.type;
    }

    public final GlueRunConfigurationOutput glueRunConfiguration() {
        return this.glueRunConfiguration;
    }

    public final RedshiftRunConfigurationOutput redshiftRunConfiguration() {
        return this.redshiftRunConfiguration;
    }

    public final SageMakerRunConfigurationOutput sageMakerRunConfiguration() {
        return this.sageMakerRunConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.glueRunConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftRunConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sageMakerRunConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfigurationOutput)) {
            return false;
        }
        DataSourceConfigurationOutput other = (DataSourceConfigurationOutput)obj;
        return Objects.equals(this.glueRunConfiguration(), other.glueRunConfiguration()) && Objects.equals(this.redshiftRunConfiguration(), other.redshiftRunConfiguration()) && Objects.equals(this.sageMakerRunConfiguration(), other.sageMakerRunConfiguration());
    }

    public final String toString() {
        return ToString.builder("DataSourceConfigurationOutput").add("GlueRunConfiguration", this.glueRunConfiguration()).add("RedshiftRunConfiguration", this.redshiftRunConfiguration()).add("SageMakerRunConfiguration", this.sageMakerRunConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "glueRunConfiguration": {
                return Optional.ofNullable(clazz.cast(this.glueRunConfiguration()));
            }
            case "redshiftRunConfiguration": {
                return Optional.ofNullable(clazz.cast(this.redshiftRunConfiguration()));
            }
            case "sageMakerRunConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sageMakerRunConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static DataSourceConfigurationOutput fromGlueRunConfiguration(GlueRunConfigurationOutput glueRunConfiguration) {
        return (DataSourceConfigurationOutput)DataSourceConfigurationOutput.builder().glueRunConfiguration(glueRunConfiguration).build();
    }

    public static DataSourceConfigurationOutput fromGlueRunConfiguration(Consumer<GlueRunConfigurationOutput.Builder> glueRunConfiguration) {
        GlueRunConfigurationOutput.Builder builder = GlueRunConfigurationOutput.builder();
        glueRunConfiguration.accept(builder);
        return DataSourceConfigurationOutput.fromGlueRunConfiguration((GlueRunConfigurationOutput)builder.build());
    }

    public static DataSourceConfigurationOutput fromRedshiftRunConfiguration(RedshiftRunConfigurationOutput redshiftRunConfiguration) {
        return (DataSourceConfigurationOutput)DataSourceConfigurationOutput.builder().redshiftRunConfiguration(redshiftRunConfiguration).build();
    }

    public static DataSourceConfigurationOutput fromRedshiftRunConfiguration(Consumer<RedshiftRunConfigurationOutput.Builder> redshiftRunConfiguration) {
        RedshiftRunConfigurationOutput.Builder builder = RedshiftRunConfigurationOutput.builder();
        redshiftRunConfiguration.accept(builder);
        return DataSourceConfigurationOutput.fromRedshiftRunConfiguration((RedshiftRunConfigurationOutput)builder.build());
    }

    public static DataSourceConfigurationOutput fromSageMakerRunConfiguration(SageMakerRunConfigurationOutput sageMakerRunConfiguration) {
        return (DataSourceConfigurationOutput)DataSourceConfigurationOutput.builder().sageMakerRunConfiguration(sageMakerRunConfiguration).build();
    }

    public static DataSourceConfigurationOutput fromSageMakerRunConfiguration(Consumer<SageMakerRunConfigurationOutput.Builder> sageMakerRunConfiguration) {
        SageMakerRunConfigurationOutput.Builder builder = SageMakerRunConfigurationOutput.builder();
        sageMakerRunConfiguration.accept(builder);
        return DataSourceConfigurationOutput.fromSageMakerRunConfiguration((SageMakerRunConfigurationOutput)builder.build());
    }

    public Type type() {
        return this.type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SdkPojo>> map = new HashMap<String, SdkField<SdkPojo>>();
        map.put("glueRunConfiguration", GLUE_RUN_CONFIGURATION_FIELD);
        map.put("redshiftRunConfiguration", REDSHIFT_RUN_CONFIGURATION_FIELD);
        map.put("sageMakerRunConfiguration", SAGE_MAKER_RUN_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfigurationOutput, T> g) {
        return obj -> g.apply((DataSourceConfigurationOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GlueRunConfigurationOutput glueRunConfiguration;
        private RedshiftRunConfigurationOutput redshiftRunConfiguration;
        private SageMakerRunConfigurationOutput sageMakerRunConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfigurationOutput model) {
            this.glueRunConfiguration(model.glueRunConfiguration);
            this.redshiftRunConfiguration(model.redshiftRunConfiguration);
            this.sageMakerRunConfiguration(model.sageMakerRunConfiguration);
        }

        public final GlueRunConfigurationOutput.Builder getGlueRunConfiguration() {
            return this.glueRunConfiguration != null ? this.glueRunConfiguration.toBuilder() : null;
        }

        public final void setGlueRunConfiguration(GlueRunConfigurationOutput.BuilderImpl glueRunConfiguration) {
            GlueRunConfigurationOutput oldValue = this.glueRunConfiguration;
            this.glueRunConfiguration = glueRunConfiguration != null ? glueRunConfiguration.build() : null;
            this.handleUnionValueChange(Type.GLUE_RUN_CONFIGURATION, oldValue, this.glueRunConfiguration);
        }

        @Override
        public final Builder glueRunConfiguration(GlueRunConfigurationOutput glueRunConfiguration) {
            GlueRunConfigurationOutput oldValue = this.glueRunConfiguration;
            this.glueRunConfiguration = glueRunConfiguration;
            this.handleUnionValueChange(Type.GLUE_RUN_CONFIGURATION, oldValue, this.glueRunConfiguration);
            return this;
        }

        public final RedshiftRunConfigurationOutput.Builder getRedshiftRunConfiguration() {
            return this.redshiftRunConfiguration != null ? this.redshiftRunConfiguration.toBuilder() : null;
        }

        public final void setRedshiftRunConfiguration(RedshiftRunConfigurationOutput.BuilderImpl redshiftRunConfiguration) {
            RedshiftRunConfigurationOutput oldValue = this.redshiftRunConfiguration;
            this.redshiftRunConfiguration = redshiftRunConfiguration != null ? redshiftRunConfiguration.build() : null;
            this.handleUnionValueChange(Type.REDSHIFT_RUN_CONFIGURATION, oldValue, this.redshiftRunConfiguration);
        }

        @Override
        public final Builder redshiftRunConfiguration(RedshiftRunConfigurationOutput redshiftRunConfiguration) {
            RedshiftRunConfigurationOutput oldValue = this.redshiftRunConfiguration;
            this.redshiftRunConfiguration = redshiftRunConfiguration;
            this.handleUnionValueChange(Type.REDSHIFT_RUN_CONFIGURATION, oldValue, this.redshiftRunConfiguration);
            return this;
        }

        public final SageMakerRunConfigurationOutput.Builder getSageMakerRunConfiguration() {
            return this.sageMakerRunConfiguration != null ? this.sageMakerRunConfiguration.toBuilder() : null;
        }

        public final void setSageMakerRunConfiguration(SageMakerRunConfigurationOutput.BuilderImpl sageMakerRunConfiguration) {
            SageMakerRunConfigurationOutput oldValue = this.sageMakerRunConfiguration;
            this.sageMakerRunConfiguration = sageMakerRunConfiguration != null ? sageMakerRunConfiguration.build() : null;
            this.handleUnionValueChange(Type.SAGE_MAKER_RUN_CONFIGURATION, oldValue, this.sageMakerRunConfiguration);
        }

        @Override
        public final Builder sageMakerRunConfiguration(SageMakerRunConfigurationOutput sageMakerRunConfiguration) {
            SageMakerRunConfigurationOutput oldValue = this.sageMakerRunConfiguration;
            this.sageMakerRunConfiguration = sageMakerRunConfiguration;
            this.handleUnionValueChange(Type.SAGE_MAKER_RUN_CONFIGURATION, oldValue, this.sageMakerRunConfiguration);
            return this;
        }

        @Override
        public DataSourceConfigurationOutput build() {
            return new DataSourceConfigurationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static enum Type {
        GLUE_RUN_CONFIGURATION,
        REDSHIFT_RUN_CONFIGURATION,
        SAGE_MAKER_RUN_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceConfigurationOutput> {
        public Builder glueRunConfiguration(GlueRunConfigurationOutput var1);

        default public Builder glueRunConfiguration(Consumer<GlueRunConfigurationOutput.Builder> glueRunConfiguration) {
            return this.glueRunConfiguration((GlueRunConfigurationOutput)GlueRunConfigurationOutput.builder().applyMutation(glueRunConfiguration).build());
        }

        public Builder redshiftRunConfiguration(RedshiftRunConfigurationOutput var1);

        default public Builder redshiftRunConfiguration(Consumer<RedshiftRunConfigurationOutput.Builder> redshiftRunConfiguration) {
            return this.redshiftRunConfiguration((RedshiftRunConfigurationOutput)RedshiftRunConfigurationOutput.builder().applyMutation(redshiftRunConfiguration).build());
        }

        public Builder sageMakerRunConfiguration(SageMakerRunConfigurationOutput var1);

        default public Builder sageMakerRunConfiguration(Consumer<SageMakerRunConfigurationOutput.Builder> sageMakerRunConfiguration) {
            return this.sageMakerRunConfiguration((SageMakerRunConfigurationOutput)SageMakerRunConfigurationOutput.builder().applyMutation(sageMakerRunConfiguration).build());
        }
    }
}

