/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.Filter;
import software.amazon.awssdk.services.datazone.model.FilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterClause
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterClause> {
    private static final SdkField<List<FilterClause>> AND_FIELD = SdkField.builder(MarshallingType.LIST).memberName("and").getter(FilterClause.getter(FilterClause::and)).setter(FilterClause.setter(Builder::and)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("and").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(FilterClause::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<Filter> FILTER_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("filter").getter(FilterClause.getter(FilterClause::filter)).setter(FilterClause.setter(Builder::filter)).constructor(Filter::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();
    private static final SdkField<List<FilterClause>> OR_FIELD = SdkField.builder(MarshallingType.LIST).memberName("or").getter(FilterClause.getter(FilterClause::or)).setter(FilterClause.setter(Builder::or)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("or").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(FilterClause::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AND_FIELD, FILTER_FIELD, OR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FilterClause.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<FilterClause> and;
    private final Filter filter;
    private final List<FilterClause> or;
    private final Type type;

    private FilterClause(BuilderImpl builder) {
        this.and = builder.and;
        this.filter = builder.filter;
        this.or = builder.or;
        this.type = builder.type;
    }

    public final boolean hasAnd() {
        return this.and != null && !(this.and instanceof SdkAutoConstructList);
    }

    public final List<FilterClause> and() {
        return this.and;
    }

    public final Filter filter() {
        return this.filter;
    }

    public final boolean hasOr() {
        return this.or != null && !(this.or instanceof SdkAutoConstructList);
    }

    public final List<FilterClause> or() {
        return this.or;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnd() ? this.and() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOr() ? this.or() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterClause)) {
            return false;
        }
        FilterClause other = (FilterClause)obj;
        return this.hasAnd() == other.hasAnd() && Objects.equals(this.and(), other.and()) && Objects.equals(this.filter(), other.filter()) && this.hasOr() == other.hasOr() && Objects.equals(this.or(), other.or());
    }

    public final String toString() {
        return ToString.builder("FilterClause").add("And", this.hasAnd() ? this.and() : null).add("Filter", this.filter()).add("Or", this.hasOr() ? this.or() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "and": {
                return Optional.ofNullable(clazz.cast(this.and()));
            }
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "or": {
                return Optional.ofNullable(clazz.cast(this.or()));
            }
        }
        return Optional.empty();
    }

    public static FilterClause fromAnd(List<FilterClause> and) {
        return (FilterClause)FilterClause.builder().and(and).build();
    }

    public static FilterClause fromFilter(Filter filter) {
        return (FilterClause)FilterClause.builder().filter(filter).build();
    }

    public static FilterClause fromFilter(Consumer<Filter.Builder> filter) {
        Filter.Builder builder = Filter.builder();
        filter.accept(builder);
        return FilterClause.fromFilter((Filter)builder.build());
    }

    public static FilterClause fromOr(List<FilterClause> or) {
        return (FilterClause)FilterClause.builder().or(or).build();
    }

    public Type type() {
        return this.type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("and", AND_FIELD);
        map.put("filter", FILTER_FIELD);
        map.put("or", OR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterClause, T> g) {
        return obj -> g.apply((FilterClause)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FilterClause> and = DefaultSdkAutoConstructList.getInstance();
        private Filter filter;
        private List<FilterClause> or = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FilterClause model) {
            this.and(model.and);
            this.filter(model.filter);
            this.or(model.or);
        }

        public final List<Builder> getAnd() {
            List<Builder> result = FilterListCopier.copyToBuilder(this.and);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnd(Collection<BuilderImpl> and) {
            List<FilterClause> oldValue = this.and;
            this.and = FilterListCopier.copyFromBuilder(and);
            this.handleUnionValueChange(Type.AND, oldValue, this.and);
        }

        @Override
        public final Builder and(Collection<FilterClause> and) {
            List<FilterClause> oldValue = this.and;
            this.and = FilterListCopier.copy(and);
            this.handleUnionValueChange(Type.AND, oldValue, this.and);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(FilterClause ... and) {
            this.and(Arrays.asList(and));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Consumer<Builder> ... and) {
            this.and(Stream.of(and).map(c -> (FilterClause)((Builder)FilterClause.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Filter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(Filter.BuilderImpl filter) {
            Filter oldValue = this.filter;
            this.filter = filter != null ? filter.build() : null;
            this.handleUnionValueChange(Type.FILTER, oldValue, this.filter);
        }

        @Override
        public final Builder filter(Filter filter) {
            Filter oldValue = this.filter;
            this.filter = filter;
            this.handleUnionValueChange(Type.FILTER, oldValue, this.filter);
            return this;
        }

        public final List<Builder> getOr() {
            List<Builder> result = FilterListCopier.copyToBuilder(this.or);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOr(Collection<BuilderImpl> or) {
            List<FilterClause> oldValue = this.or;
            this.or = FilterListCopier.copyFromBuilder(or);
            this.handleUnionValueChange(Type.OR, oldValue, this.or);
        }

        @Override
        public final Builder or(Collection<FilterClause> or) {
            List<FilterClause> oldValue = this.or;
            this.or = FilterListCopier.copy(or);
            this.handleUnionValueChange(Type.OR, oldValue, this.or);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(FilterClause ... or) {
            this.or(Arrays.asList(or));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Consumer<Builder> ... or) {
            this.or(Stream.of(or).map(c -> (FilterClause)((Builder)FilterClause.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public FilterClause build() {
            return new FilterClause(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static enum Type {
        AND,
        FILTER,
        OR,
        UNKNOWN_TO_SDK_VERSION;

    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterClause> {
        public Builder and(Collection<FilterClause> var1);

        public Builder and(FilterClause ... var1);

        public Builder and(Consumer<Builder> ... var1);

        public Builder filter(Filter var1);

        default public Builder filter(Consumer<Filter.Builder> filter) {
            return this.filter((Filter)Filter.builder().applyMutation(filter).build());
        }

        public Builder or(Collection<FilterClause> var1);

        public Builder or(FilterClause ... var1);

        public Builder or(Consumer<Builder> ... var1);
    }
}

