/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.datazone.model.FilterExpressionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterExpression> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("expression").getter(FilterExpression.getter(FilterExpression::expression)).setter(FilterExpression.setter(Builder::expression)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("type").getter(FilterExpression.getter(FilterExpression::typeAsString)).setter(FilterExpression.setter(Builder::type)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FilterExpression.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String expression;
    private final String type;

    private FilterExpression(BuilderImpl builder) {
        this.expression = builder.expression;
        this.type = builder.type;
    }

    public final String expression() {
        return this.expression;
    }

    public final FilterExpressionType type() {
        return FilterExpressionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterExpression)) {
            return false;
        }
        FilterExpression other = (FilterExpression)obj;
        return Objects.equals(this.expression(), other.expression()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder("FilterExpression").add("Expression", this.expression()).add("Type", this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("expression", EXPRESSION_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterExpression, T> g) {
        return obj -> g.apply((FilterExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String expression;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterExpression model) {
            this.expression(model.expression);
            this.type(model.type);
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FilterExpressionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public FilterExpression build() {
            return new FilterExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterExpression> {
        public Builder expression(String var1);

        public Builder type(String var1);

        public Builder type(FilterExpressionType var1);
    }
}

