/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.ConnectionCredentials;
import software.amazon.awssdk.services.datazone.model.ConnectionPropertiesOutput;
import software.amazon.awssdk.services.datazone.model.ConnectionType;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.PhysicalEndpoint;
import software.amazon.awssdk.services.datazone.model.PhysicalEndpointsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConnectionResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, GetConnectionResponse> {
    private static final SdkField<ConnectionCredentials> CONNECTION_CREDENTIALS_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("connectionCredentials").getter(GetConnectionResponse.getter(GetConnectionResponse::connectionCredentials)).setter(GetConnectionResponse.setter(Builder::connectionCredentials)).constructor(ConnectionCredentials::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionCredentials").build()).build();
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("connectionId").getter(GetConnectionResponse.getter(GetConnectionResponse::connectionId)).setter(GetConnectionResponse.setter(Builder::connectionId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("description").getter(GetConnectionResponse.getter(GetConnectionResponse::description)).setter(GetConnectionResponse.setter(Builder::description)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainId").getter(GetConnectionResponse.getter(GetConnectionResponse::domainId)).setter(GetConnectionResponse.setter(Builder::domainId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();
    private static final SdkField<String> DOMAIN_UNIT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainUnitId").getter(GetConnectionResponse.getter(GetConnectionResponse::domainUnitId)).setter(GetConnectionResponse.setter(Builder::domainUnitId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitId").build()).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("environmentId").getter(GetConnectionResponse.getter(GetConnectionResponse::environmentId)).setter(GetConnectionResponse.setter(Builder::environmentId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();
    private static final SdkField<String> ENVIRONMENT_USER_ROLE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("environmentUserRole").getter(GetConnectionResponse.getter(GetConnectionResponse::environmentUserRole)).setter(GetConnectionResponse.setter(Builder::environmentUserRole)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentUserRole").build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("name").getter(GetConnectionResponse.getter(GetConnectionResponse::name)).setter(GetConnectionResponse.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();
    private static final SdkField<List<PhysicalEndpoint>> PHYSICAL_ENDPOINTS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("physicalEndpoints").getter(GetConnectionResponse.getter(GetConnectionResponse::physicalEndpoints)).setter(GetConnectionResponse.setter(Builder::physicalEndpoints)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(PhysicalEndpoint::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("projectId").getter(GetConnectionResponse.getter(GetConnectionResponse::projectId)).setter(GetConnectionResponse.setter(Builder::projectId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();
    private static final SdkField<ConnectionPropertiesOutput> PROPS_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("props").getter(GetConnectionResponse.getter(GetConnectionResponse::props)).setter(GetConnectionResponse.setter(Builder::props)).constructor(ConnectionPropertiesOutput::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("props").build()).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("type").getter(GetConnectionResponse.getter(GetConnectionResponse::typeAsString)).setter(GetConnectionResponse.setter(Builder::type)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_CREDENTIALS_FIELD, CONNECTION_ID_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, DOMAIN_UNIT_ID_FIELD, ENVIRONMENT_ID_FIELD, ENVIRONMENT_USER_ROLE_FIELD, NAME_FIELD, PHYSICAL_ENDPOINTS_FIELD, PROJECT_ID_FIELD, PROPS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetConnectionResponse.memberNameToFieldInitializer();
    private final ConnectionCredentials connectionCredentials;
    private final String connectionId;
    private final String description;
    private final String domainId;
    private final String domainUnitId;
    private final String environmentId;
    private final String environmentUserRole;
    private final String name;
    private final List<PhysicalEndpoint> physicalEndpoints;
    private final String projectId;
    private final ConnectionPropertiesOutput props;
    private final String type;

    private GetConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.connectionCredentials = builder.connectionCredentials;
        this.connectionId = builder.connectionId;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.domainUnitId = builder.domainUnitId;
        this.environmentId = builder.environmentId;
        this.environmentUserRole = builder.environmentUserRole;
        this.name = builder.name;
        this.physicalEndpoints = builder.physicalEndpoints;
        this.projectId = builder.projectId;
        this.props = builder.props;
        this.type = builder.type;
    }

    public final ConnectionCredentials connectionCredentials() {
        return this.connectionCredentials;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String domainUnitId() {
        return this.domainUnitId;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String environmentUserRole() {
        return this.environmentUserRole;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasPhysicalEndpoints() {
        return this.physicalEndpoints != null && !(this.physicalEndpoints instanceof SdkAutoConstructList);
    }

    public final List<PhysicalEndpoint> physicalEndpoints() {
        return this.physicalEndpoints;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final ConnectionPropertiesOutput props() {
        return this.props;
    }

    public final ConnectionType type() {
        return ConnectionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentUserRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhysicalEndpoints() ? this.physicalEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.props());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionResponse)) {
            return false;
        }
        GetConnectionResponse other = (GetConnectionResponse)obj;
        return Objects.equals(this.connectionCredentials(), other.connectionCredentials()) && Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.domainUnitId(), other.domainUnitId()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.environmentUserRole(), other.environmentUserRole()) && Objects.equals(this.name(), other.name()) && this.hasPhysicalEndpoints() == other.hasPhysicalEndpoints() && Objects.equals(this.physicalEndpoints(), other.physicalEndpoints()) && Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.props(), other.props()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder("GetConnectionResponse").add("ConnectionCredentials", this.connectionCredentials() == null ? null : "*** Sensitive Data Redacted ***").add("ConnectionId", this.connectionId()).add("Description", this.description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", this.domainId()).add("DomainUnitId", this.domainUnitId()).add("EnvironmentId", this.environmentId()).add("EnvironmentUserRole", this.environmentUserRole()).add("Name", this.name()).add("PhysicalEndpoints", this.hasPhysicalEndpoints() ? this.physicalEndpoints() : null).add("ProjectId", this.projectId()).add("Props", this.props()).add("Type", this.typeAsString()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionCredentials": {
                return Optional.ofNullable(clazz.cast(this.connectionCredentials()));
            }
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "domainUnitId": {
                return Optional.ofNullable(clazz.cast(this.domainUnitId()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "environmentUserRole": {
                return Optional.ofNullable(clazz.cast(this.environmentUserRole()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "physicalEndpoints": {
                return Optional.ofNullable(clazz.cast(this.physicalEndpoints()));
            }
            case "projectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "props": {
                return Optional.ofNullable(clazz.cast(this.props()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("connectionCredentials", CONNECTION_CREDENTIALS_FIELD);
        map.put("connectionId", CONNECTION_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("domainUnitId", DOMAIN_UNIT_ID_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("environmentUserRole", ENVIRONMENT_USER_ROLE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("physicalEndpoints", PHYSICAL_ENDPOINTS_FIELD);
        map.put("projectId", PROJECT_ID_FIELD);
        map.put("props", PROPS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionResponse, T> g) {
        return obj -> g.apply((GetConnectionResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private ConnectionCredentials connectionCredentials;
        private String connectionId;
        private String description;
        private String domainId;
        private String domainUnitId;
        private String environmentId;
        private String environmentUserRole;
        private String name;
        private List<PhysicalEndpoint> physicalEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String projectId;
        private ConnectionPropertiesOutput props;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionResponse model) {
            super(model);
            this.connectionCredentials(model.connectionCredentials);
            this.connectionId(model.connectionId);
            this.description(model.description);
            this.domainId(model.domainId);
            this.domainUnitId(model.domainUnitId);
            this.environmentId(model.environmentId);
            this.environmentUserRole(model.environmentUserRole);
            this.name(model.name);
            this.physicalEndpoints(model.physicalEndpoints);
            this.projectId(model.projectId);
            this.props(model.props);
            this.type(model.type);
        }

        public final ConnectionCredentials.Builder getConnectionCredentials() {
            return this.connectionCredentials != null ? this.connectionCredentials.toBuilder() : null;
        }

        public final void setConnectionCredentials(ConnectionCredentials.BuilderImpl connectionCredentials) {
            this.connectionCredentials = connectionCredentials != null ? connectionCredentials.build() : null;
        }

        @Override
        public final Builder connectionCredentials(ConnectionCredentials connectionCredentials) {
            this.connectionCredentials = connectionCredentials;
            return this;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainUnitId() {
            return this.domainUnitId;
        }

        public final void setDomainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
        }

        @Override
        public final Builder domainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getEnvironmentUserRole() {
            return this.environmentUserRole;
        }

        public final void setEnvironmentUserRole(String environmentUserRole) {
            this.environmentUserRole = environmentUserRole;
        }

        @Override
        public final Builder environmentUserRole(String environmentUserRole) {
            this.environmentUserRole = environmentUserRole;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<PhysicalEndpoint.Builder> getPhysicalEndpoints() {
            List<PhysicalEndpoint.Builder> result = PhysicalEndpointsCopier.copyToBuilder(this.physicalEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhysicalEndpoints(Collection<PhysicalEndpoint.BuilderImpl> physicalEndpoints) {
            this.physicalEndpoints = PhysicalEndpointsCopier.copyFromBuilder(physicalEndpoints);
        }

        @Override
        public final Builder physicalEndpoints(Collection<PhysicalEndpoint> physicalEndpoints) {
            this.physicalEndpoints = PhysicalEndpointsCopier.copy(physicalEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder physicalEndpoints(PhysicalEndpoint ... physicalEndpoints) {
            this.physicalEndpoints(Arrays.asList(physicalEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder physicalEndpoints(Consumer<PhysicalEndpoint.Builder> ... physicalEndpoints) {
            this.physicalEndpoints(Stream.of(physicalEndpoints).map(c -> (PhysicalEndpoint)((PhysicalEndpoint.Builder)PhysicalEndpoint.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final ConnectionPropertiesOutput.Builder getProps() {
            return this.props != null ? this.props.toBuilder() : null;
        }

        public final void setProps(ConnectionPropertiesOutput.BuilderImpl props) {
            this.props = props != null ? props.build() : null;
        }

        @Override
        public final Builder props(ConnectionPropertiesOutput props) {
            this.props = props;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ConnectionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public GetConnectionResponse build() {
            return new GetConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConnectionResponse> {
        public Builder connectionCredentials(ConnectionCredentials var1);

        default public Builder connectionCredentials(Consumer<ConnectionCredentials.Builder> connectionCredentials) {
            return this.connectionCredentials((ConnectionCredentials)ConnectionCredentials.builder().applyMutation(connectionCredentials).build());
        }

        public Builder connectionId(String var1);

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder domainUnitId(String var1);

        public Builder environmentId(String var1);

        public Builder environmentUserRole(String var1);

        public Builder name(String var1);

        public Builder physicalEndpoints(Collection<PhysicalEndpoint> var1);

        public Builder physicalEndpoints(PhysicalEndpoint ... var1);

        public Builder physicalEndpoints(Consumer<PhysicalEndpoint.Builder> ... var1);

        public Builder projectId(String var1);

        public Builder props(ConnectionPropertiesOutput var1);

        default public Builder props(Consumer<ConnectionPropertiesOutput.Builder> props) {
            return this.props((ConnectionPropertiesOutput)ConnectionPropertiesOutput.builder().applyMutation(props).build());
        }

        public Builder type(String var1);

        public Builder type(ConnectionType var1);
    }
}

