/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.OwnerGroupProperties;
import software.amazon.awssdk.services.datazone.model.OwnerUserProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OwnerProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OwnerProperties> {
    private static final SdkField<OwnerGroupProperties> GROUP_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("group").getter(OwnerProperties.getter(OwnerProperties::group)).setter(OwnerProperties.setter(Builder::group)).constructor(OwnerGroupProperties::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();
    private static final SdkField<OwnerUserProperties> USER_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("user").getter(OwnerProperties.getter(OwnerProperties::user)).setter(OwnerProperties.setter(Builder::user)).constructor(OwnerUserProperties::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, USER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OwnerProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final OwnerGroupProperties group;
    private final OwnerUserProperties user;
    private final Type type;

    private OwnerProperties(BuilderImpl builder) {
        this.group = builder.group;
        this.user = builder.user;
        this.type = builder.type;
    }

    public final OwnerGroupProperties group() {
        return this.group;
    }

    public final OwnerUserProperties user() {
        return this.user;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OwnerProperties)) {
            return false;
        }
        OwnerProperties other = (OwnerProperties)obj;
        return Objects.equals(this.group(), other.group()) && Objects.equals(this.user(), other.user());
    }

    public final String toString() {
        return ToString.builder("OwnerProperties").add("Group", this.group()).add("User", this.user()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "user": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
        }
        return Optional.empty();
    }

    public static OwnerProperties fromGroup(OwnerGroupProperties group) {
        return (OwnerProperties)OwnerProperties.builder().group(group).build();
    }

    public static OwnerProperties fromGroup(Consumer<OwnerGroupProperties.Builder> group) {
        OwnerGroupProperties.Builder builder = OwnerGroupProperties.builder();
        group.accept(builder);
        return OwnerProperties.fromGroup((OwnerGroupProperties)builder.build());
    }

    public static OwnerProperties fromUser(OwnerUserProperties user) {
        return (OwnerProperties)OwnerProperties.builder().user(user).build();
    }

    public static OwnerProperties fromUser(Consumer<OwnerUserProperties.Builder> user) {
        OwnerUserProperties.Builder builder = OwnerUserProperties.builder();
        user.accept(builder);
        return OwnerProperties.fromUser((OwnerUserProperties)builder.build());
    }

    public Type type() {
        return this.type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SdkPojo>> map = new HashMap<String, SdkField<SdkPojo>>();
        map.put("group", GROUP_FIELD);
        map.put("user", USER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OwnerProperties, T> g) {
        return obj -> g.apply((OwnerProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OwnerGroupProperties group;
        private OwnerUserProperties user;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OwnerProperties model) {
            this.group(model.group);
            this.user(model.user);
        }

        public final OwnerGroupProperties.Builder getGroup() {
            return this.group != null ? this.group.toBuilder() : null;
        }

        public final void setGroup(OwnerGroupProperties.BuilderImpl group) {
            OwnerGroupProperties oldValue = this.group;
            this.group = group != null ? group.build() : null;
            this.handleUnionValueChange(Type.GROUP, oldValue, this.group);
        }

        @Override
        public final Builder group(OwnerGroupProperties group) {
            OwnerGroupProperties oldValue = this.group;
            this.group = group;
            this.handleUnionValueChange(Type.GROUP, oldValue, this.group);
            return this;
        }

        public final OwnerUserProperties.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        public final void setUser(OwnerUserProperties.BuilderImpl user) {
            OwnerUserProperties oldValue = this.user;
            this.user = user != null ? user.build() : null;
            this.handleUnionValueChange(Type.USER, oldValue, this.user);
        }

        @Override
        public final Builder user(OwnerUserProperties user) {
            OwnerUserProperties oldValue = this.user;
            this.user = user;
            this.handleUnionValueChange(Type.USER, oldValue, this.user);
            return this;
        }

        @Override
        public OwnerProperties build() {
            return new OwnerProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static enum Type {
        GROUP,
        USER,
        UNKNOWN_TO_SDK_VERSION;

    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OwnerProperties> {
        public Builder group(OwnerGroupProperties var1);

        default public Builder group(Consumer<OwnerGroupProperties.Builder> group) {
            return this.group((OwnerGroupProperties)OwnerGroupProperties.builder().applyMutation(group).build());
        }

        public Builder user(OwnerUserProperties var1);

        default public Builder user(Consumer<OwnerUserProperties.Builder> user) {
            return this.user((OwnerUserProperties)OwnerUserProperties.builder().applyMutation(user).build());
        }
    }
}

