/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.TrackingAssetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SageMakerRunConfigurationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SageMakerRunConfigurationInput> {
    private static final SdkField<Map<String, List<String>>> TRACKING_ASSETS_FIELD = SdkField.builder(MarshallingType.MAP).memberName("trackingAssets").getter(SageMakerRunConfigurationInput.getter(SageMakerRunConfigurationInput::trackingAssets)).setter(SageMakerRunConfigurationInput.setter(Builder::trackingAssets)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingAssets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.LIST).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_ASSETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SageMakerRunConfigurationInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, List<String>> trackingAssets;

    private SageMakerRunConfigurationInput(BuilderImpl builder) {
        this.trackingAssets = builder.trackingAssets;
    }

    public final boolean hasTrackingAssets() {
        return this.trackingAssets != null && !(this.trackingAssets instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> trackingAssets() {
        return this.trackingAssets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrackingAssets() ? this.trackingAssets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SageMakerRunConfigurationInput)) {
            return false;
        }
        SageMakerRunConfigurationInput other = (SageMakerRunConfigurationInput)obj;
        return this.hasTrackingAssets() == other.hasTrackingAssets() && Objects.equals(this.trackingAssets(), other.trackingAssets());
    }

    public final String toString() {
        return ToString.builder("SageMakerRunConfigurationInput").add("TrackingAssets", this.hasTrackingAssets() ? this.trackingAssets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "trackingAssets": {
                return Optional.ofNullable(clazz.cast(this.trackingAssets()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, List<String>>>> map = new HashMap<String, SdkField<Map<String, List<String>>>>();
        map.put("trackingAssets", TRACKING_ASSETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SageMakerRunConfigurationInput, T> g) {
        return obj -> g.apply((SageMakerRunConfigurationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, List<String>> trackingAssets = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SageMakerRunConfigurationInput model) {
            this.trackingAssets(model.trackingAssets);
        }

        public final Map<String, ? extends Collection<String>> getTrackingAssets() {
            if (this.trackingAssets instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.trackingAssets;
        }

        public final void setTrackingAssets(Map<String, ? extends Collection<String>> trackingAssets) {
            this.trackingAssets = TrackingAssetsCopier.copy(trackingAssets);
        }

        @Override
        public final Builder trackingAssets(Map<String, ? extends Collection<String>> trackingAssets) {
            this.trackingAssets = TrackingAssetsCopier.copy(trackingAssets);
            return this;
        }

        @Override
        public SageMakerRunConfigurationInput build() {
            return new SageMakerRunConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SageMakerRunConfigurationInput> {
        public Builder trackingAssets(Map<String, ? extends Collection<String>> var1);
    }
}

