/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.FilterClause;
import software.amazon.awssdk.services.datazone.model.SearchInItem;
import software.amazon.awssdk.services.datazone.model.SearchInListCopier;
import software.amazon.awssdk.services.datazone.model.SearchSort;
import software.amazon.awssdk.services.datazone.model.TypesSearchScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchTypesRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, SearchTypesRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainIdentifier").getter(SearchTypesRequest.getter(SearchTypesRequest::domainIdentifier)).setter(SearchTypesRequest.setter(Builder::domainIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();
    private static final SdkField<FilterClause> FILTERS_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("filters").getter(SearchTypesRequest.getter(SearchTypesRequest::filters)).setter(SearchTypesRequest.setter(Builder::filters)).constructor(FilterClause::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build()).build();
    private static final SdkField<Boolean> MANAGED_FIELD = SdkField.builder(MarshallingType.BOOLEAN).memberName("managed").getter(SearchTypesRequest.getter(SearchTypesRequest::managed)).setter(SearchTypesRequest.setter(Builder::managed)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managed").build()).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("maxResults").getter(SearchTypesRequest.getter(SearchTypesRequest::maxResults)).setter(SearchTypesRequest.setter(Builder::maxResults)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("nextToken").getter(SearchTypesRequest.getter(SearchTypesRequest::nextToken)).setter(SearchTypesRequest.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();
    private static final SdkField<List<SearchInItem>> SEARCH_IN_FIELD = SdkField.builder(MarshallingType.LIST).memberName("searchIn").getter(SearchTypesRequest.getter(SearchTypesRequest::searchIn)).setter(SearchTypesRequest.setter(Builder::searchIn)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchIn").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(SearchInItem::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> SEARCH_SCOPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("searchScope").getter(SearchTypesRequest.getter(SearchTypesRequest::searchScopeAsString)).setter(SearchTypesRequest.setter(Builder::searchScope)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchScope").build()).build();
    private static final SdkField<String> SEARCH_TEXT_FIELD = SdkField.builder(MarshallingType.STRING).memberName("searchText").getter(SearchTypesRequest.getter(SearchTypesRequest::searchText)).setter(SearchTypesRequest.setter(Builder::searchText)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchText").build()).build();
    private static final SdkField<SearchSort> SORT_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("sort").getter(SearchTypesRequest.getter(SearchTypesRequest::sort)).setter(SearchTypesRequest.setter(Builder::sort)).constructor(SearchSort::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD, FILTERS_FIELD, MANAGED_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SEARCH_IN_FIELD, SEARCH_SCOPE_FIELD, SEARCH_TEXT_FIELD, SORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchTypesRequest.memberNameToFieldInitializer();
    private final String domainIdentifier;
    private final FilterClause filters;
    private final Boolean managed;
    private final Integer maxResults;
    private final String nextToken;
    private final List<SearchInItem> searchIn;
    private final String searchScope;
    private final String searchText;
    private final SearchSort sort;

    private SearchTypesRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.filters = builder.filters;
        this.managed = builder.managed;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.searchIn = builder.searchIn;
        this.searchScope = builder.searchScope;
        this.searchText = builder.searchText;
        this.sort = builder.sort;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final FilterClause filters() {
        return this.filters;
    }

    public final Boolean managed() {
        return this.managed;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSearchIn() {
        return this.searchIn != null && !(this.searchIn instanceof SdkAutoConstructList);
    }

    public final List<SearchInItem> searchIn() {
        return this.searchIn;
    }

    public final TypesSearchScope searchScope() {
        return TypesSearchScope.fromValue(this.searchScope);
    }

    public final String searchScopeAsString() {
        return this.searchScope;
    }

    public final String searchText() {
        return this.searchText;
    }

    public final SearchSort sort() {
        return this.sort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.managed());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSearchIn() ? this.searchIn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.searchScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchText());
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTypesRequest)) {
            return false;
        }
        SearchTypesRequest other = (SearchTypesRequest)obj;
        return Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.managed(), other.managed()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasSearchIn() == other.hasSearchIn() && Objects.equals(this.searchIn(), other.searchIn()) && Objects.equals(this.searchScopeAsString(), other.searchScopeAsString()) && Objects.equals(this.searchText(), other.searchText()) && Objects.equals(this.sort(), other.sort());
    }

    public final String toString() {
        return ToString.builder("SearchTypesRequest").add("DomainIdentifier", this.domainIdentifier()).add("Filters", this.filters()).add("Managed", this.managed()).add("MaxResults", this.maxResults()).add("NextToken", this.nextToken()).add("SearchIn", this.hasSearchIn() ? this.searchIn() : null).add("SearchScope", this.searchScopeAsString()).add("SearchText", this.searchText()).add("Sort", this.sort()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "managed": {
                return Optional.ofNullable(clazz.cast(this.managed()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "searchIn": {
                return Optional.ofNullable(clazz.cast(this.searchIn()));
            }
            case "searchScope": {
                return Optional.ofNullable(clazz.cast(this.searchScopeAsString()));
            }
            case "searchText": {
                return Optional.ofNullable(clazz.cast(this.searchText()));
            }
            case "sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("managed", MANAGED_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("searchIn", SEARCH_IN_FIELD);
        map.put("searchScope", SEARCH_SCOPE_FIELD);
        map.put("searchText", SEARCH_TEXT_FIELD);
        map.put("sort", SORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchTypesRequest, T> g) {
        return obj -> g.apply((SearchTypesRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String domainIdentifier;
        private FilterClause filters;
        private Boolean managed;
        private Integer maxResults;
        private String nextToken;
        private List<SearchInItem> searchIn = DefaultSdkAutoConstructList.getInstance();
        private String searchScope;
        private String searchText;
        private SearchSort sort;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTypesRequest model) {
            super(model);
            this.domainIdentifier(model.domainIdentifier);
            this.filters(model.filters);
            this.managed(model.managed);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.searchIn(model.searchIn);
            this.searchScope(model.searchScope);
            this.searchText(model.searchText);
            this.sort(model.sort);
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final FilterClause.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(FilterClause.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(FilterClause filters) {
            this.filters = filters;
            return this;
        }

        public final Boolean getManaged() {
            return this.managed;
        }

        public final void setManaged(Boolean managed) {
            this.managed = managed;
        }

        @Override
        public final Builder managed(Boolean managed) {
            this.managed = managed;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SearchInItem.Builder> getSearchIn() {
            List<SearchInItem.Builder> result = SearchInListCopier.copyToBuilder(this.searchIn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSearchIn(Collection<SearchInItem.BuilderImpl> searchIn) {
            this.searchIn = SearchInListCopier.copyFromBuilder(searchIn);
        }

        @Override
        public final Builder searchIn(Collection<SearchInItem> searchIn) {
            this.searchIn = SearchInListCopier.copy(searchIn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchIn(SearchInItem ... searchIn) {
            this.searchIn(Arrays.asList(searchIn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchIn(Consumer<SearchInItem.Builder> ... searchIn) {
            this.searchIn(Stream.of(searchIn).map(c -> (SearchInItem)((SearchInItem.Builder)SearchInItem.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSearchScope() {
            return this.searchScope;
        }

        public final void setSearchScope(String searchScope) {
            this.searchScope = searchScope;
        }

        @Override
        public final Builder searchScope(String searchScope) {
            this.searchScope = searchScope;
            return this;
        }

        @Override
        public final Builder searchScope(TypesSearchScope searchScope) {
            this.searchScope(searchScope == null ? null : searchScope.toString());
            return this;
        }

        public final String getSearchText() {
            return this.searchText;
        }

        public final void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        @Override
        public final Builder searchText(String searchText) {
            this.searchText = searchText;
            return this;
        }

        public final SearchSort.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(SearchSort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(SearchSort sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchTypesRequest build() {
            return new SearchTypesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchTypesRequest> {
        public Builder domainIdentifier(String var1);

        public Builder filters(FilterClause var1);

        default public Builder filters(Consumer<FilterClause.Builder> filters) {
            return this.filters((FilterClause)FilterClause.builder().applyMutation(filters).build());
        }

        public Builder managed(Boolean var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder searchIn(Collection<SearchInItem> var1);

        public Builder searchIn(SearchInItem ... var1);

        public Builder searchIn(Consumer<SearchInItem.Builder> ... var1);

        public Builder searchScope(String var1);

        public Builder searchScope(TypesSearchScope var1);

        public Builder searchText(String var1);

        public Builder sort(SearchSort var1);

        default public Builder sort(Consumer<SearchSort.Builder> sort) {
            return this.sort((SearchSort)SearchSort.builder().applyMutation(sort).build());
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

