/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeSeriesDataPointFormInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeSeriesDataPointFormInput> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder(MarshallingType.STRING).memberName("content").getter(TimeSeriesDataPointFormInput.getter(TimeSeriesDataPointFormInput::content)).setter(TimeSeriesDataPointFormInput.setter(Builder::content)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();
    private static final SdkField<String> FORM_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("formName").getter(TimeSeriesDataPointFormInput.getter(TimeSeriesDataPointFormInput::formName)).setter(TimeSeriesDataPointFormInput.setter(Builder::formName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formName").build()).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("timestamp").getter(TimeSeriesDataPointFormInput.getter(TimeSeriesDataPointFormInput::timestamp)).setter(TimeSeriesDataPointFormInput.setter(Builder::timestamp)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();
    private static final SdkField<String> TYPE_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("typeIdentifier").getter(TimeSeriesDataPointFormInput.getter(TimeSeriesDataPointFormInput::typeIdentifier)).setter(TimeSeriesDataPointFormInput.setter(Builder::typeIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeIdentifier").build()).build();
    private static final SdkField<String> TYPE_REVISION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("typeRevision").getter(TimeSeriesDataPointFormInput.getter(TimeSeriesDataPointFormInput::typeRevision)).setter(TimeSeriesDataPointFormInput.setter(Builder::typeRevision)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeRevision").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, FORM_NAME_FIELD, TIMESTAMP_FIELD, TYPE_IDENTIFIER_FIELD, TYPE_REVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TimeSeriesDataPointFormInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String content;
    private final String formName;
    private final Instant timestamp;
    private final String typeIdentifier;
    private final String typeRevision;

    private TimeSeriesDataPointFormInput(BuilderImpl builder) {
        this.content = builder.content;
        this.formName = builder.formName;
        this.timestamp = builder.timestamp;
        this.typeIdentifier = builder.typeIdentifier;
        this.typeRevision = builder.typeRevision;
    }

    public final String content() {
        return this.content;
    }

    public final String formName() {
        return this.formName;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final String typeIdentifier() {
        return this.typeIdentifier;
    }

    public final String typeRevision() {
        return this.typeRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.formName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeRevision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesDataPointFormInput)) {
            return false;
        }
        TimeSeriesDataPointFormInput other = (TimeSeriesDataPointFormInput)obj;
        return Objects.equals(this.content(), other.content()) && Objects.equals(this.formName(), other.formName()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.typeIdentifier(), other.typeIdentifier()) && Objects.equals(this.typeRevision(), other.typeRevision());
    }

    public final String toString() {
        return ToString.builder("TimeSeriesDataPointFormInput").add("Content", this.content()).add("FormName", this.formName()).add("Timestamp", this.timestamp()).add("TypeIdentifier", this.typeIdentifier()).add("TypeRevision", this.typeRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "formName": {
                return Optional.ofNullable(clazz.cast(this.formName()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "typeIdentifier": {
                return Optional.ofNullable(clazz.cast(this.typeIdentifier()));
            }
            case "typeRevision": {
                return Optional.ofNullable(clazz.cast(this.typeRevision()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("content", CONTENT_FIELD);
        map.put("formName", FORM_NAME_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("typeIdentifier", TYPE_IDENTIFIER_FIELD);
        map.put("typeRevision", TYPE_REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesDataPointFormInput, T> g) {
        return obj -> g.apply((TimeSeriesDataPointFormInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String content;
        private String formName;
        private Instant timestamp;
        private String typeIdentifier;
        private String typeRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesDataPointFormInput model) {
            this.content(model.content);
            this.formName(model.formName);
            this.timestamp(model.timestamp);
            this.typeIdentifier(model.typeIdentifier);
            this.typeRevision(model.typeRevision);
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getFormName() {
            return this.formName;
        }

        public final void setFormName(String formName) {
            this.formName = formName;
        }

        @Override
        public final Builder formName(String formName) {
            this.formName = formName;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getTypeIdentifier() {
            return this.typeIdentifier;
        }

        public final void setTypeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
        }

        @Override
        public final Builder typeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
            return this;
        }

        public final String getTypeRevision() {
            return this.typeRevision;
        }

        public final void setTypeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
        }

        @Override
        public final Builder typeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
            return this;
        }

        @Override
        public TimeSeriesDataPointFormInput build() {
            return new TimeSeriesDataPointFormInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeSeriesDataPointFormInput> {
        public Builder content(String var1);

        public Builder formName(String var1);

        public Builder timestamp(Instant var1);

        public Builder typeIdentifier(String var1);

        public Builder typeRevision(String var1);
    }
}

