/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.AssetFilterSummary;
import software.amazon.awssdk.services.datazone.model.ListAssetFiltersRequest;
import software.amazon.awssdk.services.datazone.model.ListAssetFiltersResponse;

public class ListAssetFiltersPublisher
implements SdkPublisher<ListAssetFiltersResponse> {
    private final DataZoneAsyncClient client;
    private final ListAssetFiltersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssetFiltersPublisher(DataZoneAsyncClient client, ListAssetFiltersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssetFiltersPublisher(DataZoneAsyncClient client, ListAssetFiltersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssetFiltersResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListAssetFiltersResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssetFilterSummary> items() {
        Function<ListAssetFiltersResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListAssetFiltersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssetFiltersResponseFetcher
    implements AsyncPageFetcher<ListAssetFiltersResponse> {
        private ListAssetFiltersResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListAssetFiltersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListAssetFiltersResponse> nextPage(ListAssetFiltersResponse previousPage) {
            if (previousPage == null) {
                return ListAssetFiltersPublisher.this.client.listAssetFilters(ListAssetFiltersPublisher.this.firstRequest);
            }
            return ListAssetFiltersPublisher.this.client.listAssetFilters((ListAssetFiltersRequest)ListAssetFiltersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

