/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.EnvironmentProfileSummary;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesResponse;

public class ListEnvironmentProfilesPublisher
implements SdkPublisher<ListEnvironmentProfilesResponse> {
    private final DataZoneAsyncClient client;
    private final ListEnvironmentProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnvironmentProfilesPublisher(DataZoneAsyncClient client, ListEnvironmentProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnvironmentProfilesPublisher(DataZoneAsyncClient client, ListEnvironmentProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnvironmentProfilesResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListEnvironmentProfilesResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EnvironmentProfileSummary> items() {
        Function<ListEnvironmentProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListEnvironmentProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEnvironmentProfilesResponseFetcher
    implements AsyncPageFetcher<ListEnvironmentProfilesResponse> {
        private ListEnvironmentProfilesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListEnvironmentProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListEnvironmentProfilesResponse> nextPage(ListEnvironmentProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentProfilesPublisher.this.client.listEnvironmentProfiles(ListEnvironmentProfilesPublisher.this.firstRequest);
            }
            return ListEnvironmentProfilesPublisher.this.client.listEnvironmentProfiles((ListEnvironmentProfilesRequest)ListEnvironmentProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

