/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.JobRunSummary;
import software.amazon.awssdk.services.datazone.model.ListJobRunsRequest;
import software.amazon.awssdk.services.datazone.model.ListJobRunsResponse;

public class ListJobRunsIterable
implements SdkIterable<ListJobRunsResponse> {
    private final DataZoneClient client;
    private final ListJobRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJobRunsIterable(DataZoneClient client, ListJobRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListJobRunsResponseFetcher();
    }

    @Override
    public Iterator<ListJobRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobRunSummary> items() {
        Function<ListJobRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListJobRunsResponseFetcher
    implements SyncPageFetcher<ListJobRunsResponse> {
        private ListJobRunsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListJobRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListJobRunsResponse nextPage(ListJobRunsResponse previousPage) {
            if (previousPage == null) {
                return ListJobRunsIterable.this.client.listJobRuns(ListJobRunsIterable.this.firstRequest);
            }
            return ListJobRunsIterable.this.client.listJobRuns((ListJobRunsRequest)ListJobRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

