/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest;
import software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsResponse;
import software.amazon.awssdk.services.datazone.model.MetadataGenerationRunItem;

public class ListMetadataGenerationRunsPublisher
implements SdkPublisher<ListMetadataGenerationRunsResponse> {
    private final DataZoneAsyncClient client;
    private final ListMetadataGenerationRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMetadataGenerationRunsPublisher(DataZoneAsyncClient client, ListMetadataGenerationRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMetadataGenerationRunsPublisher(DataZoneAsyncClient client, ListMetadataGenerationRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMetadataGenerationRunsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListMetadataGenerationRunsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MetadataGenerationRunItem> items() {
        Function<ListMetadataGenerationRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListMetadataGenerationRunsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMetadataGenerationRunsResponseFetcher
    implements AsyncPageFetcher<ListMetadataGenerationRunsResponse> {
        private ListMetadataGenerationRunsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListMetadataGenerationRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListMetadataGenerationRunsResponse> nextPage(ListMetadataGenerationRunsResponse previousPage) {
            if (previousPage == null) {
                return ListMetadataGenerationRunsPublisher.this.client.listMetadataGenerationRuns(ListMetadataGenerationRunsPublisher.this.firstRequest);
            }
            return ListMetadataGenerationRunsPublisher.this.client.listMetadataGenerationRuns((ListMetadataGenerationRunsRequest)ListMetadataGenerationRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

