/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListProjectMembershipsRequest;
import software.amazon.awssdk.services.datazone.model.ListProjectMembershipsResponse;
import software.amazon.awssdk.services.datazone.model.ProjectMember;

public class ListProjectMembershipsPublisher
implements SdkPublisher<ListProjectMembershipsResponse> {
    private final DataZoneAsyncClient client;
    private final ListProjectMembershipsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProjectMembershipsPublisher(DataZoneAsyncClient client, ListProjectMembershipsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProjectMembershipsPublisher(DataZoneAsyncClient client, ListProjectMembershipsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProjectMembershipsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListProjectMembershipsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProjectMember> members() {
        Function<ListProjectMembershipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListProjectMembershipsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProjectMembershipsResponseFetcher
    implements AsyncPageFetcher<ListProjectMembershipsResponse> {
        private ListProjectMembershipsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListProjectMembershipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListProjectMembershipsResponse> nextPage(ListProjectMembershipsResponse previousPage) {
            if (previousPage == null) {
                return ListProjectMembershipsPublisher.this.client.listProjectMemberships(ListProjectMembershipsPublisher.this.firstRequest);
            }
            return ListProjectMembershipsPublisher.this.client.listProjectMemberships((ListProjectMembershipsRequest)ListProjectMembershipsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

