/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListRulesRequest;
import software.amazon.awssdk.services.datazone.model.ListRulesResponse;
import software.amazon.awssdk.services.datazone.model.RuleSummary;

public class ListRulesIterable
implements SdkIterable<ListRulesResponse> {
    private final DataZoneClient client;
    private final ListRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRulesIterable(DataZoneClient client, ListRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRulesResponseFetcher();
    }

    @Override
    public Iterator<ListRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RuleSummary> items() {
        Function<ListRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListRulesResponseFetcher
    implements SyncPageFetcher<ListRulesResponse> {
        private ListRulesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListRulesResponse nextPage(ListRulesResponse previousPage) {
            if (previousPage == null) {
                return ListRulesIterable.this.client.listRules(ListRulesIterable.this.firstRequest);
            }
            return ListRulesIterable.this.client.listRules((ListRulesRequest)ListRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

