/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsResponse;
import software.amazon.awssdk.services.datazone.model.SubscriptionGrantSummary;

public class ListSubscriptionGrantsIterable
implements SdkIterable<ListSubscriptionGrantsResponse> {
    private final DataZoneClient client;
    private final ListSubscriptionGrantsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSubscriptionGrantsIterable(DataZoneClient client, ListSubscriptionGrantsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSubscriptionGrantsResponseFetcher();
    }

    @Override
    public Iterator<ListSubscriptionGrantsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SubscriptionGrantSummary> items() {
        Function<ListSubscriptionGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListSubscriptionGrantsResponseFetcher
    implements SyncPageFetcher<ListSubscriptionGrantsResponse> {
        private ListSubscriptionGrantsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListSubscriptionGrantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListSubscriptionGrantsResponse nextPage(ListSubscriptionGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListSubscriptionGrantsIterable.this.client.listSubscriptionGrants(ListSubscriptionGrantsIterable.this.firstRequest);
            }
            return ListSubscriptionGrantsIterable.this.client.listSubscriptionGrants((ListSubscriptionGrantsRequest)ListSubscriptionGrantsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

