/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.GroupProfileSummary;
import software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest;
import software.amazon.awssdk.services.datazone.model.SearchGroupProfilesResponse;

public class SearchGroupProfilesIterable
implements SdkIterable<SearchGroupProfilesResponse> {
    private final DataZoneClient client;
    private final SearchGroupProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchGroupProfilesIterable(DataZoneClient client, SearchGroupProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchGroupProfilesResponseFetcher();
    }

    @Override
    public Iterator<SearchGroupProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GroupProfileSummary> items() {
        Function<SearchGroupProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class SearchGroupProfilesResponseFetcher
    implements SyncPageFetcher<SearchGroupProfilesResponse> {
        private SearchGroupProfilesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(SearchGroupProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public SearchGroupProfilesResponse nextPage(SearchGroupProfilesResponse previousPage) {
            if (previousPage == null) {
                return SearchGroupProfilesIterable.this.client.searchGroupProfiles(SearchGroupProfilesIterable.this.firstRequest);
            }
            return SearchGroupProfilesIterable.this.client.searchGroupProfiles((SearchGroupProfilesRequest)SearchGroupProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

