/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.SearchListingsRequest;
import software.amazon.awssdk.services.datazone.model.SearchListingsResponse;
import software.amazon.awssdk.services.datazone.model.SearchResultItem;

public class SearchListingsIterable
implements SdkIterable<SearchListingsResponse> {
    private final DataZoneClient client;
    private final SearchListingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchListingsIterable(DataZoneClient client, SearchListingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchListingsResponseFetcher();
    }

    @Override
    public Iterator<SearchListingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SearchResultItem> items() {
        Function<SearchListingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class SearchListingsResponseFetcher
    implements SyncPageFetcher<SearchListingsResponse> {
        private SearchListingsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(SearchListingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public SearchListingsResponse nextPage(SearchListingsResponse previousPage) {
            if (previousPage == null) {
                return SearchListingsIterable.this.client.searchListings(SearchListingsIterable.this.firstRequest);
            }
            return SearchListingsIterable.this.client.searchListings((SearchListingsRequest)SearchListingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

