/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.protocols.core.OperationInfo;
import software.amazon.awssdk.protocols.core.ProtocolMarshaller;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.services.datazone.model.GetDataSourceRunRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetDataSourceRunRequestMarshaller
implements Marshaller<GetDataSourceRunRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/v2/domains/{domainIdentifier}/data-source-runs/{identifier}").httpMethod(SdkHttpMethod.GET).hasExplicitPayloadMember(false).hasImplicitPayloadMembers(false).hasPayloadMembers(false).build();
    private final BaseAwsJsonProtocolFactory protocolFactory;

    public GetDataSourceRunRequestMarshaller(BaseAwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public SdkHttpFullRequest marshall(GetDataSourceRunRequest getDataSourceRunRequest) {
        Validate.paramNotNull(getDataSourceRunRequest, "getDataSourceRunRequest");
        try {
            ProtocolMarshaller<SdkHttpFullRequest> protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING);
            return protocolMarshaller.marshall(getDataSourceRunRequest);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}

