/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.LakeFormationServiceClientConfiguration;
import software.amazon.awssdk.services.lakeformation.internal.LakeFormationServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.lakeformation.model.AccessDeniedException;
import software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.AlreadyExistsException;
import software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlRequest;
import software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlResponse;
import software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.CancelTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.CancelTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.CommitTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.CommitTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.ConcurrentModificationException;
import software.amazon.awssdk.services.lakeformation.model.CreateDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLakeFormationIdentityCenterConfigurationRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLakeFormationIdentityCenterConfigurationResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLakeFormationOptInRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLakeFormationOptInResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagExpressionRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagExpressionResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLakeFormationIdentityCenterConfigurationRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLakeFormationIdentityCenterConfigurationResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLakeFormationOptInRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLakeFormationOptInResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagExpressionRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagExpressionResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteObjectsOnCancelRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteObjectsOnCancelResponse;
import software.amazon.awssdk.services.lakeformation.model.DeregisterResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.DeregisterResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.DescribeLakeFormationIdentityCenterConfigurationRequest;
import software.amazon.awssdk.services.lakeformation.model.DescribeLakeFormationIdentityCenterConfigurationResponse;
import software.amazon.awssdk.services.lakeformation.model.DescribeResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.DescribeResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.DescribeTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.DescribeTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.EntityNotFoundException;
import software.amazon.awssdk.services.lakeformation.model.ExpiredException;
import software.amazon.awssdk.services.lakeformation.model.ExtendTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.ExtendTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakePrincipalRequest;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakePrincipalResponse;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagExpressionRequest;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagExpressionResponse;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStateRequest;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStateResponse;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetResourceLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetResourceLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitResultsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitResultsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsResponse;
import software.amazon.awssdk.services.lakeformation.model.GlueEncryptionException;
import software.amazon.awssdk.services.lakeformation.model.GrantPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.GrantPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.InternalServiceException;
import software.amazon.awssdk.services.lakeformation.model.InvalidInputException;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationException;
import software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.ListLakeFormationOptInsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLakeFormationOptInsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagExpressionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagExpressionsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse;
import software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest;
import software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse;
import software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse;
import software.amazon.awssdk.services.lakeformation.model.OperationTimeoutException;
import software.amazon.awssdk.services.lakeformation.model.PermissionTypeMismatchException;
import software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsRequest;
import software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsResponse;
import software.amazon.awssdk.services.lakeformation.model.RegisterResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.RegisterResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.RemoveLfTagsFromResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.RemoveLfTagsFromResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.ResourceNotReadyException;
import software.amazon.awssdk.services.lakeformation.model.ResourceNumberLimitExceededException;
import software.amazon.awssdk.services.lakeformation.model.RevokePermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.RevokePermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningRequest;
import software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningResponse;
import software.amazon.awssdk.services.lakeformation.model.StartTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.StartTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.StatisticsNotReadyYetException;
import software.amazon.awssdk.services.lakeformation.model.ThrottledException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCanceledException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCommitInProgressException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCommittedException;
import software.amazon.awssdk.services.lakeformation.model.UpdateDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateLakeFormationIdentityCenterConfigurationRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateLakeFormationIdentityCenterConfigurationResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagExpressionRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagExpressionResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableObjectsRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableObjectsResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerResponse;
import software.amazon.awssdk.services.lakeformation.model.WorkUnitsNotReadyYetException;
import software.amazon.awssdk.services.lakeformation.transform.AddLfTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.AssumeDecoratedRoleWithSamlRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.BatchGrantPermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.BatchRevokePermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CancelTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CommitTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CreateDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CreateLakeFormationIdentityCenterConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CreateLakeFormationOptInRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CreateLfTagExpressionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CreateLfTagRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteLakeFormationIdentityCenterConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteLakeFormationOptInRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteLfTagExpressionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteLfTagRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteObjectsOnCancelRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeregisterResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DescribeLakeFormationIdentityCenterConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DescribeResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DescribeTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ExtendTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetDataLakePrincipalRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetDataLakeSettingsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetEffectivePermissionsForPathRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetLfTagExpressionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetLfTagRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetQueryStateRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetQueryStatisticsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetResourceLfTagsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetTableObjectsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetTemporaryGluePartitionCredentialsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetTemporaryGlueTableCredentialsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetWorkUnitResultsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetWorkUnitsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GrantPermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListLakeFormationOptInsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListLfTagExpressionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListLfTagsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListPermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListResourcesRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListTableStorageOptimizersRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListTransactionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.PutDataLakeSettingsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.RegisterResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.RemoveLfTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.RevokePermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.SearchDatabasesByLfTagsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.SearchTablesByLfTagsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.StartQueryPlanningRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.StartTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateLakeFormationIdentityCenterConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateLfTagExpressionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateLfTagRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateTableObjectsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateTableStorageOptimizerRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultLakeFormationClient
implements LakeFormationClient {
    private static final Logger log = Logger.loggerFor(DefaultLakeFormationClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLakeFormationClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).option(SdkClientOption.API_METADATA, "LakeFormation#2.33.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddLfTagsToResourceResponse addLFTagsToResource(AddLfTagsToResourceRequest addLfTagsToResourceRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddLfTagsToResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(addLfTagsToResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, addLfTagsToResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddLFTagsToResource");
            AddLfTagsToResourceResponse addLfTagsToResourceResponse = (AddLfTagsToResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddLFTagsToResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(addLfTagsToResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new AddLfTagsToResourceRequestMarshaller(this.protocolFactory)));
            return addLfTagsToResourceResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssumeDecoratedRoleWithSamlResponse assumeDecoratedRoleWithSAML(AssumeDecoratedRoleWithSamlRequest assumeDecoratedRoleWithSamlRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssumeDecoratedRoleWithSamlResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(assumeDecoratedRoleWithSamlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, assumeDecoratedRoleWithSamlRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeDecoratedRoleWithSAML");
            AssumeDecoratedRoleWithSamlResponse assumeDecoratedRoleWithSamlResponse = (AssumeDecoratedRoleWithSamlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeDecoratedRoleWithSAML").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(assumeDecoratedRoleWithSamlRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new AssumeDecoratedRoleWithSamlRequestMarshaller(this.protocolFactory)));
            return assumeDecoratedRoleWithSamlResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGrantPermissionsResponse batchGrantPermissions(BatchGrantPermissionsRequest batchGrantPermissionsRequest) throws InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGrantPermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(batchGrantPermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, batchGrantPermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGrantPermissions");
            BatchGrantPermissionsResponse batchGrantPermissionsResponse = (BatchGrantPermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGrantPermissions").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(batchGrantPermissionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new BatchGrantPermissionsRequestMarshaller(this.protocolFactory)));
            return batchGrantPermissionsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchRevokePermissionsResponse batchRevokePermissions(BatchRevokePermissionsRequest batchRevokePermissionsRequest) throws InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchRevokePermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(batchRevokePermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, batchRevokePermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchRevokePermissions");
            BatchRevokePermissionsResponse batchRevokePermissionsResponse = (BatchRevokePermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchRevokePermissions").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(batchRevokePermissionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new BatchRevokePermissionsRequestMarshaller(this.protocolFactory)));
            return batchRevokePermissionsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelTransactionResponse cancelTransaction(CancelTransactionRequest cancelTransactionRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, TransactionCommittedException, TransactionCommitInProgressException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelTransactionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(cancelTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, cancelTransactionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelTransaction");
            CancelTransactionResponse cancelTransactionResponse = (CancelTransactionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelTransaction").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(cancelTransactionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CancelTransactionRequestMarshaller(this.protocolFactory)));
            return cancelTransactionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommitTransactionResponse commitTransaction(CommitTransactionRequest commitTransactionRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, TransactionCanceledException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CommitTransactionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(commitTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, commitTransactionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CommitTransaction");
            CommitTransactionResponse commitTransactionResponse = (CommitTransactionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CommitTransaction").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(commitTransactionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CommitTransactionRequestMarshaller(this.protocolFactory)));
            return commitTransactionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataCellsFilterResponse createDataCellsFilter(CreateDataCellsFilterRequest createDataCellsFilterRequest) throws AlreadyExistsException, InvalidInputException, EntityNotFoundException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataCellsFilterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createDataCellsFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, createDataCellsFilterRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataCellsFilter");
            CreateDataCellsFilterResponse createDataCellsFilterResponse = (CreateDataCellsFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataCellsFilter").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createDataCellsFilterRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateDataCellsFilterRequestMarshaller(this.protocolFactory)));
            return createDataCellsFilterResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLfTagResponse createLFTag(CreateLfTagRequest createLfTagRequest) throws EntityNotFoundException, InvalidInputException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLfTagResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createLfTagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, createLfTagRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLFTag");
            CreateLfTagResponse createLfTagResponse = (CreateLfTagResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLFTag").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createLfTagRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateLfTagRequestMarshaller(this.protocolFactory)));
            return createLfTagResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLfTagExpressionResponse createLFTagExpression(CreateLfTagExpressionRequest createLfTagExpressionRequest) throws InvalidInputException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException, AccessDeniedException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLfTagExpressionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createLfTagExpressionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, createLfTagExpressionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLFTagExpression");
            CreateLfTagExpressionResponse createLfTagExpressionResponse = (CreateLfTagExpressionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLFTagExpression").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createLfTagExpressionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateLfTagExpressionRequestMarshaller(this.protocolFactory)));
            return createLfTagExpressionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLakeFormationIdentityCenterConfigurationResponse createLakeFormationIdentityCenterConfiguration(CreateLakeFormationIdentityCenterConfigurationRequest createLakeFormationIdentityCenterConfigurationRequest) throws InvalidInputException, AlreadyExistsException, InternalServiceException, OperationTimeoutException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLakeFormationIdentityCenterConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createLakeFormationIdentityCenterConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, createLakeFormationIdentityCenterConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLakeFormationIdentityCenterConfiguration");
            CreateLakeFormationIdentityCenterConfigurationResponse createLakeFormationIdentityCenterConfigurationResponse = (CreateLakeFormationIdentityCenterConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLakeFormationIdentityCenterConfiguration").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createLakeFormationIdentityCenterConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateLakeFormationIdentityCenterConfigurationRequestMarshaller(this.protocolFactory)));
            return createLakeFormationIdentityCenterConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLakeFormationOptInResponse createLakeFormationOptIn(CreateLakeFormationOptInRequest createLakeFormationOptInRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, ConcurrentModificationException, ResourceNumberLimitExceededException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLakeFormationOptInResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createLakeFormationOptInRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, createLakeFormationOptInRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLakeFormationOptIn");
            CreateLakeFormationOptInResponse createLakeFormationOptInResponse = (CreateLakeFormationOptInResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLakeFormationOptIn").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createLakeFormationOptInRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateLakeFormationOptInRequestMarshaller(this.protocolFactory)));
            return createLakeFormationOptInResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataCellsFilterResponse deleteDataCellsFilter(DeleteDataCellsFilterRequest deleteDataCellsFilterRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataCellsFilterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteDataCellsFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, deleteDataCellsFilterRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataCellsFilter");
            DeleteDataCellsFilterResponse deleteDataCellsFilterResponse = (DeleteDataCellsFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataCellsFilter").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteDataCellsFilterRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteDataCellsFilterRequestMarshaller(this.protocolFactory)));
            return deleteDataCellsFilterResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLfTagResponse deleteLFTag(DeleteLfTagRequest deleteLfTagRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLfTagResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteLfTagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, deleteLfTagRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLFTag");
            DeleteLfTagResponse deleteLfTagResponse = (DeleteLfTagResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLFTag").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteLfTagRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteLfTagRequestMarshaller(this.protocolFactory)));
            return deleteLfTagResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLfTagExpressionResponse deleteLFTagExpression(DeleteLfTagExpressionRequest deleteLfTagExpressionRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLfTagExpressionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteLfTagExpressionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, deleteLfTagExpressionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLFTagExpression");
            DeleteLfTagExpressionResponse deleteLfTagExpressionResponse = (DeleteLfTagExpressionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLFTagExpression").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteLfTagExpressionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteLfTagExpressionRequestMarshaller(this.protocolFactory)));
            return deleteLfTagExpressionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLakeFormationIdentityCenterConfigurationResponse deleteLakeFormationIdentityCenterConfiguration(DeleteLakeFormationIdentityCenterConfigurationRequest deleteLakeFormationIdentityCenterConfigurationRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLakeFormationIdentityCenterConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteLakeFormationIdentityCenterConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, deleteLakeFormationIdentityCenterConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLakeFormationIdentityCenterConfiguration");
            DeleteLakeFormationIdentityCenterConfigurationResponse deleteLakeFormationIdentityCenterConfigurationResponse = (DeleteLakeFormationIdentityCenterConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLakeFormationIdentityCenterConfiguration").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteLakeFormationIdentityCenterConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteLakeFormationIdentityCenterConfigurationRequestMarshaller(this.protocolFactory)));
            return deleteLakeFormationIdentityCenterConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLakeFormationOptInResponse deleteLakeFormationOptIn(DeleteLakeFormationOptInRequest deleteLakeFormationOptInRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLakeFormationOptInResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteLakeFormationOptInRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, deleteLakeFormationOptInRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLakeFormationOptIn");
            DeleteLakeFormationOptInResponse deleteLakeFormationOptInResponse = (DeleteLakeFormationOptInResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLakeFormationOptIn").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteLakeFormationOptInRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteLakeFormationOptInRequestMarshaller(this.protocolFactory)));
            return deleteLakeFormationOptInResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteObjectsOnCancelResponse deleteObjectsOnCancel(DeleteObjectsOnCancelRequest deleteObjectsOnCancelRequest) throws InternalServiceException, InvalidInputException, OperationTimeoutException, EntityNotFoundException, TransactionCommittedException, TransactionCanceledException, ResourceNotReadyException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteObjectsOnCancelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteObjectsOnCancelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, deleteObjectsOnCancelRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteObjectsOnCancel");
            DeleteObjectsOnCancelResponse deleteObjectsOnCancelResponse = (DeleteObjectsOnCancelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteObjectsOnCancel").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteObjectsOnCancelRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteObjectsOnCancelRequestMarshaller(this.protocolFactory)));
            return deleteObjectsOnCancelResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterResourceResponse deregisterResource(DeregisterResourceRequest deregisterResourceRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deregisterResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, deregisterResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterResource");
            DeregisterResourceResponse deregisterResourceResponse = (DeregisterResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deregisterResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeregisterResourceRequestMarshaller(this.protocolFactory)));
            return deregisterResourceResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLakeFormationIdentityCenterConfigurationResponse describeLakeFormationIdentityCenterConfiguration(DescribeLakeFormationIdentityCenterConfigurationRequest describeLakeFormationIdentityCenterConfigurationRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLakeFormationIdentityCenterConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(describeLakeFormationIdentityCenterConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, describeLakeFormationIdentityCenterConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLakeFormationIdentityCenterConfiguration");
            DescribeLakeFormationIdentityCenterConfigurationResponse describeLakeFormationIdentityCenterConfigurationResponse = (DescribeLakeFormationIdentityCenterConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLakeFormationIdentityCenterConfiguration").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(describeLakeFormationIdentityCenterConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DescribeLakeFormationIdentityCenterConfigurationRequestMarshaller(this.protocolFactory)));
            return describeLakeFormationIdentityCenterConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeResourceResponse describeResource(DescribeResourceRequest describeResourceRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(describeResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, describeResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResource");
            DescribeResourceResponse describeResourceResponse = (DescribeResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(describeResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DescribeResourceRequestMarshaller(this.protocolFactory)));
            return describeResourceResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTransactionResponse describeTransaction(DescribeTransactionRequest describeTransactionRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTransactionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(describeTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, describeTransactionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTransaction");
            DescribeTransactionResponse describeTransactionResponse = (DescribeTransactionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTransaction").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(describeTransactionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DescribeTransactionRequestMarshaller(this.protocolFactory)));
            return describeTransactionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtendTransactionResponse extendTransaction(ExtendTransactionRequest extendTransactionRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, TransactionCommittedException, TransactionCanceledException, TransactionCommitInProgressException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExtendTransactionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(extendTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, extendTransactionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExtendTransaction");
            ExtendTransactionResponse extendTransactionResponse = (ExtendTransactionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExtendTransaction").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(extendTransactionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ExtendTransactionRequestMarshaller(this.protocolFactory)));
            return extendTransactionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataCellsFilterResponse getDataCellsFilter(GetDataCellsFilterRequest getDataCellsFilterRequest) throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataCellsFilterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getDataCellsFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, getDataCellsFilterRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataCellsFilter");
            GetDataCellsFilterResponse getDataCellsFilterResponse = (GetDataCellsFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataCellsFilter").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getDataCellsFilterRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetDataCellsFilterRequestMarshaller(this.protocolFactory)));
            return getDataCellsFilterResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataLakePrincipalResponse getDataLakePrincipal(GetDataLakePrincipalRequest getDataLakePrincipalRequest) throws InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataLakePrincipalResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getDataLakePrincipalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, getDataLakePrincipalRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataLakePrincipal");
            GetDataLakePrincipalResponse getDataLakePrincipalResponse = (GetDataLakePrincipalResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataLakePrincipal").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getDataLakePrincipalRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetDataLakePrincipalRequestMarshaller(this.protocolFactory)));
            return getDataLakePrincipalResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataLakeSettingsResponse getDataLakeSettings(GetDataLakeSettingsRequest getDataLakeSettingsRequest) throws InternalServiceException, InvalidInputException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataLakeSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getDataLakeSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, getDataLakeSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataLakeSettings");
            GetDataLakeSettingsResponse getDataLakeSettingsResponse = (GetDataLakeSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataLakeSettings").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getDataLakeSettingsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetDataLakeSettingsRequestMarshaller(this.protocolFactory)));
            return getDataLakeSettingsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEffectivePermissionsForPathResponse getEffectivePermissionsForPath(GetEffectivePermissionsForPathRequest getEffectivePermissionsForPathRequest) throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEffectivePermissionsForPathResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getEffectivePermissionsForPathRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, getEffectivePermissionsForPathRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEffectivePermissionsForPath");
            GetEffectivePermissionsForPathResponse getEffectivePermissionsForPathResponse = (GetEffectivePermissionsForPathResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEffectivePermissionsForPath").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getEffectivePermissionsForPathRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetEffectivePermissionsForPathRequestMarshaller(this.protocolFactory)));
            return getEffectivePermissionsForPathResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLfTagResponse getLFTag(GetLfTagRequest getLfTagRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLfTagResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getLfTagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, getLfTagRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLFTag");
            GetLfTagResponse getLfTagResponse = (GetLfTagResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLFTag").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getLfTagRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetLfTagRequestMarshaller(this.protocolFactory)));
            return getLfTagResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLfTagExpressionResponse getLFTagExpression(GetLfTagExpressionRequest getLfTagExpressionRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLfTagExpressionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getLfTagExpressionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, getLfTagExpressionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLFTagExpression");
            GetLfTagExpressionResponse getLfTagExpressionResponse = (GetLfTagExpressionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLFTagExpression").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getLfTagExpressionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetLfTagExpressionRequestMarshaller(this.protocolFactory)));
            return getLfTagExpressionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueryStateResponse getQueryState(GetQueryStateRequest getQueryStateRequest) throws InternalServiceException, InvalidInputException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryStateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getQueryStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, getQueryStateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryState");
            String hostPrefix = "query-";
            String resolvedHostExpression = "query-";
            GetQueryStateResponse getQueryStateResponse = (GetQueryStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryState").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration).withInput(getQueryStateRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetQueryStateRequestMarshaller(this.protocolFactory)));
            return getQueryStateResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueryStatisticsResponse getQueryStatistics(GetQueryStatisticsRequest getQueryStatisticsRequest) throws StatisticsNotReadyYetException, InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryStatisticsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getQueryStatisticsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, getQueryStatisticsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryStatistics");
            String hostPrefix = "query-";
            String resolvedHostExpression = "query-";
            GetQueryStatisticsResponse getQueryStatisticsResponse = (GetQueryStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryStatistics").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration).withInput(getQueryStatisticsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetQueryStatisticsRequestMarshaller(this.protocolFactory)));
            return getQueryStatisticsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourceLfTagsResponse getResourceLFTags(GetResourceLfTagsRequest getResourceLfTagsRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceLfTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getResourceLfTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, getResourceLfTagsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourceLFTags");
            GetResourceLfTagsResponse getResourceLfTagsResponse = (GetResourceLfTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceLFTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getResourceLfTagsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetResourceLfTagsRequestMarshaller(this.protocolFactory)));
            return getResourceLfTagsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTableObjectsResponse getTableObjects(GetTableObjectsRequest getTableObjectsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, TransactionCommittedException, TransactionCanceledException, ResourceNotReadyException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTableObjectsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getTableObjectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, getTableObjectsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTableObjects");
            GetTableObjectsResponse getTableObjectsResponse = (GetTableObjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTableObjects").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getTableObjectsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetTableObjectsRequestMarshaller(this.protocolFactory)));
            return getTableObjectsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTemporaryGluePartitionCredentialsResponse getTemporaryGluePartitionCredentials(GetTemporaryGluePartitionCredentialsRequest getTemporaryGluePartitionCredentialsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, PermissionTypeMismatchException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTemporaryGluePartitionCredentialsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getTemporaryGluePartitionCredentialsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, getTemporaryGluePartitionCredentialsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTemporaryGluePartitionCredentials");
            GetTemporaryGluePartitionCredentialsResponse getTemporaryGluePartitionCredentialsResponse = (GetTemporaryGluePartitionCredentialsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTemporaryGluePartitionCredentials").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getTemporaryGluePartitionCredentialsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetTemporaryGluePartitionCredentialsRequestMarshaller(this.protocolFactory)));
            return getTemporaryGluePartitionCredentialsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTemporaryGlueTableCredentialsResponse getTemporaryGlueTableCredentials(GetTemporaryGlueTableCredentialsRequest getTemporaryGlueTableCredentialsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, PermissionTypeMismatchException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTemporaryGlueTableCredentialsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getTemporaryGlueTableCredentialsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, getTemporaryGlueTableCredentialsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTemporaryGlueTableCredentials");
            GetTemporaryGlueTableCredentialsResponse getTemporaryGlueTableCredentialsResponse = (GetTemporaryGlueTableCredentialsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTemporaryGlueTableCredentials").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getTemporaryGlueTableCredentialsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetTemporaryGlueTableCredentialsRequestMarshaller(this.protocolFactory)));
            return getTemporaryGlueTableCredentialsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnT> ReturnT getWorkUnitResults(GetWorkUnitResultsRequest getWorkUnitResultsRequest, ResponseTransformer<GetWorkUnitResultsResponse, ReturnT> responseTransformer) throws InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkUnitResultsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getWorkUnitResultsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, getWorkUnitResultsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkUnitResults");
            String hostPrefix = "data-";
            String resolvedHostExpression = "data-";
            ReturnT ReturnT = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkUnitResults").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration).withInput(getWorkUnitResultsRequest).withMetricCollector(apiCallMetricCollector).withResponseTransformer(responseTransformer).withMarshaller(new GetWorkUnitResultsRequestMarshaller(this.protocolFactory)), responseTransformer);
            return ReturnT;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWorkUnitsResponse getWorkUnits(GetWorkUnitsRequest getWorkUnitsRequest) throws WorkUnitsNotReadyYetException, InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkUnitsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getWorkUnitsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, getWorkUnitsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkUnits");
            String hostPrefix = "query-";
            String resolvedHostExpression = "query-";
            GetWorkUnitsResponse getWorkUnitsResponse = (GetWorkUnitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkUnits").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration).withInput(getWorkUnitsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetWorkUnitsRequestMarshaller(this.protocolFactory)));
            return getWorkUnitsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GrantPermissionsResponse grantPermissions(GrantPermissionsRequest grantPermissionsRequest) throws ConcurrentModificationException, EntityNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GrantPermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(grantPermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, grantPermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GrantPermissions");
            GrantPermissionsResponse grantPermissionsResponse = (GrantPermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GrantPermissions").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(grantPermissionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GrantPermissionsRequestMarshaller(this.protocolFactory)));
            return grantPermissionsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDataCellsFilterResponse listDataCellsFilter(ListDataCellsFilterRequest listDataCellsFilterRequest) throws InvalidInputException, OperationTimeoutException, InternalServiceException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataCellsFilterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listDataCellsFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, listDataCellsFilterRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataCellsFilter");
            ListDataCellsFilterResponse listDataCellsFilterResponse = (ListDataCellsFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataCellsFilter").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listDataCellsFilterRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListDataCellsFilterRequestMarshaller(this.protocolFactory)));
            return listDataCellsFilterResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLfTagExpressionsResponse listLFTagExpressions(ListLfTagExpressionsRequest listLfTagExpressionsRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLfTagExpressionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listLfTagExpressionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, listLfTagExpressionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLFTagExpressions");
            ListLfTagExpressionsResponse listLfTagExpressionsResponse = (ListLfTagExpressionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLFTagExpressions").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listLfTagExpressionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListLfTagExpressionsRequestMarshaller(this.protocolFactory)));
            return listLfTagExpressionsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLfTagsResponse listLFTags(ListLfTagsRequest listLfTagsRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLfTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listLfTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, listLfTagsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLFTags");
            ListLfTagsResponse listLfTagsResponse = (ListLfTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLFTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listLfTagsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListLfTagsRequestMarshaller(this.protocolFactory)));
            return listLfTagsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLakeFormationOptInsResponse listLakeFormationOptIns(ListLakeFormationOptInsRequest listLakeFormationOptInsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLakeFormationOptInsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listLakeFormationOptInsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, listLakeFormationOptInsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLakeFormationOptIns");
            ListLakeFormationOptInsResponse listLakeFormationOptInsResponse = (ListLakeFormationOptInsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLakeFormationOptIns").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listLakeFormationOptInsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListLakeFormationOptInsRequestMarshaller(this.protocolFactory)));
            return listLakeFormationOptInsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPermissionsResponse listPermissions(ListPermissionsRequest listPermissionsRequest) throws InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listPermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, listPermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPermissions");
            ListPermissionsResponse listPermissionsResponse = (ListPermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPermissions").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listPermissionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListPermissionsRequestMarshaller(this.protocolFactory)));
            return listPermissionsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourcesResponse listResources(ListResourcesRequest listResourcesRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, listResourcesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResources");
            ListResourcesResponse listResourcesResponse = (ListResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResources").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listResourcesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListResourcesRequestMarshaller(this.protocolFactory)));
            return listResourcesResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTableStorageOptimizersResponse listTableStorageOptimizers(ListTableStorageOptimizersRequest listTableStorageOptimizersRequest) throws EntityNotFoundException, InvalidInputException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTableStorageOptimizersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listTableStorageOptimizersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, listTableStorageOptimizersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTableStorageOptimizers");
            ListTableStorageOptimizersResponse listTableStorageOptimizersResponse = (ListTableStorageOptimizersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTableStorageOptimizers").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listTableStorageOptimizersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListTableStorageOptimizersRequestMarshaller(this.protocolFactory)));
            return listTableStorageOptimizersResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTransactionsResponse listTransactions(ListTransactionsRequest listTransactionsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTransactionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listTransactionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, listTransactionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTransactions");
            ListTransactionsResponse listTransactionsResponse = (ListTransactionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTransactions").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listTransactionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListTransactionsRequestMarshaller(this.protocolFactory)));
            return listTransactionsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutDataLakeSettingsResponse putDataLakeSettings(PutDataLakeSettingsRequest putDataLakeSettingsRequest) throws InternalServiceException, InvalidInputException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDataLakeSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putDataLakeSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, putDataLakeSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDataLakeSettings");
            PutDataLakeSettingsResponse putDataLakeSettingsResponse = (PutDataLakeSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDataLakeSettings").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(putDataLakeSettingsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new PutDataLakeSettingsRequestMarshaller(this.protocolFactory)));
            return putDataLakeSettingsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterResourceResponse registerResource(RegisterResourceRequest registerResourceRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AlreadyExistsException, EntityNotFoundException, ResourceNumberLimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(registerResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, registerResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterResource");
            RegisterResourceResponse registerResourceResponse = (RegisterResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(registerResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new RegisterResourceRequestMarshaller(this.protocolFactory)));
            return registerResourceResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveLfTagsFromResourceResponse removeLFTagsFromResource(RemoveLfTagsFromResourceRequest removeLfTagsFromResourceRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveLfTagsFromResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(removeLfTagsFromResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, removeLfTagsFromResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveLFTagsFromResource");
            RemoveLfTagsFromResourceResponse removeLfTagsFromResourceResponse = (RemoveLfTagsFromResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveLFTagsFromResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(removeLfTagsFromResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new RemoveLfTagsFromResourceRequestMarshaller(this.protocolFactory)));
            return removeLfTagsFromResourceResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevokePermissionsResponse revokePermissions(RevokePermissionsRequest revokePermissionsRequest) throws ConcurrentModificationException, EntityNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokePermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(revokePermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, revokePermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RevokePermissions");
            RevokePermissionsResponse revokePermissionsResponse = (RevokePermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokePermissions").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(revokePermissionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new RevokePermissionsRequestMarshaller(this.protocolFactory)));
            return revokePermissionsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchDatabasesByLfTagsResponse searchDatabasesByLFTags(SearchDatabasesByLfTagsRequest searchDatabasesByLfTagsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchDatabasesByLfTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(searchDatabasesByLfTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, searchDatabasesByLfTagsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchDatabasesByLFTags");
            SearchDatabasesByLfTagsResponse searchDatabasesByLfTagsResponse = (SearchDatabasesByLfTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchDatabasesByLFTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(searchDatabasesByLfTagsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new SearchDatabasesByLfTagsRequestMarshaller(this.protocolFactory)));
            return searchDatabasesByLfTagsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchTablesByLfTagsResponse searchTablesByLFTags(SearchTablesByLfTagsRequest searchTablesByLfTagsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchTablesByLfTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(searchTablesByLfTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, searchTablesByLfTagsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchTablesByLFTags");
            SearchTablesByLfTagsResponse searchTablesByLfTagsResponse = (SearchTablesByLfTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchTablesByLFTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(searchTablesByLfTagsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new SearchTablesByLfTagsRequestMarshaller(this.protocolFactory)));
            return searchTablesByLfTagsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartQueryPlanningResponse startQueryPlanning(StartQueryPlanningRequest startQueryPlanningRequest) throws InternalServiceException, InvalidInputException, AccessDeniedException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartQueryPlanningResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(startQueryPlanningRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, startQueryPlanningRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartQueryPlanning");
            String hostPrefix = "query-";
            String resolvedHostExpression = "query-";
            StartQueryPlanningResponse startQueryPlanningResponse = (StartQueryPlanningResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartQueryPlanning").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration).withInput(startQueryPlanningRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new StartQueryPlanningRequestMarshaller(this.protocolFactory)));
            return startQueryPlanningResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartTransactionResponse startTransaction(StartTransactionRequest startTransactionRequest) throws InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTransactionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(startTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, startTransactionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTransaction");
            StartTransactionResponse startTransactionResponse = (StartTransactionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTransaction").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(startTransactionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new StartTransactionRequestMarshaller(this.protocolFactory)));
            return startTransactionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDataCellsFilterResponse updateDataCellsFilter(UpdateDataCellsFilterRequest updateDataCellsFilterRequest) throws ConcurrentModificationException, InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataCellsFilterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateDataCellsFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, updateDataCellsFilterRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataCellsFilter");
            UpdateDataCellsFilterResponse updateDataCellsFilterResponse = (UpdateDataCellsFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataCellsFilter").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updateDataCellsFilterRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateDataCellsFilterRequestMarshaller(this.protocolFactory)));
            return updateDataCellsFilterResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLfTagResponse updateLFTag(UpdateLfTagRequest updateLfTagRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, ConcurrentModificationException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLfTagResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateLfTagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, updateLfTagRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLFTag");
            UpdateLfTagResponse updateLfTagResponse = (UpdateLfTagResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLFTag").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updateLfTagRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateLfTagRequestMarshaller(this.protocolFactory)));
            return updateLfTagResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLfTagExpressionResponse updateLFTagExpression(UpdateLfTagExpressionRequest updateLfTagExpressionRequest) throws EntityNotFoundException, InvalidInputException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLfTagExpressionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateLfTagExpressionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, updateLfTagExpressionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLFTagExpression");
            UpdateLfTagExpressionResponse updateLfTagExpressionResponse = (UpdateLfTagExpressionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLFTagExpression").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updateLfTagExpressionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateLfTagExpressionRequestMarshaller(this.protocolFactory)));
            return updateLfTagExpressionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLakeFormationIdentityCenterConfigurationResponse updateLakeFormationIdentityCenterConfiguration(UpdateLakeFormationIdentityCenterConfigurationRequest updateLakeFormationIdentityCenterConfigurationRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLakeFormationIdentityCenterConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateLakeFormationIdentityCenterConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, updateLakeFormationIdentityCenterConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLakeFormationIdentityCenterConfiguration");
            UpdateLakeFormationIdentityCenterConfigurationResponse updateLakeFormationIdentityCenterConfigurationResponse = (UpdateLakeFormationIdentityCenterConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLakeFormationIdentityCenterConfiguration").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updateLakeFormationIdentityCenterConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateLakeFormationIdentityCenterConfigurationRequestMarshaller(this.protocolFactory)));
            return updateLakeFormationIdentityCenterConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateResourceResponse updateResource(UpdateResourceRequest updateResourceRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, updateResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResource");
            UpdateResourceResponse updateResourceResponse = (UpdateResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updateResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateResourceRequestMarshaller(this.protocolFactory)));
            return updateResourceResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTableObjectsResponse updateTableObjects(UpdateTableObjectsRequest updateTableObjectsRequest) throws InternalServiceException, InvalidInputException, OperationTimeoutException, EntityNotFoundException, TransactionCommittedException, TransactionCanceledException, TransactionCommitInProgressException, ResourceNotReadyException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableObjectsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateTableObjectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, updateTableObjectsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTableObjects");
            UpdateTableObjectsResponse updateTableObjectsResponse = (UpdateTableObjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTableObjects").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updateTableObjectsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateTableObjectsRequestMarshaller(this.protocolFactory)));
            return updateTableObjectsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTableStorageOptimizerResponse updateTableStorageOptimizer(UpdateTableStorageOptimizerRequest updateTableStorageOptimizerRequest) throws EntityNotFoundException, InvalidInputException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableStorageOptimizerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "TransactionCommitInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                }
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "ResourceNotReadyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                }
                case "ThrottledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "TransactionCommittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
                case "ResourceNumberLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                }
                case "ExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "EntityNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                }
                case "StatisticsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "GlueEncryptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                }
                case "PermissionTypeMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                }
                case "WorkUnitsNotReadyYetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                }
                case "OperationTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateTableStorageOptimizerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(clientConfiguration, updateTableStorageOptimizerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTableStorageOptimizer");
            UpdateTableStorageOptimizerResponse updateTableStorageOptimizerResponse = (UpdateTableStorageOptimizerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTableStorageOptimizer").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updateTableStorageOptimizerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateTableStorageOptimizerRequestMarshaller(this.protocolFactory)));
            return updateTableStorageOptimizerResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return "lakeformation";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        LakeFormationServiceClientConfigurationBuilder serviceConfigBuilder = new LakeFormationServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return ((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)builder.clientConfiguration(this.clientConfiguration)).defaultServiceExceptionSupplier(LakeFormationException::builder)).protocol(AwsJsonProtocol.REST_JSON)).protocolVersion("1.1");
    }

    @Override
    public final LakeFormationServiceClientConfiguration serviceClientConfiguration() {
        return new LakeFormationServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        this.clientHandler.close();
    }
}

