/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.services.lakeformation.model.PartitionObjects;
import software.amazon.awssdk.services.lakeformation.model.PartitionedTableObjectsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTableObjectsResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, GetTableObjectsResponse> {
    private static final SdkField<List<PartitionObjects>> OBJECTS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("Objects").getter(GetTableObjectsResponse.getter(GetTableObjectsResponse::objects)).setter(GetTableObjectsResponse.setter(Builder::objects)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Objects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(PartitionObjects::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("NextToken").getter(GetTableObjectsResponse.getter(GetTableObjectsResponse::nextToken)).setter(GetTableObjectsResponse.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTableObjectsResponse.memberNameToFieldInitializer();
    private final List<PartitionObjects> objects;
    private final String nextToken;

    private GetTableObjectsResponse(BuilderImpl builder) {
        super(builder);
        this.objects = builder.objects;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasObjects() {
        return this.objects != null && !(this.objects instanceof SdkAutoConstructList);
    }

    public final List<PartitionObjects> objects() {
        return this.objects;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObjects() ? this.objects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableObjectsResponse)) {
            return false;
        }
        GetTableObjectsResponse other = (GetTableObjectsResponse)obj;
        return this.hasObjects() == other.hasObjects() && Objects.equals(this.objects(), other.objects()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder("GetTableObjectsResponse").add("Objects", this.hasObjects() ? this.objects() : null).add("NextToken", this.nextToken()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Objects": {
                return Optional.ofNullable(clazz.cast(this.objects()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("Objects", OBJECTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTableObjectsResponse, T> g) {
        return obj -> g.apply((GetTableObjectsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private List<PartitionObjects> objects = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableObjectsResponse model) {
            super(model);
            this.objects(model.objects);
            this.nextToken(model.nextToken);
        }

        public final List<PartitionObjects.Builder> getObjects() {
            List<PartitionObjects.Builder> result = PartitionedTableObjectsListCopier.copyToBuilder(this.objects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObjects(Collection<PartitionObjects.BuilderImpl> objects) {
            this.objects = PartitionedTableObjectsListCopier.copyFromBuilder(objects);
        }

        @Override
        public final Builder objects(Collection<PartitionObjects> objects) {
            this.objects = PartitionedTableObjectsListCopier.copy(objects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objects(PartitionObjects ... objects) {
            this.objects(Arrays.asList(objects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objects(Consumer<PartitionObjects.Builder> ... objects) {
            this.objects(Stream.of(objects).map(c -> (PartitionObjects)((PartitionObjects.Builder)PartitionObjects.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetTableObjectsResponse build() {
            return new GetTableObjectsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTableObjectsResponse> {
        public Builder objects(Collection<PartitionObjects> var1);

        public Builder objects(PartitionObjects ... var1);

        public Builder objects(Consumer<PartitionObjects.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

