/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.AuditContext;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.services.lakeformation.model.PartitionValueList;
import software.amazon.awssdk.services.lakeformation.model.Permission;
import software.amazon.awssdk.services.lakeformation.model.PermissionListCopier;
import software.amazon.awssdk.services.lakeformation.model.PermissionType;
import software.amazon.awssdk.services.lakeformation.model.PermissionTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTemporaryGluePartitionCredentialsRequest
extends LakeFormationRequest
implements ToCopyableBuilder<Builder, GetTemporaryGluePartitionCredentialsRequest> {
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("TableArn").getter(GetTemporaryGluePartitionCredentialsRequest.getter(GetTemporaryGluePartitionCredentialsRequest::tableArn)).setter(GetTemporaryGluePartitionCredentialsRequest.setter(Builder::tableArn)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()).build();
    private static final SdkField<PartitionValueList> PARTITION_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("Partition").getter(GetTemporaryGluePartitionCredentialsRequest.getter(GetTemporaryGluePartitionCredentialsRequest::partition)).setter(GetTemporaryGluePartitionCredentialsRequest.setter(Builder::partition)).constructor(PartitionValueList::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Partition").build()).build();
    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("Permissions").getter(GetTemporaryGluePartitionCredentialsRequest.getter(GetTemporaryGluePartitionCredentialsRequest::permissionsAsStrings)).setter(GetTemporaryGluePartitionCredentialsRequest.setter(Builder::permissionsWithStrings)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("DurationSeconds").getter(GetTemporaryGluePartitionCredentialsRequest.getter(GetTemporaryGluePartitionCredentialsRequest::durationSeconds)).setter(GetTemporaryGluePartitionCredentialsRequest.setter(Builder::durationSeconds)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()).build();
    private static final SdkField<AuditContext> AUDIT_CONTEXT_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("AuditContext").getter(GetTemporaryGluePartitionCredentialsRequest.getter(GetTemporaryGluePartitionCredentialsRequest::auditContext)).setter(GetTemporaryGluePartitionCredentialsRequest.setter(Builder::auditContext)).constructor(AuditContext::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditContext").build()).build();
    private static final SdkField<List<String>> SUPPORTED_PERMISSION_TYPES_FIELD = SdkField.builder(MarshallingType.LIST).memberName("SupportedPermissionTypes").getter(GetTemporaryGluePartitionCredentialsRequest.getter(GetTemporaryGluePartitionCredentialsRequest::supportedPermissionTypesAsStrings)).setter(GetTemporaryGluePartitionCredentialsRequest.setter(Builder::supportedPermissionTypesWithStrings)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedPermissionTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_ARN_FIELD, PARTITION_FIELD, PERMISSIONS_FIELD, DURATION_SECONDS_FIELD, AUDIT_CONTEXT_FIELD, SUPPORTED_PERMISSION_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTemporaryGluePartitionCredentialsRequest.memberNameToFieldInitializer();
    private final String tableArn;
    private final PartitionValueList partition;
    private final List<String> permissions;
    private final Integer durationSeconds;
    private final AuditContext auditContext;
    private final List<String> supportedPermissionTypes;

    private GetTemporaryGluePartitionCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.tableArn = builder.tableArn;
        this.partition = builder.partition;
        this.permissions = builder.permissions;
        this.durationSeconds = builder.durationSeconds;
        this.auditContext = builder.auditContext;
        this.supportedPermissionTypes = builder.supportedPermissionTypes;
    }

    public final String tableArn() {
        return this.tableArn;
    }

    public final PartitionValueList partition() {
        return this.partition;
    }

    public final List<Permission> permissions() {
        return PermissionListCopier.copyStringToEnum(this.permissions);
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<String> permissionsAsStrings() {
        return this.permissions;
    }

    public final Integer durationSeconds() {
        return this.durationSeconds;
    }

    public final AuditContext auditContext() {
        return this.auditContext;
    }

    public final List<PermissionType> supportedPermissionTypes() {
        return PermissionTypeListCopier.copyStringToEnum(this.supportedPermissionTypes);
    }

    public final boolean hasSupportedPermissionTypes() {
        return this.supportedPermissionTypes != null && !(this.supportedPermissionTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedPermissionTypesAsStrings() {
        return this.supportedPermissionTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.partition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedPermissionTypes() ? this.supportedPermissionTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemporaryGluePartitionCredentialsRequest)) {
            return false;
        }
        GetTemporaryGluePartitionCredentialsRequest other = (GetTemporaryGluePartitionCredentialsRequest)obj;
        return Objects.equals(this.tableArn(), other.tableArn()) && Objects.equals(this.partition(), other.partition()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissionsAsStrings(), other.permissionsAsStrings()) && Objects.equals(this.durationSeconds(), other.durationSeconds()) && Objects.equals(this.auditContext(), other.auditContext()) && this.hasSupportedPermissionTypes() == other.hasSupportedPermissionTypes() && Objects.equals(this.supportedPermissionTypesAsStrings(), other.supportedPermissionTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder("GetTemporaryGluePartitionCredentialsRequest").add("TableArn", this.tableArn()).add("Partition", this.partition()).add("Permissions", this.hasPermissions() ? this.permissionsAsStrings() : null).add("DurationSeconds", this.durationSeconds()).add("AuditContext", this.auditContext()).add("SupportedPermissionTypes", this.hasSupportedPermissionTypes() ? this.supportedPermissionTypesAsStrings() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableArn": {
                return Optional.ofNullable(clazz.cast(this.tableArn()));
            }
            case "Partition": {
                return Optional.ofNullable(clazz.cast(this.partition()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissionsAsStrings()));
            }
            case "DurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationSeconds()));
            }
            case "AuditContext": {
                return Optional.ofNullable(clazz.cast(this.auditContext()));
            }
            case "SupportedPermissionTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedPermissionTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("TableArn", TABLE_ARN_FIELD);
        map.put("Partition", PARTITION_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("DurationSeconds", DURATION_SECONDS_FIELD);
        map.put("AuditContext", AUDIT_CONTEXT_FIELD);
        map.put("SupportedPermissionTypes", SUPPORTED_PERMISSION_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTemporaryGluePartitionCredentialsRequest, T> g) {
        return obj -> g.apply((GetTemporaryGluePartitionCredentialsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationRequest.BuilderImpl
    implements Builder {
        private String tableArn;
        private PartitionValueList partition;
        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();
        private Integer durationSeconds;
        private AuditContext auditContext;
        private List<String> supportedPermissionTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemporaryGluePartitionCredentialsRequest model) {
            super(model);
            this.tableArn(model.tableArn);
            this.partition(model.partition);
            this.permissionsWithStrings(model.permissions);
            this.durationSeconds(model.durationSeconds);
            this.auditContext(model.auditContext);
            this.supportedPermissionTypesWithStrings(model.supportedPermissionTypes);
        }

        public final String getTableArn() {
            return this.tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final PartitionValueList.Builder getPartition() {
            return this.partition != null ? this.partition.toBuilder() : null;
        }

        public final void setPartition(PartitionValueList.BuilderImpl partition) {
            this.partition = partition != null ? partition.build() : null;
        }

        @Override
        public final Builder partition(PartitionValueList partition) {
            this.partition = partition;
            return this;
        }

        public final Collection<String> getPermissions() {
            if (this.permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String ... permissions) {
            this.permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionListCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final AuditContext.Builder getAuditContext() {
            return this.auditContext != null ? this.auditContext.toBuilder() : null;
        }

        public final void setAuditContext(AuditContext.BuilderImpl auditContext) {
            this.auditContext = auditContext != null ? auditContext.build() : null;
        }

        @Override
        public final Builder auditContext(AuditContext auditContext) {
            this.auditContext = auditContext;
            return this;
        }

        public final Collection<String> getSupportedPermissionTypes() {
            if (this.supportedPermissionTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedPermissionTypes;
        }

        public final void setSupportedPermissionTypes(Collection<String> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copy(supportedPermissionTypes);
        }

        @Override
        public final Builder supportedPermissionTypesWithStrings(Collection<String> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copy(supportedPermissionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPermissionTypesWithStrings(String ... supportedPermissionTypes) {
            this.supportedPermissionTypesWithStrings(Arrays.asList(supportedPermissionTypes));
            return this;
        }

        @Override
        public final Builder supportedPermissionTypes(Collection<PermissionType> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copyEnumToString(supportedPermissionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPermissionTypes(PermissionType ... supportedPermissionTypes) {
            this.supportedPermissionTypes(Arrays.asList(supportedPermissionTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTemporaryGluePartitionCredentialsRequest build() {
            return new GetTemporaryGluePartitionCredentialsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LakeFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTemporaryGluePartitionCredentialsRequest> {
        public Builder tableArn(String var1);

        public Builder partition(PartitionValueList var1);

        default public Builder partition(Consumer<PartitionValueList.Builder> partition) {
            return this.partition((PartitionValueList)PartitionValueList.builder().applyMutation(partition).build());
        }

        public Builder permissionsWithStrings(Collection<String> var1);

        public Builder permissionsWithStrings(String ... var1);

        public Builder permissions(Collection<Permission> var1);

        public Builder permissions(Permission ... var1);

        public Builder durationSeconds(Integer var1);

        public Builder auditContext(AuditContext var1);

        default public Builder auditContext(Consumer<AuditContext.Builder> auditContext) {
            return this.auditContext((AuditContext)AuditContext.builder().applyMutation(auditContext).build());
        }

        public Builder supportedPermissionTypesWithStrings(Collection<String> var1);

        public Builder supportedPermissionTypesWithStrings(String ... var1);

        public Builder supportedPermissionTypes(Collection<PermissionType> var1);

        public Builder supportedPermissionTypes(PermissionType ... var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

