/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkUnitResultsRequest
extends LakeFormationRequest
implements ToCopyableBuilder<Builder, GetWorkUnitResultsRequest> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("QueryId").getter(GetWorkUnitResultsRequest.getter(GetWorkUnitResultsRequest::queryId)).setter(GetWorkUnitResultsRequest.setter(Builder::queryId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()).build();
    private static final SdkField<Long> WORK_UNIT_ID_FIELD = SdkField.builder(MarshallingType.LONG).memberName("WorkUnitId").getter(GetWorkUnitResultsRequest.getter(GetWorkUnitResultsRequest::workUnitId)).setter(GetWorkUnitResultsRequest.setter(Builder::workUnitId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkUnitId").build()).build();
    private static final SdkField<String> WORK_UNIT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("WorkUnitToken").getter(GetWorkUnitResultsRequest.getter(GetWorkUnitResultsRequest::workUnitToken)).setter(GetWorkUnitResultsRequest.setter(Builder::workUnitToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkUnitToken").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD, WORK_UNIT_ID_FIELD, WORK_UNIT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetWorkUnitResultsRequest.memberNameToFieldInitializer();
    private final String queryId;
    private final Long workUnitId;
    private final String workUnitToken;

    private GetWorkUnitResultsRequest(BuilderImpl builder) {
        super(builder);
        this.queryId = builder.queryId;
        this.workUnitId = builder.workUnitId;
        this.workUnitToken = builder.workUnitToken;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final Long workUnitId() {
        return this.workUnitId;
    }

    public final String workUnitToken() {
        return this.workUnitToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workUnitToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkUnitResultsRequest)) {
            return false;
        }
        GetWorkUnitResultsRequest other = (GetWorkUnitResultsRequest)obj;
        return Objects.equals(this.queryId(), other.queryId()) && Objects.equals(this.workUnitId(), other.workUnitId()) && Objects.equals(this.workUnitToken(), other.workUnitToken());
    }

    public final String toString() {
        return ToString.builder("GetWorkUnitResultsRequest").add("QueryId", this.queryId()).add("WorkUnitId", this.workUnitId()).add("WorkUnitToken", this.workUnitToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "WorkUnitId": {
                return Optional.ofNullable(clazz.cast(this.workUnitId()));
            }
            case "WorkUnitToken": {
                return Optional.ofNullable(clazz.cast(this.workUnitToken()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("QueryId", QUERY_ID_FIELD);
        map.put("WorkUnitId", WORK_UNIT_ID_FIELD);
        map.put("WorkUnitToken", WORK_UNIT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkUnitResultsRequest, T> g) {
        return obj -> g.apply((GetWorkUnitResultsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationRequest.BuilderImpl
    implements Builder {
        private String queryId;
        private Long workUnitId;
        private String workUnitToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkUnitResultsRequest model) {
            super(model);
            this.queryId(model.queryId);
            this.workUnitId(model.workUnitId);
            this.workUnitToken(model.workUnitToken);
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final Long getWorkUnitId() {
            return this.workUnitId;
        }

        public final void setWorkUnitId(Long workUnitId) {
            this.workUnitId = workUnitId;
        }

        @Override
        public final Builder workUnitId(Long workUnitId) {
            this.workUnitId = workUnitId;
            return this;
        }

        public final String getWorkUnitToken() {
            return this.workUnitToken;
        }

        public final void setWorkUnitToken(String workUnitToken) {
            this.workUnitToken = workUnitToken;
        }

        @Override
        public final Builder workUnitToken(String workUnitToken) {
            this.workUnitToken = workUnitToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWorkUnitResultsRequest build() {
            return new GetWorkUnitResultsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LakeFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkUnitResultsRequest> {
        public Builder queryId(String var1);

        public Builder workUnitId(Long var1);

        public Builder workUnitToken(String var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

