/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.lakeformation.model.DataLakeSettings;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDataLakeSettingsRequest
extends LakeFormationRequest
implements ToCopyableBuilder<Builder, PutDataLakeSettingsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("CatalogId").getter(PutDataLakeSettingsRequest.getter(PutDataLakeSettingsRequest::catalogId)).setter(PutDataLakeSettingsRequest.setter(Builder::catalogId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();
    private static final SdkField<DataLakeSettings> DATA_LAKE_SETTINGS_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("DataLakeSettings").getter(PutDataLakeSettingsRequest.getter(PutDataLakeSettingsRequest::dataLakeSettings)).setter(PutDataLakeSettingsRequest.setter(Builder::dataLakeSettings)).constructor(DataLakeSettings::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeSettings").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATA_LAKE_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutDataLakeSettingsRequest.memberNameToFieldInitializer();
    private final String catalogId;
    private final DataLakeSettings dataLakeSettings;

    private PutDataLakeSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.dataLakeSettings = builder.dataLakeSettings;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final DataLakeSettings dataLakeSettings() {
        return this.dataLakeSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLakeSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDataLakeSettingsRequest)) {
            return false;
        }
        PutDataLakeSettingsRequest other = (PutDataLakeSettingsRequest)obj;
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.dataLakeSettings(), other.dataLakeSettings());
    }

    public final String toString() {
        return ToString.builder("PutDataLakeSettingsRequest").add("CatalogId", this.catalogId()).add("DataLakeSettings", this.dataLakeSettings()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DataLakeSettings": {
                return Optional.ofNullable(clazz.cast(this.dataLakeSettings()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("DataLakeSettings", DATA_LAKE_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDataLakeSettingsRequest, T> g) {
        return obj -> g.apply((PutDataLakeSettingsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private DataLakeSettings dataLakeSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDataLakeSettingsRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.dataLakeSettings(model.dataLakeSettings);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final DataLakeSettings.Builder getDataLakeSettings() {
            return this.dataLakeSettings != null ? this.dataLakeSettings.toBuilder() : null;
        }

        public final void setDataLakeSettings(DataLakeSettings.BuilderImpl dataLakeSettings) {
            this.dataLakeSettings = dataLakeSettings != null ? dataLakeSettings.build() : null;
        }

        @Override
        public final Builder dataLakeSettings(DataLakeSettings dataLakeSettings) {
            this.dataLakeSettings = dataLakeSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDataLakeSettingsRequest build() {
            return new PutDataLakeSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LakeFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDataLakeSettingsRequest> {
        public Builder catalogId(String var1);

        public Builder dataLakeSettings(DataLakeSettings var1);

        default public Builder dataLakeSettings(Consumer<DataLakeSettings.Builder> dataLakeSettings) {
            return this.dataLakeSettings((DataLakeSettings)DataLakeSettings.builder().applyMutation(dataLakeSettings).build());
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

