/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.lakeformation.model.TableWildcard;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableResource> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("CatalogId").getter(TableResource.getter(TableResource::catalogId)).setter(TableResource.setter(Builder::catalogId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("DatabaseName").getter(TableResource.getter(TableResource::databaseName)).setter(TableResource.setter(Builder::databaseName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("Name").getter(TableResource.getter(TableResource::name)).setter(TableResource.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();
    private static final SdkField<TableWildcard> TABLE_WILDCARD_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("TableWildcard").getter(TableResource.getter(TableResource::tableWildcard)).setter(TableResource.setter(Builder::tableWildcard)).constructor(TableWildcard::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableWildcard").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, NAME_FIELD, TABLE_WILDCARD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TableResource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String catalogId;
    private final String databaseName;
    private final String name;
    private final TableWildcard tableWildcard;

    private TableResource(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.name = builder.name;
        this.tableWildcard = builder.tableWildcard;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String name() {
        return this.name;
    }

    public final TableWildcard tableWildcard() {
        return this.tableWildcard;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableWildcard());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableResource)) {
            return false;
        }
        TableResource other = (TableResource)obj;
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.tableWildcard(), other.tableWildcard());
    }

    public final String toString() {
        return ToString.builder("TableResource").add("CatalogId", this.catalogId()).add("DatabaseName", this.databaseName()).add("Name", this.name()).add("TableWildcard", this.tableWildcard()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TableWildcard": {
                return Optional.ofNullable(clazz.cast(this.tableWildcard()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("TableWildcard", TABLE_WILDCARD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableResource, T> g) {
        return obj -> g.apply((TableResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String name;
        private TableWildcard tableWildcard;

        private BuilderImpl() {
        }

        private BuilderImpl(TableResource model) {
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.name(model.name);
            this.tableWildcard(model.tableWildcard);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final TableWildcard.Builder getTableWildcard() {
            return this.tableWildcard != null ? this.tableWildcard.toBuilder() : null;
        }

        public final void setTableWildcard(TableWildcard.BuilderImpl tableWildcard) {
            this.tableWildcard = tableWildcard != null ? tableWildcard.build() : null;
        }

        @Override
        public final Builder tableWildcard(TableWildcard tableWildcard) {
            this.tableWildcard = tableWildcard;
            return this;
        }

        @Override
        public TableResource build() {
            return new TableResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableResource> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder name(String var1);

        public Builder tableWildcard(TableWildcard var1);

        default public Builder tableWildcard(Consumer<TableWildcard.Builder> tableWildcard) {
            return this.tableWildcard((TableWildcard)TableWildcard.builder().applyMutation(tableWildcard).build());
        }
    }
}

