/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse;

public class ListPermissionsIterable
implements SdkIterable<ListPermissionsResponse> {
    private final LakeFormationClient client;
    private final ListPermissionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPermissionsIterable(LakeFormationClient client, ListPermissionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPermissionsResponseFetcher();
    }

    @Override
    public Iterator<ListPermissionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPermissionsResponseFetcher
    implements SyncPageFetcher<ListPermissionsResponse> {
        private ListPermissionsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListPermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListPermissionsResponse nextPage(ListPermissionsResponse previousPage) {
            if (previousPage == null) {
                return ListPermissionsIterable.this.client.listPermissions(ListPermissionsIterable.this.firstRequest);
            }
            return ListPermissionsIterable.this.client.listPermissions((ListPermissionsRequest)ListPermissionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

