/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.TaggedDatabase;

public class SearchDatabasesByLFTagsPublisher
implements SdkPublisher<SearchDatabasesByLfTagsResponse> {
    private final LakeFormationAsyncClient client;
    private final SearchDatabasesByLfTagsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchDatabasesByLFTagsPublisher(LakeFormationAsyncClient client, SearchDatabasesByLfTagsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchDatabasesByLFTagsPublisher(LakeFormationAsyncClient client, SearchDatabasesByLfTagsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchDatabasesByLfTagsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super SearchDatabasesByLfTagsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TaggedDatabase> databaseList() {
        Function<SearchDatabasesByLfTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.databaseList() != null) {
                return response.databaseList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new SearchDatabasesByLfTagsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchDatabasesByLfTagsResponseFetcher
    implements AsyncPageFetcher<SearchDatabasesByLfTagsResponse> {
        private SearchDatabasesByLfTagsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(SearchDatabasesByLfTagsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<SearchDatabasesByLfTagsResponse> nextPage(SearchDatabasesByLfTagsResponse previousPage) {
            if (previousPage == null) {
                return SearchDatabasesByLFTagsPublisher.this.client.searchDatabasesByLFTags(SearchDatabasesByLFTagsPublisher.this.firstRequest);
            }
            return SearchDatabasesByLFTagsPublisher.this.client.searchDatabasesByLFTags((SearchDatabasesByLfTagsRequest)SearchDatabasesByLFTagsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

