/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.auth.AuthSchemePreferenceResolver;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.endpoint.AwsClientEndpointProvider;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.ServiceConfiguration;
import software.amazon.awssdk.core.checksums.RequestChecksumCalculation;
import software.amazon.awssdk.core.checksums.RequestChecksumCalculationResolver;
import software.amazon.awssdk.core.checksums.ResponseChecksumValidation;
import software.amazon.awssdk.core.checksums.ResponseChecksumValidationResolver;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.http.auth.aws.scheme.AwsV4AuthScheme;
import software.amazon.awssdk.http.auth.aws.scheme.AwsV4aAuthScheme;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.http.auth.scheme.NoAuthAuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;
import software.amazon.awssdk.regions.ServiceMetadataAdvancedOption;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.s3.S3BaseClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.auth.scheme.S3AuthSchemeProvider;
import software.amazon.awssdk.services.s3.auth.scheme.internal.S3AuthSchemeInterceptor;
import software.amazon.awssdk.services.s3.endpoints.S3ClientContextParams;
import software.amazon.awssdk.services.s3.endpoints.S3EndpointProvider;
import software.amazon.awssdk.services.s3.endpoints.internal.S3RequestSetEndpointInterceptor;
import software.amazon.awssdk.services.s3.endpoints.internal.S3ResolveEndpointInterceptor;
import software.amazon.awssdk.services.s3.internal.S3ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.s3.internal.endpoints.UseGlobalEndpointResolver;
import software.amazon.awssdk.services.s3.internal.handlers.AsyncChecksumValidationInterceptor;
import software.amazon.awssdk.services.s3.internal.handlers.CreateBucketInterceptor;
import software.amazon.awssdk.services.s3.internal.handlers.CreateMultipartUploadRequestInterceptor;
import software.amazon.awssdk.services.s3.internal.handlers.DecodeUrlEncodedResponseInterceptor;
import software.amazon.awssdk.services.s3.internal.handlers.EnableTrailingChecksumInterceptor;
import software.amazon.awssdk.services.s3.internal.handlers.ExceptionTranslationInterceptor;
import software.amazon.awssdk.services.s3.internal.handlers.GetBucketPolicyInterceptor;
import software.amazon.awssdk.services.s3.internal.handlers.GetObjectInterceptor;
import software.amazon.awssdk.services.s3.internal.handlers.ObjectMetadataInterceptor;
import software.amazon.awssdk.services.s3.internal.handlers.StreamingRequestInterceptor;
import software.amazon.awssdk.services.s3.internal.handlers.SyncChecksumValidationInterceptor;
import software.amazon.awssdk.services.s3.internal.plugins.S3DisableChunkEncodingIfConfiguredPlugin;
import software.amazon.awssdk.services.s3.internal.s3express.S3ExpressPlugin;
import software.amazon.awssdk.services.s3.internal.s3express.UseS3ExpressAuthResolver;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
abstract class DefaultS3BaseClientBuilder<B extends S3BaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    private final Map<String, AuthScheme<?>> additionalAuthSchemes = new HashMap();

    DefaultS3BaseClientBuilder() {
    }

    @Override
    protected final String serviceEndpointPrefix() {
        return "s3";
    }

    @Override
    protected final String serviceName() {
        return "S3";
    }

    @Override
    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option(SdkClientOption.ENDPOINT_PROVIDER, this.defaultEndpointProvider()).option(SdkClientOption.AUTH_SCHEME_PROVIDER, this.defaultAuthSchemeProvider(config)).option(SdkClientOption.AUTH_SCHEMES, this.authSchemes()).option(SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, false).option(SdkClientOption.SERVICE_CONFIGURATION, (ServiceConfiguration)S3Configuration.builder().build()));
    }

    @Override
    protected final SdkClientConfiguration mergeInternalDefaults(SdkClientConfiguration config) {
        return config.merge(c -> {
            c.option(SdkClientOption.INTERNAL_USER_AGENT, "md/internal");
            c.option(SdkClientOption.DEFAULT_RETRY_MODE, RetryMode.STANDARD);
        });
    }

    @Override
    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ArrayList<ExecutionInterceptor> endpointInterceptors = new ArrayList<ExecutionInterceptor>();
        endpointInterceptors.add(new S3AuthSchemeInterceptor());
        endpointInterceptors.add(new S3ResolveEndpointInterceptor());
        endpointInterceptors.add(new S3RequestSetEndpointInterceptor());
        endpointInterceptors.add(new StreamingRequestInterceptor());
        endpointInterceptors.add(new CreateBucketInterceptor());
        endpointInterceptors.add(new CreateMultipartUploadRequestInterceptor());
        endpointInterceptors.add(new DecodeUrlEncodedResponseInterceptor());
        endpointInterceptors.add(new GetBucketPolicyInterceptor());
        endpointInterceptors.add(new AsyncChecksumValidationInterceptor());
        endpointInterceptors.add(new SyncChecksumValidationInterceptor());
        endpointInterceptors.add(new EnableTrailingChecksumInterceptor());
        endpointInterceptors.add(new ExceptionTranslationInterceptor());
        endpointInterceptors.add(new GetObjectInterceptor());
        endpointInterceptors.add(new ObjectMetadataInterceptor());
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List<ExecutionInterceptor> interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/s3/execution.interceptors");
        ArrayList additionalInterceptors = new ArrayList();
        interceptors = CollectionUtils.mergeLists(endpointInterceptors, interceptors);
        interceptors = CollectionUtils.mergeLists(interceptors, additionalInterceptors);
        interceptors = CollectionUtils.mergeLists(interceptors, config.option(SdkClientOption.EXECUTION_INTERCEPTORS));
        S3Configuration.Builder serviceConfigBuilder = ((S3Configuration)config.option(SdkClientOption.SERVICE_CONFIGURATION)).toBuilder();
        serviceConfigBuilder.profileFile(serviceConfigBuilder.profileFileSupplier() != null ? serviceConfigBuilder.profileFileSupplier() : config.option(SdkClientOption.PROFILE_FILE_SUPPLIER));
        serviceConfigBuilder.profileName(serviceConfigBuilder.profileName() != null ? serviceConfigBuilder.profileName() : config.option(SdkClientOption.PROFILE_NAME));
        if (serviceConfigBuilder.dualstackEnabled() != null) {
            Validate.validState(config.option(AwsClientOption.DUALSTACK_ENDPOINT_ENABLED) == null, "Dualstack has been configured on both S3Configuration and the client/global level. Please limit dualstack configuration to one location.", new Object[0]);
        } else {
            serviceConfigBuilder.dualstackEnabled(config.option(AwsClientOption.DUALSTACK_ENDPOINT_ENABLED));
        }
        if (serviceConfigBuilder.useArnRegionEnabled() != null) {
            Validate.validState(this.clientContextParams.get(S3ClientContextParams.USE_ARN_REGION) == null, "UseArnRegion has been configured on both S3Configuration and the client/global level. Please limit UseArnRegion configuration to one location.", new Object[0]);
        } else {
            serviceConfigBuilder.useArnRegionEnabled(this.clientContextParams.get(S3ClientContextParams.USE_ARN_REGION));
        }
        if (serviceConfigBuilder.multiRegionEnabled() != null) {
            Validate.validState(this.clientContextParams.get(S3ClientContextParams.DISABLE_MULTI_REGION_ACCESS_POINTS) == null, "DisableMultiRegionAccessPoints has been configured on both S3Configuration and the client/global level. Please limit DisableMultiRegionAccessPoints configuration to one location.", new Object[0]);
        } else if (this.clientContextParams.get(S3ClientContextParams.DISABLE_MULTI_REGION_ACCESS_POINTS) != null) {
            serviceConfigBuilder.multiRegionEnabled(this.clientContextParams.get(S3ClientContextParams.DISABLE_MULTI_REGION_ACCESS_POINTS) == false);
        }
        if (serviceConfigBuilder.pathStyleAccessEnabled() != null) {
            Validate.validState(this.clientContextParams.get(S3ClientContextParams.FORCE_PATH_STYLE) == null, "ForcePathStyle has been configured on both S3Configuration and the client/global level. Please limit ForcePathStyle configuration to one location.", new Object[0]);
        } else {
            serviceConfigBuilder.pathStyleAccessEnabled(this.clientContextParams.get(S3ClientContextParams.FORCE_PATH_STYLE));
        }
        if (serviceConfigBuilder.accelerateModeEnabled() != null) {
            Validate.validState(this.clientContextParams.get(S3ClientContextParams.ACCELERATE) == null, "Accelerate has been configured on both S3Configuration and the client/global level. Please limit Accelerate configuration to one location.", new Object[0]);
        } else {
            serviceConfigBuilder.accelerateModeEnabled(this.clientContextParams.get(S3ClientContextParams.ACCELERATE));
        }
        Boolean checksumValidationEnabled = serviceConfigBuilder.checksumValidationEnabled();
        if (checksumValidationEnabled != null) {
            Validate.validState(config.option(SdkClientOption.REQUEST_CHECKSUM_CALCULATION) == null, "Checksum behavior has been configured on both S3Configuration and the client/global level. Please limit checksum behavior configuration to one location.", new Object[0]);
            Validate.validState(config.option(SdkClientOption.RESPONSE_CHECKSUM_VALIDATION) == null, "Checksum behavior has been configured on both S3Configuration and the client/global level. Please limit checksum behavior configuration to one location.", new Object[0]);
            config = checksumValidationEnabled != false ? config.toBuilder().option(SdkClientOption.REQUEST_CHECKSUM_CALCULATION, RequestChecksumCalculation.WHEN_SUPPORTED).option(SdkClientOption.RESPONSE_CHECKSUM_VALIDATION, ResponseChecksumValidation.WHEN_SUPPORTED).build() : config.toBuilder().option(SdkClientOption.REQUEST_CHECKSUM_CALCULATION, RequestChecksumCalculation.WHEN_REQUIRED).option(SdkClientOption.RESPONSE_CHECKSUM_VALIDATION, ResponseChecksumValidation.WHEN_REQUIRED).build();
        }
        S3Configuration finalServiceConfig = (S3Configuration)serviceConfigBuilder.build();
        this.clientContextParams.put(S3ClientContextParams.USE_ARN_REGION, finalServiceConfig.useArnRegionEnabled());
        this.clientContextParams.put(S3ClientContextParams.DISABLE_MULTI_REGION_ACCESS_POINTS, !finalServiceConfig.multiRegionEnabled());
        this.clientContextParams.put(S3ClientContextParams.FORCE_PATH_STYLE, finalServiceConfig.pathStyleAccessEnabled());
        this.clientContextParams.put(S3ClientContextParams.ACCELERATE, finalServiceConfig.accelerateModeEnabled());
        UseGlobalEndpointResolver globalEndpointResolver = new UseGlobalEndpointResolver(config);
        UseS3ExpressAuthResolver useS3ExpressAuthResolver = new UseS3ExpressAuthResolver(config);
        if (this.clientContextParams.get(S3ClientContextParams.DISABLE_S3_EXPRESS_SESSION_AUTH) == null) {
            this.clientContextParams.put(S3ClientContextParams.DISABLE_S3_EXPRESS_SESSION_AUTH, !useS3ExpressAuthResolver.resolve());
        }
        SdkClientConfiguration.Builder builder = config.toBuilder();
        builder.lazyOption(SdkClientOption.IDENTITY_PROVIDERS, c -> {
            IdentityProviders.Builder result = IdentityProviders.builder();
            IdentityProvider<? extends AwsCredentialsIdentity> credentialsIdentityProvider = c.get(AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER);
            if (credentialsIdentityProvider != null) {
                result.putIdentityProvider(credentialsIdentityProvider);
            }
            return (IdentityProviders)result.build();
        });
        builder.option(SdkClientOption.EXECUTION_INTERCEPTORS, interceptors);
        builder.option(AwsClientOption.DUALSTACK_ENDPOINT_ENABLED, serviceConfigBuilder.dualstackEnabled());
        builder.option(SdkClientOption.SERVICE_CONFIGURATION, finalServiceConfig);
        builder.option(AwsClientOption.USE_GLOBAL_ENDPOINT, globalEndpointResolver.resolve(config.option(AwsClientOption.AWS_REGION)));
        builder.option(SdkClientOption.CLIENT_CONTEXT_PARAMS, this.clientContextParams.build());
        builder.lazyOptionIfAbsent(SdkClientOption.CLIENT_ENDPOINT_PROVIDER, c -> AwsClientEndpointProvider.builder().serviceEndpointOverrideEnvironmentVariable("AWS_ENDPOINT_URL_S3").serviceEndpointOverrideSystemProperty("aws.endpointUrlS3").serviceProfileProperty("s3").serviceEndpointPrefix(this.serviceEndpointPrefix()).defaultProtocol("https").region(c.get(AwsClientOption.AWS_REGION)).profileFile(c.get(SdkClientOption.PROFILE_FILE_SUPPLIER)).profileName(c.get(SdkClientOption.PROFILE_NAME)).putAdvancedOption(ServiceMetadataAdvancedOption.DEFAULT_S3_US_EAST_1_REGIONAL_ENDPOINT, c.get(ServiceMetadataAdvancedOption.DEFAULT_S3_US_EAST_1_REGIONAL_ENDPOINT)).dualstackEnabled(c.get(AwsClientOption.DUALSTACK_ENDPOINT_ENABLED)).fipsEnabled(c.get(AwsClientOption.FIPS_ENDPOINT_ENABLED)).build());
        SdkClientConfiguration clientConfig = config;
        builder.lazyOption(SdkClientOption.REQUEST_CHECKSUM_CALCULATION, c -> this.resolveRequestChecksumCalculation(clientConfig));
        builder.lazyOption(SdkClientOption.RESPONSE_CHECKSUM_VALIDATION, c -> this.resolveResponseChecksumValidation(clientConfig));
        return builder.build();
    }

    @Override
    protected final String signingName() {
        return "s3";
    }

    private S3EndpointProvider defaultEndpointProvider() {
        return S3EndpointProvider.defaultProvider();
    }

    public B authSchemeProvider(S3AuthSchemeProvider authSchemeProvider) {
        this.clientConfiguration.option(SdkClientOption.AUTH_SCHEME_PROVIDER, authSchemeProvider);
        return (B)((S3BaseClientBuilder)this.thisBuilder());
    }

    private S3AuthSchemeProvider defaultAuthSchemeProvider(SdkClientConfiguration config) {
        AuthSchemePreferenceResolver authSchemePreferenceProvider = AuthSchemePreferenceResolver.builder().profileFile(config.option(SdkClientOption.PROFILE_FILE_SUPPLIER)).profileName(config.option(SdkClientOption.PROFILE_NAME)).build();
        List<String> preferences = authSchemePreferenceProvider.resolveAuthSchemePreference();
        if (!preferences.isEmpty()) {
            return S3AuthSchemeProvider.defaultProvider(preferences);
        }
        return S3AuthSchemeProvider.defaultProvider();
    }

    @Override
    public B putAuthScheme(AuthScheme<?> authScheme) {
        this.additionalAuthSchemes.put(authScheme.schemeId(), authScheme);
        return (B)((S3BaseClientBuilder)this.thisBuilder());
    }

    private Map<String, AuthScheme<?>> authSchemes() {
        HashMap schemes = new HashMap(3 + this.additionalAuthSchemes.size());
        AwsV4AuthScheme awsV4AuthScheme = AwsV4AuthScheme.create();
        schemes.put(awsV4AuthScheme.schemeId(), awsV4AuthScheme);
        AwsV4aAuthScheme awsV4aAuthScheme = AwsV4aAuthScheme.create();
        schemes.put(awsV4aAuthScheme.schemeId(), awsV4aAuthScheme);
        NoAuthAuthScheme noAuthAuthScheme = NoAuthAuthScheme.create();
        schemes.put(noAuthAuthScheme.schemeId(), noAuthAuthScheme);
        schemes.putAll(this.additionalAuthSchemes);
        return schemes;
    }

    public B requestChecksumCalculation(RequestChecksumCalculation requestChecksumCalculation) {
        this.clientConfiguration.option(SdkClientOption.REQUEST_CHECKSUM_CALCULATION, requestChecksumCalculation);
        return (B)((S3BaseClientBuilder)this.thisBuilder());
    }

    public B responseChecksumValidation(ResponseChecksumValidation responseChecksumValidation) {
        this.clientConfiguration.option(SdkClientOption.RESPONSE_CHECKSUM_VALIDATION, responseChecksumValidation);
        return (B)((S3BaseClientBuilder)this.thisBuilder());
    }

    public B accelerate(Boolean accelerate) {
        this.clientContextParams.put(S3ClientContextParams.ACCELERATE, accelerate);
        return (B)((S3BaseClientBuilder)this.thisBuilder());
    }

    public B disableMultiRegionAccessPoints(Boolean disableMultiRegionAccessPoints) {
        this.clientContextParams.put(S3ClientContextParams.DISABLE_MULTI_REGION_ACCESS_POINTS, disableMultiRegionAccessPoints);
        return (B)((S3BaseClientBuilder)this.thisBuilder());
    }

    public B disableS3ExpressSessionAuth(Boolean disableS3ExpressSessionAuth) {
        this.clientContextParams.put(S3ClientContextParams.DISABLE_S3_EXPRESS_SESSION_AUTH, disableS3ExpressSessionAuth);
        return (B)((S3BaseClientBuilder)this.thisBuilder());
    }

    public B forcePathStyle(Boolean forcePathStyle) {
        this.clientContextParams.put(S3ClientContextParams.FORCE_PATH_STYLE, forcePathStyle);
        return (B)((S3BaseClientBuilder)this.thisBuilder());
    }

    public B useArnRegion(Boolean useArnRegion) {
        this.clientContextParams.put(S3ClientContextParams.USE_ARN_REGION, useArnRegion);
        return (B)((S3BaseClientBuilder)this.thisBuilder());
    }

    public B crossRegionAccessEnabled(Boolean crossRegionAccessEnabled) {
        this.clientContextParams.put(S3ClientContextParams.CROSS_REGION_ACCESS_ENABLED, crossRegionAccessEnabled);
        return (B)((S3BaseClientBuilder)this.thisBuilder());
    }

    public B serviceConfiguration(S3Configuration serviceConfiguration) {
        this.clientConfiguration.option(SdkClientOption.SERVICE_CONFIGURATION, serviceConfiguration);
        return (B)((S3BaseClientBuilder)this.thisBuilder());
    }

    public void setServiceConfiguration(S3Configuration serviceConfiguration) {
        this.serviceConfiguration(serviceConfiguration);
    }

    @Override
    protected SdkClientConfiguration invokePlugins(SdkClientConfiguration config) {
        List<SdkPlugin> internalPlugins = this.internalPlugins(config);
        List<SdkPlugin> externalPlugins = this.plugins();
        if (internalPlugins.isEmpty() && externalPlugins.isEmpty()) {
            return config;
        }
        List<SdkPlugin> plugins = CollectionUtils.mergeLists(internalPlugins, externalPlugins);
        SdkClientConfiguration.Builder configuration = config.toBuilder();
        S3ServiceClientConfigurationBuilder serviceConfigBuilder = new S3ServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private List<SdkPlugin> internalPlugins(SdkClientConfiguration config) {
        ArrayList<SdkPlugin> internalPlugins = new ArrayList<SdkPlugin>();
        internalPlugins.add(new S3DisableChunkEncodingIfConfiguredPlugin(config));
        internalPlugins.add(new S3ExpressPlugin());
        return internalPlugins;
    }

    private RequestChecksumCalculation resolveRequestChecksumCalculation(SdkClientConfiguration config) {
        RequestChecksumCalculation configuredChecksumCalculation = config.option(SdkClientOption.REQUEST_CHECKSUM_CALCULATION);
        if (configuredChecksumCalculation == null) {
            configuredChecksumCalculation = RequestChecksumCalculationResolver.create().profileFile(config.option(SdkClientOption.PROFILE_FILE_SUPPLIER)).profileName(config.option(SdkClientOption.PROFILE_NAME)).defaultChecksumCalculation(RequestChecksumCalculation.WHEN_SUPPORTED).resolve();
        }
        return configuredChecksumCalculation;
    }

    private ResponseChecksumValidation resolveResponseChecksumValidation(SdkClientConfiguration config) {
        ResponseChecksumValidation configuredChecksumValidation = config.option(SdkClientOption.RESPONSE_CHECKSUM_VALIDATION);
        if (configuredChecksumValidation == null) {
            configuredChecksumValidation = ResponseChecksumValidationResolver.create().profileFile(config.option(SdkClientOption.PROFILE_FILE_SUPPLIER)).profileName(config.option(SdkClientOption.PROFILE_NAME)).defaultChecksumValidation(ResponseChecksumValidation.WHEN_SUPPORTED).resolve();
        }
        return configuredChecksumValidation;
    }

    protected static void validateClientOptions(SdkClientConfiguration c) {
    }

    public B sigv4aSigningRegionSet(RegionSet sigv4aSigningRegionSet) {
        this.clientConfiguration.option(AwsClientOption.AWS_SIGV4A_SIGNING_REGION_SET, sigv4aSigningRegionSet == null ? Collections.emptySet() : sigv4aSigningRegionSet.asSet());
        return (B)((S3BaseClientBuilder)this.thisBuilder());
    }
}

