/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.checksums.DefaultChecksumAlgorithm;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.interceptor.trait.HttpChecksum;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.StreamingRequestMarshaller;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsS3ProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ServiceClientConfiguration;
import software.amazon.awssdk.services.s3.S3Utilities;
import software.amazon.awssdk.services.s3.endpoints.S3ClientContextParams;
import software.amazon.awssdk.services.s3.internal.CustomRequestTransformerUtils;
import software.amazon.awssdk.services.s3.internal.S3ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.BucketAlreadyExistsException;
import software.amazon.awssdk.services.s3.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.model.CreateBucketMetadataConfigurationRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketMetadataConfigurationResponse;
import software.amazon.awssdk.services.s3.model.CreateBucketMetadataTableConfigurationRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketMetadataTableConfigurationResponse;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CreateSessionRequest;
import software.amazon.awssdk.services.s3.model.CreateSessionResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketEncryptionRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketEncryptionResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketIntelligentTieringConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketLifecycleRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketLifecycleResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetadataConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetadataConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetadataTableConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetadataTableConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketOwnershipControlsRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketOwnershipControlsResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.DeletePublicAccessBlockRequest;
import software.amazon.awssdk.services.s3.model.DeletePublicAccessBlockResponse;
import software.amazon.awssdk.services.s3.model.EncryptionTypeMismatchException;
import software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketAclRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAclResponse;
import software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.GetBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.GetBucketEncryptionRequest;
import software.amazon.awssdk.services.s3.model.GetBucketEncryptionResponse;
import software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLocationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLocationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLoggingRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLoggingResponse;
import software.amazon.awssdk.services.s3.model.GetBucketMetadataConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketMetadataConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketMetadataTableConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketMetadataTableConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketOwnershipControlsRequest;
import software.amazon.awssdk.services.s3.model.GetBucketOwnershipControlsResponse;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusRequest;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusResponse;
import software.amazon.awssdk.services.s3.model.GetBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentRequest;
import software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentResponse;
import software.amazon.awssdk.services.s3.model.GetBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse;
import software.amazon.awssdk.services.s3.model.GetBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.GetObjectAclRequest;
import software.amazon.awssdk.services.s3.model.GetObjectAclResponse;
import software.amazon.awssdk.services.s3.model.GetObjectAttributesRequest;
import software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse;
import software.amazon.awssdk.services.s3.model.GetObjectLegalHoldRequest;
import software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse;
import software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRetentionRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRetentionResponse;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTorrentResponse;
import software.amazon.awssdk.services.s3.model.GetPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3.model.GetPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.IdempotencyParameterMismatchException;
import software.amazon.awssdk.services.s3.model.InvalidObjectStateException;
import software.amazon.awssdk.services.s3.model.InvalidRequestException;
import software.amazon.awssdk.services.s3.model.InvalidWriteOffsetException;
import software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListDirectoryBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListDirectoryBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.ListPartsRequest;
import software.amazon.awssdk.services.s3.model.ListPartsResponse;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.NoSuchUploadException;
import software.amazon.awssdk.services.s3.model.ObjectAlreadyInActiveTierErrorException;
import software.amazon.awssdk.services.s3.model.ObjectNotInActiveTierErrorException;
import software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketAclRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAclResponse;
import software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.PutBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.PutBucketEncryptionRequest;
import software.amazon.awssdk.services.s3.model.PutBucketEncryptionResponse;
import software.amazon.awssdk.services.s3.model.PutBucketIntelligentTieringConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketIntelligentTieringConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest;
import software.amazon.awssdk.services.s3.model.PutBucketLoggingResponse;
import software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketOwnershipControlsRequest;
import software.amazon.awssdk.services.s3.model.PutBucketOwnershipControlsResponse;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentRequest;
import software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentResponse;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningResponse;
import software.amazon.awssdk.services.s3.model.PutBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.PutBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.PutObjectAclRequest;
import software.amazon.awssdk.services.s3.model.PutObjectAclResponse;
import software.amazon.awssdk.services.s3.model.PutObjectLegalHoldRequest;
import software.amazon.awssdk.services.s3.model.PutObjectLegalHoldResponse;
import software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRetentionResponse;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.PutPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3.model.PutPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3.model.RenameObjectRequest;
import software.amazon.awssdk.services.s3.model.RenameObjectResponse;
import software.amazon.awssdk.services.s3.model.RestoreObjectRequest;
import software.amazon.awssdk.services.s3.model.RestoreObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.TooManyPartsException;
import software.amazon.awssdk.services.s3.model.UpdateBucketMetadataInventoryTableConfigurationRequest;
import software.amazon.awssdk.services.s3.model.UpdateBucketMetadataInventoryTableConfigurationResponse;
import software.amazon.awssdk.services.s3.model.UpdateBucketMetadataJournalTableConfigurationRequest;
import software.amazon.awssdk.services.s3.model.UpdateBucketMetadataJournalTableConfigurationResponse;
import software.amazon.awssdk.services.s3.model.UploadPartCopyRequest;
import software.amazon.awssdk.services.s3.model.UploadPartCopyResponse;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest;
import software.amazon.awssdk.services.s3.model.WriteGetObjectResponseResponse;
import software.amazon.awssdk.services.s3.transform.AbortMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CompleteMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CopyObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CreateBucketMetadataConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CreateBucketMetadataTableConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CreateBucketRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CreateMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CreateSessionRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketAnalyticsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketCorsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketEncryptionRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketIntelligentTieringConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketInventoryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketLifecycleRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketMetadataConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketMetadataTableConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketMetricsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketOwnershipControlsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketWebsiteRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteObjectTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteObjectsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeletePublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketAccelerateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketAclRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketAnalyticsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketCorsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketEncryptionRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketIntelligentTieringConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketInventoryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketLocationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketLoggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketMetadataConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketMetadataTableConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketMetricsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketOwnershipControlsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketPolicyStatusRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketRequestPaymentRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketVersioningRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketWebsiteRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectAclRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectAttributesRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectLegalHoldRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectLockConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectRetentionRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectTorrentRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.HeadBucketRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.HeadObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketAnalyticsConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketIntelligentTieringConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketInventoryConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketMetricsConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListDirectoryBucketsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListMultipartUploadsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListObjectVersionsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListObjectsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListObjectsV2RequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListPartsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketAccelerateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketAclRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketAnalyticsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketCorsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketEncryptionRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketIntelligentTieringConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketInventoryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketLoggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketMetricsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketOwnershipControlsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketRequestPaymentRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketVersioningRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketWebsiteRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectAclRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectLegalHoldRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectLockConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectRetentionRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.RenameObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.RestoreObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.UpdateBucketMetadataInventoryTableConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.UpdateBucketMetadataJournalTableConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.UploadPartCopyRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.UploadPartRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.WriteGetObjectResponseRequestMarshaller;
import software.amazon.awssdk.services.s3.waiters.S3Waiter;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.HostnameValidator;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
final class DefaultS3Client
implements S3Client {
    private static final Logger log = Logger.loggerFor(DefaultS3Client.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_XML).build();
    private final SyncClientHandler clientHandler;
    private final AwsS3ProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultS3Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).option(SdkClientOption.API_METADATA, "S3#2.33.x").build();
        this.protocolFactory = this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbortMultipartUploadResponse abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws NoSuchUploadException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(AbortMultipartUploadResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(abortMultipartUploadRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, abortMultipartUploadRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AbortMultipartUpload");
            AbortMultipartUploadResponse abortMultipartUploadResponse = (AbortMultipartUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AbortMultipartUpload").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(abortMultipartUploadRequest).withMarshaller(new AbortMultipartUploadRequestMarshaller(this.protocolFactory)));
            return abortMultipartUploadResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CompleteMultipartUploadResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(completeMultipartUploadRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, completeMultipartUploadRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CompleteMultipartUpload");
            CompleteMultipartUploadResponse completeMultipartUploadResponse = (CompleteMultipartUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CompleteMultipartUpload").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(completeMultipartUploadRequest).withMarshaller(new CompleteMultipartUploadRequestMarshaller(this.protocolFactory)));
            return completeMultipartUploadResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopyObjectResponse copyObject(CopyObjectRequest copyObjectRequest) throws ObjectNotInActiveTierErrorException, AwsServiceException, SdkClientException, S3Exception {
        copyObjectRequest = CustomRequestTransformerUtils.modifyCopyObjectRequest(copyObjectRequest);
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CopyObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(copyObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, copyObjectRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyObject");
            CopyObjectResponse copyObjectResponse = (CopyObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyObject").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(copyObjectRequest).withMarshaller(new CopyObjectRequestMarshaller(this.protocolFactory)));
            return copyObjectResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBucketResponse createBucket(CreateBucketRequest createBucketRequest) throws BucketAlreadyExistsException, BucketAlreadyOwnedByYouException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, createBucketRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBucket");
            CreateBucketResponse createBucketResponse = (CreateBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBucket").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(createBucketRequest).withMarshaller(new CreateBucketRequestMarshaller(this.protocolFactory)));
            return createBucketResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBucketMetadataConfigurationResponse createBucketMetadataConfiguration(CreateBucketMetadataConfigurationRequest createBucketMetadataConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateBucketMetadataConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createBucketMetadataConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, createBucketMetadataConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBucketMetadataConfiguration");
            CreateBucketMetadataConfigurationResponse createBucketMetadataConfigurationResponse = (CreateBucketMetadataConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBucketMetadataConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(createBucketMetadataConfigurationRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(createBucketMetadataConfigurationRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new CreateBucketMetadataConfigurationRequestMarshaller(this.protocolFactory)));
            return createBucketMetadataConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBucketMetadataTableConfigurationResponse createBucketMetadataTableConfiguration(CreateBucketMetadataTableConfigurationRequest createBucketMetadataTableConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateBucketMetadataTableConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createBucketMetadataTableConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, createBucketMetadataTableConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBucketMetadataTableConfiguration");
            CreateBucketMetadataTableConfigurationResponse createBucketMetadataTableConfigurationResponse = (CreateBucketMetadataTableConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBucketMetadataTableConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(createBucketMetadataTableConfigurationRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(createBucketMetadataTableConfigurationRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new CreateBucketMetadataTableConfigurationRequestMarshaller(this.protocolFactory)));
            return createBucketMetadataTableConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMultipartUploadResponse createMultipartUpload(CreateMultipartUploadRequest createMultipartUploadRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateMultipartUploadResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createMultipartUploadRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, createMultipartUploadRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMultipartUpload");
            CreateMultipartUploadResponse createMultipartUploadResponse = (CreateMultipartUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMultipartUpload").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(createMultipartUploadRequest).withMarshaller(new CreateMultipartUploadRequestMarshaller(this.protocolFactory)));
            return createMultipartUploadResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSessionResponse createSession(CreateSessionRequest createSessionRequest) throws NoSuchBucketException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateSessionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, createSessionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSession");
            CreateSessionResponse createSessionResponse = (CreateSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSession").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(createSessionRequest).withMarshaller(new CreateSessionRequestMarshaller(this.protocolFactory)));
            return createSessionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketResponse deleteBucket(DeleteBucketRequest deleteBucketRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteBucketRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucket");
            DeleteBucketResponse deleteBucketResponse = (DeleteBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucket").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteBucketRequest).withMarshaller(new DeleteBucketRequestMarshaller(this.protocolFactory)));
            return deleteBucketResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketAnalyticsConfigurationResponse deleteBucketAnalyticsConfiguration(DeleteBucketAnalyticsConfigurationRequest deleteBucketAnalyticsConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketAnalyticsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteBucketAnalyticsConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteBucketAnalyticsConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketAnalyticsConfiguration");
            DeleteBucketAnalyticsConfigurationResponse deleteBucketAnalyticsConfigurationResponse = (DeleteBucketAnalyticsConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketAnalyticsConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteBucketAnalyticsConfigurationRequest).withMarshaller(new DeleteBucketAnalyticsConfigurationRequestMarshaller(this.protocolFactory)));
            return deleteBucketAnalyticsConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketCorsResponse deleteBucketCors(DeleteBucketCorsRequest deleteBucketCorsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketCorsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteBucketCorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteBucketCorsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketCors");
            DeleteBucketCorsResponse deleteBucketCorsResponse = (DeleteBucketCorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketCors").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteBucketCorsRequest).withMarshaller(new DeleteBucketCorsRequestMarshaller(this.protocolFactory)));
            return deleteBucketCorsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketEncryptionResponse deleteBucketEncryption(DeleteBucketEncryptionRequest deleteBucketEncryptionRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketEncryptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteBucketEncryptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteBucketEncryptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketEncryption");
            DeleteBucketEncryptionResponse deleteBucketEncryptionResponse = (DeleteBucketEncryptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketEncryption").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteBucketEncryptionRequest).withMarshaller(new DeleteBucketEncryptionRequestMarshaller(this.protocolFactory)));
            return deleteBucketEncryptionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketIntelligentTieringConfigurationResponse deleteBucketIntelligentTieringConfiguration(DeleteBucketIntelligentTieringConfigurationRequest deleteBucketIntelligentTieringConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketIntelligentTieringConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteBucketIntelligentTieringConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteBucketIntelligentTieringConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketIntelligentTieringConfiguration");
            DeleteBucketIntelligentTieringConfigurationResponse deleteBucketIntelligentTieringConfigurationResponse = (DeleteBucketIntelligentTieringConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketIntelligentTieringConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteBucketIntelligentTieringConfigurationRequest).withMarshaller(new DeleteBucketIntelligentTieringConfigurationRequestMarshaller(this.protocolFactory)));
            return deleteBucketIntelligentTieringConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketInventoryConfigurationResponse deleteBucketInventoryConfiguration(DeleteBucketInventoryConfigurationRequest deleteBucketInventoryConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketInventoryConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteBucketInventoryConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteBucketInventoryConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketInventoryConfiguration");
            DeleteBucketInventoryConfigurationResponse deleteBucketInventoryConfigurationResponse = (DeleteBucketInventoryConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketInventoryConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteBucketInventoryConfigurationRequest).withMarshaller(new DeleteBucketInventoryConfigurationRequestMarshaller(this.protocolFactory)));
            return deleteBucketInventoryConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketLifecycleResponse deleteBucketLifecycle(DeleteBucketLifecycleRequest deleteBucketLifecycleRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketLifecycleResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteBucketLifecycleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteBucketLifecycleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketLifecycle");
            DeleteBucketLifecycleResponse deleteBucketLifecycleResponse = (DeleteBucketLifecycleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketLifecycle").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteBucketLifecycleRequest).withMarshaller(new DeleteBucketLifecycleRequestMarshaller(this.protocolFactory)));
            return deleteBucketLifecycleResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketMetadataConfigurationResponse deleteBucketMetadataConfiguration(DeleteBucketMetadataConfigurationRequest deleteBucketMetadataConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketMetadataConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteBucketMetadataConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteBucketMetadataConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketMetadataConfiguration");
            DeleteBucketMetadataConfigurationResponse deleteBucketMetadataConfigurationResponse = (DeleteBucketMetadataConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketMetadataConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteBucketMetadataConfigurationRequest).withMarshaller(new DeleteBucketMetadataConfigurationRequestMarshaller(this.protocolFactory)));
            return deleteBucketMetadataConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketMetadataTableConfigurationResponse deleteBucketMetadataTableConfiguration(DeleteBucketMetadataTableConfigurationRequest deleteBucketMetadataTableConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketMetadataTableConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteBucketMetadataTableConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteBucketMetadataTableConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketMetadataTableConfiguration");
            DeleteBucketMetadataTableConfigurationResponse deleteBucketMetadataTableConfigurationResponse = (DeleteBucketMetadataTableConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketMetadataTableConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteBucketMetadataTableConfigurationRequest).withMarshaller(new DeleteBucketMetadataTableConfigurationRequestMarshaller(this.protocolFactory)));
            return deleteBucketMetadataTableConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketMetricsConfigurationResponse deleteBucketMetricsConfiguration(DeleteBucketMetricsConfigurationRequest deleteBucketMetricsConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketMetricsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteBucketMetricsConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteBucketMetricsConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketMetricsConfiguration");
            DeleteBucketMetricsConfigurationResponse deleteBucketMetricsConfigurationResponse = (DeleteBucketMetricsConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketMetricsConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteBucketMetricsConfigurationRequest).withMarshaller(new DeleteBucketMetricsConfigurationRequestMarshaller(this.protocolFactory)));
            return deleteBucketMetricsConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketOwnershipControlsResponse deleteBucketOwnershipControls(DeleteBucketOwnershipControlsRequest deleteBucketOwnershipControlsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketOwnershipControlsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteBucketOwnershipControlsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteBucketOwnershipControlsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketOwnershipControls");
            DeleteBucketOwnershipControlsResponse deleteBucketOwnershipControlsResponse = (DeleteBucketOwnershipControlsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketOwnershipControls").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteBucketOwnershipControlsRequest).withMarshaller(new DeleteBucketOwnershipControlsRequestMarshaller(this.protocolFactory)));
            return deleteBucketOwnershipControlsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketPolicyResponse deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteBucketPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteBucketPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketPolicy");
            DeleteBucketPolicyResponse deleteBucketPolicyResponse = (DeleteBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketPolicy").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteBucketPolicyRequest).withMarshaller(new DeleteBucketPolicyRequestMarshaller(this.protocolFactory)));
            return deleteBucketPolicyResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketReplicationResponse deleteBucketReplication(DeleteBucketReplicationRequest deleteBucketReplicationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketReplicationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteBucketReplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteBucketReplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketReplication");
            DeleteBucketReplicationResponse deleteBucketReplicationResponse = (DeleteBucketReplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketReplication").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteBucketReplicationRequest).withMarshaller(new DeleteBucketReplicationRequestMarshaller(this.protocolFactory)));
            return deleteBucketReplicationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketTaggingResponse deleteBucketTagging(DeleteBucketTaggingRequest deleteBucketTaggingRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteBucketTaggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteBucketTaggingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketTagging");
            DeleteBucketTaggingResponse deleteBucketTaggingResponse = (DeleteBucketTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketTagging").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteBucketTaggingRequest).withMarshaller(new DeleteBucketTaggingRequestMarshaller(this.protocolFactory)));
            return deleteBucketTaggingResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketWebsiteResponse deleteBucketWebsite(DeleteBucketWebsiteRequest deleteBucketWebsiteRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketWebsiteResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteBucketWebsiteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteBucketWebsiteRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketWebsite");
            DeleteBucketWebsiteResponse deleteBucketWebsiteResponse = (DeleteBucketWebsiteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketWebsite").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteBucketWebsiteRequest).withMarshaller(new DeleteBucketWebsiteRequestMarshaller(this.protocolFactory)));
            return deleteBucketWebsiteResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteObjectResponse deleteObject(DeleteObjectRequest deleteObjectRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteObjectRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteObject");
            DeleteObjectResponse deleteObjectResponse = (DeleteObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteObject").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteObjectRequest).withMarshaller(new DeleteObjectRequestMarshaller(this.protocolFactory)));
            return deleteObjectResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteObjectTaggingResponse deleteObjectTagging(DeleteObjectTaggingRequest deleteObjectTaggingRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteObjectTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteObjectTaggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteObjectTaggingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteObjectTagging");
            DeleteObjectTaggingResponse deleteObjectTaggingResponse = (DeleteObjectTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteObjectTagging").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteObjectTaggingRequest).withMarshaller(new DeleteObjectTaggingRequestMarshaller(this.protocolFactory)));
            return deleteObjectTaggingResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteObjectsResponse deleteObjects(DeleteObjectsRequest deleteObjectsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteObjectsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteObjectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deleteObjectsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteObjects");
            DeleteObjectsResponse deleteObjectsResponse = (DeleteObjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteObjects").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deleteObjectsRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(deleteObjectsRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new DeleteObjectsRequestMarshaller(this.protocolFactory)));
            return deleteObjectsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePublicAccessBlockResponse deletePublicAccessBlock(DeletePublicAccessBlockRequest deletePublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeletePublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deletePublicAccessBlockRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, deletePublicAccessBlockRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePublicAccessBlock");
            DeletePublicAccessBlockResponse deletePublicAccessBlockResponse = (DeletePublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePublicAccessBlock").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(deletePublicAccessBlockRequest).withMarshaller(new DeletePublicAccessBlockRequestMarshaller(this.protocolFactory)));
            return deletePublicAccessBlockResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketAccelerateConfigurationResponse getBucketAccelerateConfiguration(GetBucketAccelerateConfigurationRequest getBucketAccelerateConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketAccelerateConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketAccelerateConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketAccelerateConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketAccelerateConfiguration");
            GetBucketAccelerateConfigurationResponse getBucketAccelerateConfigurationResponse = (GetBucketAccelerateConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketAccelerateConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketAccelerateConfigurationRequest).withMarshaller(new GetBucketAccelerateConfigurationRequestMarshaller(this.protocolFactory)));
            return getBucketAccelerateConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketAclResponse getBucketAcl(GetBucketAclRequest getBucketAclRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketAclResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketAclRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketAcl");
            GetBucketAclResponse getBucketAclResponse = (GetBucketAclResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketAcl").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketAclRequest).withMarshaller(new GetBucketAclRequestMarshaller(this.protocolFactory)));
            return getBucketAclResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketAnalyticsConfigurationResponse getBucketAnalyticsConfiguration(GetBucketAnalyticsConfigurationRequest getBucketAnalyticsConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketAnalyticsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketAnalyticsConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketAnalyticsConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketAnalyticsConfiguration");
            GetBucketAnalyticsConfigurationResponse getBucketAnalyticsConfigurationResponse = (GetBucketAnalyticsConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketAnalyticsConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketAnalyticsConfigurationRequest).withMarshaller(new GetBucketAnalyticsConfigurationRequestMarshaller(this.protocolFactory)));
            return getBucketAnalyticsConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketCorsResponse getBucketCors(GetBucketCorsRequest getBucketCorsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketCorsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketCorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketCorsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketCors");
            GetBucketCorsResponse getBucketCorsResponse = (GetBucketCorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketCors").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketCorsRequest).withMarshaller(new GetBucketCorsRequestMarshaller(this.protocolFactory)));
            return getBucketCorsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketEncryptionResponse getBucketEncryption(GetBucketEncryptionRequest getBucketEncryptionRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketEncryptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketEncryptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketEncryptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketEncryption");
            GetBucketEncryptionResponse getBucketEncryptionResponse = (GetBucketEncryptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketEncryption").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketEncryptionRequest).withMarshaller(new GetBucketEncryptionRequestMarshaller(this.protocolFactory)));
            return getBucketEncryptionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketIntelligentTieringConfigurationResponse getBucketIntelligentTieringConfiguration(GetBucketIntelligentTieringConfigurationRequest getBucketIntelligentTieringConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketIntelligentTieringConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketIntelligentTieringConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketIntelligentTieringConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketIntelligentTieringConfiguration");
            GetBucketIntelligentTieringConfigurationResponse getBucketIntelligentTieringConfigurationResponse = (GetBucketIntelligentTieringConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketIntelligentTieringConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketIntelligentTieringConfigurationRequest).withMarshaller(new GetBucketIntelligentTieringConfigurationRequestMarshaller(this.protocolFactory)));
            return getBucketIntelligentTieringConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketInventoryConfigurationResponse getBucketInventoryConfiguration(GetBucketInventoryConfigurationRequest getBucketInventoryConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketInventoryConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketInventoryConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketInventoryConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketInventoryConfiguration");
            GetBucketInventoryConfigurationResponse getBucketInventoryConfigurationResponse = (GetBucketInventoryConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketInventoryConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketInventoryConfigurationRequest).withMarshaller(new GetBucketInventoryConfigurationRequestMarshaller(this.protocolFactory)));
            return getBucketInventoryConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketLifecycleConfigurationResponse getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketLifecycleConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketLifecycleConfiguration");
            GetBucketLifecycleConfigurationResponse getBucketLifecycleConfigurationResponse = (GetBucketLifecycleConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketLifecycleConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketLifecycleConfigurationRequest).withMarshaller(new GetBucketLifecycleConfigurationRequestMarshaller(this.protocolFactory)));
            return getBucketLifecycleConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketLocationResponse getBucketLocation(GetBucketLocationRequest getBucketLocationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketLocationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketLocationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketLocationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketLocation");
            GetBucketLocationResponse getBucketLocationResponse = (GetBucketLocationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketLocation").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketLocationRequest).withMarshaller(new GetBucketLocationRequestMarshaller(this.protocolFactory)));
            return getBucketLocationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketLoggingResponse getBucketLogging(GetBucketLoggingRequest getBucketLoggingRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketLoggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketLoggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketLoggingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketLogging");
            GetBucketLoggingResponse getBucketLoggingResponse = (GetBucketLoggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketLogging").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketLoggingRequest).withMarshaller(new GetBucketLoggingRequestMarshaller(this.protocolFactory)));
            return getBucketLoggingResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketMetadataConfigurationResponse getBucketMetadataConfiguration(GetBucketMetadataConfigurationRequest getBucketMetadataConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketMetadataConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketMetadataConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketMetadataConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketMetadataConfiguration");
            GetBucketMetadataConfigurationResponse getBucketMetadataConfigurationResponse = (GetBucketMetadataConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketMetadataConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketMetadataConfigurationRequest).withMarshaller(new GetBucketMetadataConfigurationRequestMarshaller(this.protocolFactory)));
            return getBucketMetadataConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketMetadataTableConfigurationResponse getBucketMetadataTableConfiguration(GetBucketMetadataTableConfigurationRequest getBucketMetadataTableConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketMetadataTableConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketMetadataTableConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketMetadataTableConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketMetadataTableConfiguration");
            GetBucketMetadataTableConfigurationResponse getBucketMetadataTableConfigurationResponse = (GetBucketMetadataTableConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketMetadataTableConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketMetadataTableConfigurationRequest).withMarshaller(new GetBucketMetadataTableConfigurationRequestMarshaller(this.protocolFactory)));
            return getBucketMetadataTableConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketMetricsConfigurationResponse getBucketMetricsConfiguration(GetBucketMetricsConfigurationRequest getBucketMetricsConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketMetricsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketMetricsConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketMetricsConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketMetricsConfiguration");
            GetBucketMetricsConfigurationResponse getBucketMetricsConfigurationResponse = (GetBucketMetricsConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketMetricsConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketMetricsConfigurationRequest).withMarshaller(new GetBucketMetricsConfigurationRequestMarshaller(this.protocolFactory)));
            return getBucketMetricsConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketNotificationConfigurationResponse getBucketNotificationConfiguration(GetBucketNotificationConfigurationRequest getBucketNotificationConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketNotificationConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketNotificationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketNotificationConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketNotificationConfiguration");
            GetBucketNotificationConfigurationResponse getBucketNotificationConfigurationResponse = (GetBucketNotificationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketNotificationConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketNotificationConfigurationRequest).withMarshaller(new GetBucketNotificationConfigurationRequestMarshaller(this.protocolFactory)));
            return getBucketNotificationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketOwnershipControlsResponse getBucketOwnershipControls(GetBucketOwnershipControlsRequest getBucketOwnershipControlsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketOwnershipControlsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketOwnershipControlsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketOwnershipControlsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketOwnershipControls");
            GetBucketOwnershipControlsResponse getBucketOwnershipControlsResponse = (GetBucketOwnershipControlsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketOwnershipControls").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketOwnershipControlsRequest).withMarshaller(new GetBucketOwnershipControlsRequestMarshaller(this.protocolFactory)));
            return getBucketOwnershipControlsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketPolicyResponse getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketPolicy");
            GetBucketPolicyResponse getBucketPolicyResponse = (GetBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketPolicy").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketPolicyRequest).withMarshaller(new GetBucketPolicyRequestMarshaller(this.protocolFactory)));
            return getBucketPolicyResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketPolicyStatusResponse getBucketPolicyStatus(GetBucketPolicyStatusRequest getBucketPolicyStatusRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketPolicyStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketPolicyStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketPolicyStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketPolicyStatus");
            GetBucketPolicyStatusResponse getBucketPolicyStatusResponse = (GetBucketPolicyStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketPolicyStatus").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketPolicyStatusRequest).withMarshaller(new GetBucketPolicyStatusRequestMarshaller(this.protocolFactory)));
            return getBucketPolicyStatusResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketReplicationResponse getBucketReplication(GetBucketReplicationRequest getBucketReplicationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketReplicationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketReplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketReplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketReplication");
            GetBucketReplicationResponse getBucketReplicationResponse = (GetBucketReplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketReplication").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketReplicationRequest).withMarshaller(new GetBucketReplicationRequestMarshaller(this.protocolFactory)));
            return getBucketReplicationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketRequestPaymentResponse getBucketRequestPayment(GetBucketRequestPaymentRequest getBucketRequestPaymentRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketRequestPaymentResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketRequestPaymentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketRequestPaymentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketRequestPayment");
            GetBucketRequestPaymentResponse getBucketRequestPaymentResponse = (GetBucketRequestPaymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketRequestPayment").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketRequestPaymentRequest).withMarshaller(new GetBucketRequestPaymentRequestMarshaller(this.protocolFactory)));
            return getBucketRequestPaymentResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketTaggingResponse getBucketTagging(GetBucketTaggingRequest getBucketTaggingRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketTaggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketTaggingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketTagging");
            GetBucketTaggingResponse getBucketTaggingResponse = (GetBucketTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketTagging").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketTaggingRequest).withMarshaller(new GetBucketTaggingRequestMarshaller(this.protocolFactory)));
            return getBucketTaggingResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketVersioningResponse getBucketVersioning(GetBucketVersioningRequest getBucketVersioningRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketVersioningResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketVersioningRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketVersioningRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketVersioning");
            GetBucketVersioningResponse getBucketVersioningResponse = (GetBucketVersioningResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketVersioning").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketVersioningRequest).withMarshaller(new GetBucketVersioningRequestMarshaller(this.protocolFactory)));
            return getBucketVersioningResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketWebsiteResponse getBucketWebsite(GetBucketWebsiteRequest getBucketWebsiteRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketWebsiteResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getBucketWebsiteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getBucketWebsiteRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketWebsite");
            GetBucketWebsiteResponse getBucketWebsiteResponse = (GetBucketWebsiteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketWebsite").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getBucketWebsiteRequest).withMarshaller(new GetBucketWebsiteRequestMarshaller(this.protocolFactory)));
            return getBucketWebsiteResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnT> ReturnT getObject(GetObjectRequest getObjectRequest, ResponseTransformer<GetObjectResponse, ReturnT> responseTransformer) throws NoSuchKeyException, InvalidObjectStateException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(true));
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getObjectRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetObject");
            ReturnT ReturnT = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObject").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getObjectRequest).withMetricCollector(apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(false).isRequestStreaming(false).requestValidationMode(getObjectRequest.checksumModeAsString()).responseAlgorithmsV2(DefaultChecksumAlgorithm.CRC32C, DefaultChecksumAlgorithm.CRC32, DefaultChecksumAlgorithm.CRC64NVME, DefaultChecksumAlgorithm.SHA1, DefaultChecksumAlgorithm.SHA256).build()).withResponseTransformer(responseTransformer).withMarshaller(new GetObjectRequestMarshaller(this.protocolFactory)), responseTransformer);
            return ReturnT;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetObjectAclResponse getObjectAcl(GetObjectAclRequest getObjectAclRequest) throws NoSuchKeyException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetObjectAclResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getObjectAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getObjectAclRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetObjectAcl");
            GetObjectAclResponse getObjectAclResponse = (GetObjectAclResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectAcl").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getObjectAclRequest).withMarshaller(new GetObjectAclRequestMarshaller(this.protocolFactory)));
            return getObjectAclResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetObjectAttributesResponse getObjectAttributes(GetObjectAttributesRequest getObjectAttributesRequest) throws NoSuchKeyException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetObjectAttributesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getObjectAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getObjectAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetObjectAttributes");
            GetObjectAttributesResponse getObjectAttributesResponse = (GetObjectAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectAttributes").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getObjectAttributesRequest).withMarshaller(new GetObjectAttributesRequestMarshaller(this.protocolFactory)));
            return getObjectAttributesResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetObjectLegalHoldResponse getObjectLegalHold(GetObjectLegalHoldRequest getObjectLegalHoldRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetObjectLegalHoldResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getObjectLegalHoldRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getObjectLegalHoldRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetObjectLegalHold");
            GetObjectLegalHoldResponse getObjectLegalHoldResponse = (GetObjectLegalHoldResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectLegalHold").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getObjectLegalHoldRequest).withMarshaller(new GetObjectLegalHoldRequestMarshaller(this.protocolFactory)));
            return getObjectLegalHoldResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetObjectLockConfigurationResponse getObjectLockConfiguration(GetObjectLockConfigurationRequest getObjectLockConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetObjectLockConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getObjectLockConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getObjectLockConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetObjectLockConfiguration");
            GetObjectLockConfigurationResponse getObjectLockConfigurationResponse = (GetObjectLockConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectLockConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getObjectLockConfigurationRequest).withMarshaller(new GetObjectLockConfigurationRequestMarshaller(this.protocolFactory)));
            return getObjectLockConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetObjectRetentionResponse getObjectRetention(GetObjectRetentionRequest getObjectRetentionRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetObjectRetentionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getObjectRetentionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getObjectRetentionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetObjectRetention");
            GetObjectRetentionResponse getObjectRetentionResponse = (GetObjectRetentionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectRetention").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getObjectRetentionRequest).withMarshaller(new GetObjectRetentionRequestMarshaller(this.protocolFactory)));
            return getObjectRetentionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetObjectTaggingResponse getObjectTagging(GetObjectTaggingRequest getObjectTaggingRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetObjectTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getObjectTaggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getObjectTaggingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetObjectTagging");
            GetObjectTaggingResponse getObjectTaggingResponse = (GetObjectTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectTagging").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getObjectTaggingRequest).withMarshaller(new GetObjectTaggingRequestMarshaller(this.protocolFactory)));
            return getObjectTaggingResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnT> ReturnT getObjectTorrent(GetObjectTorrentRequest getObjectTorrentRequest, ResponseTransformer<GetObjectTorrentResponse, ReturnT> responseTransformer) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetObjectTorrentResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(true));
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getObjectTorrentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getObjectTorrentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetObjectTorrent");
            ReturnT ReturnT = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectTorrent").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getObjectTorrentRequest).withMetricCollector(apiCallMetricCollector).withResponseTransformer(responseTransformer).withMarshaller(new GetObjectTorrentRequestMarshaller(this.protocolFactory)), responseTransformer);
            return ReturnT;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPublicAccessBlockResponse getPublicAccessBlock(GetPublicAccessBlockRequest getPublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetPublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getPublicAccessBlockRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, getPublicAccessBlockRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPublicAccessBlock");
            GetPublicAccessBlockResponse getPublicAccessBlockResponse = (GetPublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicAccessBlock").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(getPublicAccessBlockRequest).withMarshaller(new GetPublicAccessBlockRequestMarshaller(this.protocolFactory)));
            return getPublicAccessBlockResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HeadBucketResponse headBucket(HeadBucketRequest headBucketRequest) throws NoSuchBucketException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(HeadBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(headBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, headBucketRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "HeadBucket");
            HeadBucketResponse headBucketResponse = (HeadBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("HeadBucket").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(headBucketRequest).withMarshaller(new HeadBucketRequestMarshaller(this.protocolFactory)));
            return headBucketResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HeadObjectResponse headObject(HeadObjectRequest headObjectRequest) throws NoSuchKeyException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(HeadObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(headObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, headObjectRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "HeadObject");
            HeadObjectResponse headObjectResponse = (HeadObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("HeadObject").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(headObjectRequest).withMarshaller(new HeadObjectRequestMarshaller(this.protocolFactory)));
            return headObjectResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBucketAnalyticsConfigurationsResponse listBucketAnalyticsConfigurations(ListBucketAnalyticsConfigurationsRequest listBucketAnalyticsConfigurationsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListBucketAnalyticsConfigurationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listBucketAnalyticsConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, listBucketAnalyticsConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBucketAnalyticsConfigurations");
            ListBucketAnalyticsConfigurationsResponse listBucketAnalyticsConfigurationsResponse = (ListBucketAnalyticsConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBucketAnalyticsConfigurations").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(listBucketAnalyticsConfigurationsRequest).withMarshaller(new ListBucketAnalyticsConfigurationsRequestMarshaller(this.protocolFactory)));
            return listBucketAnalyticsConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBucketIntelligentTieringConfigurationsResponse listBucketIntelligentTieringConfigurations(ListBucketIntelligentTieringConfigurationsRequest listBucketIntelligentTieringConfigurationsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListBucketIntelligentTieringConfigurationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listBucketIntelligentTieringConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, listBucketIntelligentTieringConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBucketIntelligentTieringConfigurations");
            ListBucketIntelligentTieringConfigurationsResponse listBucketIntelligentTieringConfigurationsResponse = (ListBucketIntelligentTieringConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBucketIntelligentTieringConfigurations").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(listBucketIntelligentTieringConfigurationsRequest).withMarshaller(new ListBucketIntelligentTieringConfigurationsRequestMarshaller(this.protocolFactory)));
            return listBucketIntelligentTieringConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBucketInventoryConfigurationsResponse listBucketInventoryConfigurations(ListBucketInventoryConfigurationsRequest listBucketInventoryConfigurationsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListBucketInventoryConfigurationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listBucketInventoryConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, listBucketInventoryConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBucketInventoryConfigurations");
            ListBucketInventoryConfigurationsResponse listBucketInventoryConfigurationsResponse = (ListBucketInventoryConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBucketInventoryConfigurations").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(listBucketInventoryConfigurationsRequest).withMarshaller(new ListBucketInventoryConfigurationsRequestMarshaller(this.protocolFactory)));
            return listBucketInventoryConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBucketMetricsConfigurationsResponse listBucketMetricsConfigurations(ListBucketMetricsConfigurationsRequest listBucketMetricsConfigurationsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListBucketMetricsConfigurationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listBucketMetricsConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, listBucketMetricsConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBucketMetricsConfigurations");
            ListBucketMetricsConfigurationsResponse listBucketMetricsConfigurationsResponse = (ListBucketMetricsConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBucketMetricsConfigurations").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(listBucketMetricsConfigurationsRequest).withMarshaller(new ListBucketMetricsConfigurationsRequestMarshaller(this.protocolFactory)));
            return listBucketMetricsConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBucketsResponse listBuckets(ListBucketsRequest listBucketsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListBucketsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listBucketsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, listBucketsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBuckets");
            ListBucketsResponse listBucketsResponse = (ListBucketsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBuckets").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(listBucketsRequest).withMarshaller(new ListBucketsRequestMarshaller(this.protocolFactory)));
            return listBucketsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDirectoryBucketsResponse listDirectoryBuckets(ListDirectoryBucketsRequest listDirectoryBucketsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListDirectoryBucketsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listDirectoryBucketsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, listDirectoryBucketsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDirectoryBuckets");
            ListDirectoryBucketsResponse listDirectoryBucketsResponse = (ListDirectoryBucketsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDirectoryBuckets").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(listDirectoryBucketsRequest).withMarshaller(new ListDirectoryBucketsRequestMarshaller(this.protocolFactory)));
            return listDirectoryBucketsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMultipartUploadsResponse listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListMultipartUploadsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listMultipartUploadsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, listMultipartUploadsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMultipartUploads");
            ListMultipartUploadsResponse listMultipartUploadsResponse = (ListMultipartUploadsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMultipartUploads").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(listMultipartUploadsRequest).withMarshaller(new ListMultipartUploadsRequestMarshaller(this.protocolFactory)));
            return listMultipartUploadsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListObjectVersionsResponse listObjectVersions(ListObjectVersionsRequest listObjectVersionsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListObjectVersionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listObjectVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, listObjectVersionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListObjectVersions");
            ListObjectVersionsResponse listObjectVersionsResponse = (ListObjectVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjectVersions").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(listObjectVersionsRequest).withMarshaller(new ListObjectVersionsRequestMarshaller(this.protocolFactory)));
            return listObjectVersionsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListObjectsResponse listObjects(ListObjectsRequest listObjectsRequest) throws NoSuchBucketException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListObjectsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listObjectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, listObjectsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListObjects");
            ListObjectsResponse listObjectsResponse = (ListObjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjects").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(listObjectsRequest).withMarshaller(new ListObjectsRequestMarshaller(this.protocolFactory)));
            return listObjectsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListObjectsV2Response listObjectsV2(ListObjectsV2Request listObjectsV2Request) throws NoSuchBucketException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListObjectsV2Response::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listObjectsV2Request, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, listObjectsV2Request.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListObjectsV2");
            ListObjectsV2Response listObjectsV2Response = (ListObjectsV2Response)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjectsV2").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(listObjectsV2Request).withMarshaller(new ListObjectsV2RequestMarshaller(this.protocolFactory)));
            return listObjectsV2Response;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPartsResponse listParts(ListPartsRequest listPartsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListPartsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listPartsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, listPartsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListParts");
            ListPartsResponse listPartsResponse = (ListPartsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListParts").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(listPartsRequest).withMarshaller(new ListPartsRequestMarshaller(this.protocolFactory)));
            return listPartsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketAccelerateConfigurationResponse putBucketAccelerateConfiguration(PutBucketAccelerateConfigurationRequest putBucketAccelerateConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketAccelerateConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketAccelerateConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketAccelerateConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketAccelerateConfiguration");
            PutBucketAccelerateConfigurationResponse putBucketAccelerateConfigurationResponse = (PutBucketAccelerateConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketAccelerateConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketAccelerateConfigurationRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(false).isRequestStreaming(false).requestAlgorithm(putBucketAccelerateConfigurationRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutBucketAccelerateConfigurationRequestMarshaller(this.protocolFactory)));
            return putBucketAccelerateConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketAclResponse putBucketAcl(PutBucketAclRequest putBucketAclRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketAclResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketAclRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketAcl");
            PutBucketAclResponse putBucketAclResponse = (PutBucketAclResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketAcl").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketAclRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putBucketAclRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutBucketAclRequestMarshaller(this.protocolFactory)));
            return putBucketAclResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketAnalyticsConfigurationResponse putBucketAnalyticsConfiguration(PutBucketAnalyticsConfigurationRequest putBucketAnalyticsConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketAnalyticsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketAnalyticsConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketAnalyticsConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketAnalyticsConfiguration");
            PutBucketAnalyticsConfigurationResponse putBucketAnalyticsConfigurationResponse = (PutBucketAnalyticsConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketAnalyticsConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketAnalyticsConfigurationRequest).withMarshaller(new PutBucketAnalyticsConfigurationRequestMarshaller(this.protocolFactory)));
            return putBucketAnalyticsConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketCorsResponse putBucketCors(PutBucketCorsRequest putBucketCorsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketCorsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketCorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketCorsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketCors");
            PutBucketCorsResponse putBucketCorsResponse = (PutBucketCorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketCors").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketCorsRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putBucketCorsRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutBucketCorsRequestMarshaller(this.protocolFactory)));
            return putBucketCorsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketEncryptionResponse putBucketEncryption(PutBucketEncryptionRequest putBucketEncryptionRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketEncryptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketEncryptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketEncryptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketEncryption");
            PutBucketEncryptionResponse putBucketEncryptionResponse = (PutBucketEncryptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketEncryption").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketEncryptionRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putBucketEncryptionRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutBucketEncryptionRequestMarshaller(this.protocolFactory)));
            return putBucketEncryptionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketIntelligentTieringConfigurationResponse putBucketIntelligentTieringConfiguration(PutBucketIntelligentTieringConfigurationRequest putBucketIntelligentTieringConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketIntelligentTieringConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketIntelligentTieringConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketIntelligentTieringConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketIntelligentTieringConfiguration");
            PutBucketIntelligentTieringConfigurationResponse putBucketIntelligentTieringConfigurationResponse = (PutBucketIntelligentTieringConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketIntelligentTieringConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketIntelligentTieringConfigurationRequest).withMarshaller(new PutBucketIntelligentTieringConfigurationRequestMarshaller(this.protocolFactory)));
            return putBucketIntelligentTieringConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketInventoryConfigurationResponse putBucketInventoryConfiguration(PutBucketInventoryConfigurationRequest putBucketInventoryConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketInventoryConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketInventoryConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketInventoryConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketInventoryConfiguration");
            PutBucketInventoryConfigurationResponse putBucketInventoryConfigurationResponse = (PutBucketInventoryConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketInventoryConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketInventoryConfigurationRequest).withMarshaller(new PutBucketInventoryConfigurationRequestMarshaller(this.protocolFactory)));
            return putBucketInventoryConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketLifecycleConfigurationResponse putBucketLifecycleConfiguration(PutBucketLifecycleConfigurationRequest putBucketLifecycleConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketLifecycleConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketLifecycleConfiguration");
            PutBucketLifecycleConfigurationResponse putBucketLifecycleConfigurationResponse = (PutBucketLifecycleConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketLifecycleConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketLifecycleConfigurationRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putBucketLifecycleConfigurationRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutBucketLifecycleConfigurationRequestMarshaller(this.protocolFactory)));
            return putBucketLifecycleConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketLoggingResponse putBucketLogging(PutBucketLoggingRequest putBucketLoggingRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketLoggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketLoggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketLoggingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketLogging");
            PutBucketLoggingResponse putBucketLoggingResponse = (PutBucketLoggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketLogging").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketLoggingRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putBucketLoggingRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutBucketLoggingRequestMarshaller(this.protocolFactory)));
            return putBucketLoggingResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketMetricsConfigurationResponse putBucketMetricsConfiguration(PutBucketMetricsConfigurationRequest putBucketMetricsConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketMetricsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketMetricsConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketMetricsConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketMetricsConfiguration");
            PutBucketMetricsConfigurationResponse putBucketMetricsConfigurationResponse = (PutBucketMetricsConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketMetricsConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketMetricsConfigurationRequest).withMarshaller(new PutBucketMetricsConfigurationRequestMarshaller(this.protocolFactory)));
            return putBucketMetricsConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketNotificationConfigurationResponse putBucketNotificationConfiguration(PutBucketNotificationConfigurationRequest putBucketNotificationConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketNotificationConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketNotificationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketNotificationConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketNotificationConfiguration");
            PutBucketNotificationConfigurationResponse putBucketNotificationConfigurationResponse = (PutBucketNotificationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketNotificationConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketNotificationConfigurationRequest).withMarshaller(new PutBucketNotificationConfigurationRequestMarshaller(this.protocolFactory)));
            return putBucketNotificationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketOwnershipControlsResponse putBucketOwnershipControls(PutBucketOwnershipControlsRequest putBucketOwnershipControlsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketOwnershipControlsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketOwnershipControlsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketOwnershipControlsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketOwnershipControls");
            PutBucketOwnershipControlsResponse putBucketOwnershipControlsResponse = (PutBucketOwnershipControlsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketOwnershipControls").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketOwnershipControlsRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putBucketOwnershipControlsRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutBucketOwnershipControlsRequestMarshaller(this.protocolFactory)));
            return putBucketOwnershipControlsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketPolicyResponse putBucketPolicy(PutBucketPolicyRequest putBucketPolicyRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketPolicy");
            PutBucketPolicyResponse putBucketPolicyResponse = (PutBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketPolicy").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketPolicyRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putBucketPolicyRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutBucketPolicyRequestMarshaller(this.protocolFactory)));
            return putBucketPolicyResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketReplicationResponse putBucketReplication(PutBucketReplicationRequest putBucketReplicationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketReplicationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketReplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketReplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketReplication");
            PutBucketReplicationResponse putBucketReplicationResponse = (PutBucketReplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketReplication").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketReplicationRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putBucketReplicationRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutBucketReplicationRequestMarshaller(this.protocolFactory)));
            return putBucketReplicationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketRequestPaymentResponse putBucketRequestPayment(PutBucketRequestPaymentRequest putBucketRequestPaymentRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketRequestPaymentResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketRequestPaymentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketRequestPaymentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketRequestPayment");
            PutBucketRequestPaymentResponse putBucketRequestPaymentResponse = (PutBucketRequestPaymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketRequestPayment").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketRequestPaymentRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putBucketRequestPaymentRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutBucketRequestPaymentRequestMarshaller(this.protocolFactory)));
            return putBucketRequestPaymentResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketTaggingResponse putBucketTagging(PutBucketTaggingRequest putBucketTaggingRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketTaggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketTaggingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketTagging");
            PutBucketTaggingResponse putBucketTaggingResponse = (PutBucketTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketTagging").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketTaggingRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putBucketTaggingRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutBucketTaggingRequestMarshaller(this.protocolFactory)));
            return putBucketTaggingResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketVersioningResponse putBucketVersioning(PutBucketVersioningRequest putBucketVersioningRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketVersioningResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketVersioningRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketVersioningRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketVersioning");
            PutBucketVersioningResponse putBucketVersioningResponse = (PutBucketVersioningResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketVersioning").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketVersioningRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putBucketVersioningRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutBucketVersioningRequestMarshaller(this.protocolFactory)));
            return putBucketVersioningResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketWebsiteResponse putBucketWebsite(PutBucketWebsiteRequest putBucketWebsiteRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketWebsiteResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putBucketWebsiteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putBucketWebsiteRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketWebsite");
            PutBucketWebsiteResponse putBucketWebsiteResponse = (PutBucketWebsiteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketWebsite").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putBucketWebsiteRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putBucketWebsiteRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutBucketWebsiteRequestMarshaller(this.protocolFactory)));
            return putBucketWebsiteResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutObjectResponse putObject(PutObjectRequest putObjectRequest, RequestBody requestBody) throws InvalidRequestException, InvalidWriteOffsetException, TooManyPartsException, EncryptionTypeMismatchException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putObjectRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutObject");
            PutObjectResponse putObjectResponse = (PutObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObject").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putObjectRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(false).isRequestStreaming(true).requestAlgorithm(putObjectRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withRequestBody(requestBody).withMarshaller(((StreamingRequestMarshaller.Builder)StreamingRequestMarshaller.builder().delegateMarshaller(new PutObjectRequestMarshaller(this.protocolFactory))).requestBody(requestBody).build()));
            return putObjectResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutObjectAclResponse putObjectAcl(PutObjectAclRequest putObjectAclRequest) throws NoSuchKeyException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectAclResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putObjectAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putObjectAclRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutObjectAcl");
            PutObjectAclResponse putObjectAclResponse = (PutObjectAclResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObjectAcl").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putObjectAclRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putObjectAclRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutObjectAclRequestMarshaller(this.protocolFactory)));
            return putObjectAclResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutObjectLegalHoldResponse putObjectLegalHold(PutObjectLegalHoldRequest putObjectLegalHoldRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectLegalHoldResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putObjectLegalHoldRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putObjectLegalHoldRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutObjectLegalHold");
            PutObjectLegalHoldResponse putObjectLegalHoldResponse = (PutObjectLegalHoldResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObjectLegalHold").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putObjectLegalHoldRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putObjectLegalHoldRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutObjectLegalHoldRequestMarshaller(this.protocolFactory)));
            return putObjectLegalHoldResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutObjectLockConfigurationResponse putObjectLockConfiguration(PutObjectLockConfigurationRequest putObjectLockConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectLockConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putObjectLockConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putObjectLockConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutObjectLockConfiguration");
            PutObjectLockConfigurationResponse putObjectLockConfigurationResponse = (PutObjectLockConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObjectLockConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putObjectLockConfigurationRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putObjectLockConfigurationRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutObjectLockConfigurationRequestMarshaller(this.protocolFactory)));
            return putObjectLockConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutObjectRetentionResponse putObjectRetention(PutObjectRetentionRequest putObjectRetentionRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectRetentionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putObjectRetentionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putObjectRetentionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutObjectRetention");
            PutObjectRetentionResponse putObjectRetentionResponse = (PutObjectRetentionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObjectRetention").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putObjectRetentionRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putObjectRetentionRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutObjectRetentionRequestMarshaller(this.protocolFactory)));
            return putObjectRetentionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutObjectTaggingResponse putObjectTagging(PutObjectTaggingRequest putObjectTaggingRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putObjectTaggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putObjectTaggingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutObjectTagging");
            PutObjectTaggingResponse putObjectTaggingResponse = (PutObjectTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObjectTagging").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putObjectTaggingRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putObjectTaggingRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutObjectTaggingRequestMarshaller(this.protocolFactory)));
            return putObjectTaggingResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPublicAccessBlockResponse putPublicAccessBlock(PutPublicAccessBlockRequest putPublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutPublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putPublicAccessBlockRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, putPublicAccessBlockRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutPublicAccessBlock");
            PutPublicAccessBlockResponse putPublicAccessBlockResponse = (PutPublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPublicAccessBlock").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(putPublicAccessBlockRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(putPublicAccessBlockRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new PutPublicAccessBlockRequestMarshaller(this.protocolFactory)));
            return putPublicAccessBlockResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RenameObjectResponse renameObject(RenameObjectRequest renameObjectRequest) throws IdempotencyParameterMismatchException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(RenameObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(renameObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, renameObjectRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RenameObject");
            RenameObjectResponse renameObjectResponse = (RenameObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RenameObject").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(renameObjectRequest).withMarshaller(new RenameObjectRequestMarshaller(this.protocolFactory)));
            return renameObjectResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreObjectResponse restoreObject(RestoreObjectRequest restoreObjectRequest) throws ObjectAlreadyInActiveTierErrorException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(RestoreObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(restoreObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, restoreObjectRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreObject");
            RestoreObjectResponse restoreObjectResponse = (RestoreObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreObject").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(restoreObjectRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(false).isRequestStreaming(false).requestAlgorithm(restoreObjectRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new RestoreObjectRequestMarshaller(this.protocolFactory)));
            return restoreObjectResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBucketMetadataInventoryTableConfigurationResponse updateBucketMetadataInventoryTableConfiguration(UpdateBucketMetadataInventoryTableConfigurationRequest updateBucketMetadataInventoryTableConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateBucketMetadataInventoryTableConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateBucketMetadataInventoryTableConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, updateBucketMetadataInventoryTableConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBucketMetadataInventoryTableConfiguration");
            UpdateBucketMetadataInventoryTableConfigurationResponse updateBucketMetadataInventoryTableConfigurationResponse = (UpdateBucketMetadataInventoryTableConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBucketMetadataInventoryTableConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(updateBucketMetadataInventoryTableConfigurationRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(updateBucketMetadataInventoryTableConfigurationRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new UpdateBucketMetadataInventoryTableConfigurationRequestMarshaller(this.protocolFactory)));
            return updateBucketMetadataInventoryTableConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBucketMetadataJournalTableConfigurationResponse updateBucketMetadataJournalTableConfiguration(UpdateBucketMetadataJournalTableConfigurationRequest updateBucketMetadataJournalTableConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateBucketMetadataJournalTableConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateBucketMetadataJournalTableConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, updateBucketMetadataJournalTableConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBucketMetadataJournalTableConfiguration");
            UpdateBucketMetadataJournalTableConfigurationResponse updateBucketMetadataJournalTableConfigurationResponse = (UpdateBucketMetadataJournalTableConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBucketMetadataJournalTableConfiguration").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(updateBucketMetadataJournalTableConfigurationRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(true).isRequestStreaming(false).requestAlgorithm(updateBucketMetadataJournalTableConfigurationRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withMarshaller(new UpdateBucketMetadataJournalTableConfigurationRequestMarshaller(this.protocolFactory)));
            return updateBucketMetadataJournalTableConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadPartResponse uploadPart(UploadPartRequest uploadPartRequest, RequestBody requestBody) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UploadPartResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(uploadPartRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, uploadPartRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UploadPart");
            UploadPartResponse uploadPartResponse = (UploadPartResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UploadPart").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(uploadPartRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, HttpChecksum.builder().requestChecksumRequired(false).isRequestStreaming(true).requestAlgorithm(uploadPartRequest.checksumAlgorithmAsString()).requestAlgorithmHeader("x-amz-sdk-checksum-algorithm").build()).withRequestBody(requestBody).withMarshaller(((StreamingRequestMarshaller.Builder)StreamingRequestMarshaller.builder().delegateMarshaller(new UploadPartRequestMarshaller(this.protocolFactory))).requestBody(requestBody).build()));
            return uploadPartResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadPartCopyResponse uploadPartCopy(UploadPartCopyRequest uploadPartCopyRequest) throws AwsServiceException, SdkClientException, S3Exception {
        uploadPartCopyRequest = CustomRequestTransformerUtils.modifyUploadPartCopyRequest(uploadPartCopyRequest);
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UploadPartCopyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(uploadPartCopyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, uploadPartCopyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UploadPartCopy");
            UploadPartCopyResponse uploadPartCopyResponse = (UploadPartCopyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UploadPartCopy").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput(uploadPartCopyRequest).withMarshaller(new UploadPartCopyRequestMarshaller(this.protocolFactory)));
            return uploadPartCopyResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteGetObjectResponseResponse writeGetObjectResponse(WriteGetObjectResponseRequest writeGetObjectResponseRequest, RequestBody requestBody) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(WriteGetObjectResponseResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(writeGetObjectResponseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3Client.resolveMetricPublishers(clientConfiguration, writeGetObjectResponseRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "WriteGetObjectResponse");
            String hostPrefix = "{RequestRoute}.";
            HostnameValidator.validateHostnameCompliant(writeGetObjectResponseRequest.requestRoute(), "RequestRoute", "writeGetObjectResponseRequest");
            String resolvedHostExpression = String.format("%s.", writeGetObjectResponseRequest.requestRoute());
            WriteGetObjectResponseResponse writeGetObjectResponseResponse = (WriteGetObjectResponseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("WriteGetObjectResponse").withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration).withInput(writeGetObjectResponseRequest).withRequestBody(requestBody).withMarshaller(((StreamingRequestMarshaller.Builder)((StreamingRequestMarshaller.Builder)StreamingRequestMarshaller.builder().delegateMarshaller(new WriteGetObjectResponseRequestMarshaller(this.protocolFactory))).requestBody(requestBody).transferEncoding(true)).build()));
            return writeGetObjectResponseResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public S3Utilities utilities() {
        return S3Utilities.create(this.clientConfiguration);
    }

    @Override
    public S3Waiter waiter() {
        return S3Waiter.builder().client(this).build();
    }

    @Override
    public final String serviceName() {
        return "s3";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        S3ServiceClientConfigurationBuilder serviceConfigBuilder = new S3ServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        AttributeMap newContextParams = configuration.option(SdkClientOption.CLIENT_CONTEXT_PARAMS);
        AttributeMap originalContextParams = clientConfiguration.option(SdkClientOption.CLIENT_CONTEXT_PARAMS);
        newContextParams = newContextParams != null ? newContextParams : AttributeMap.empty();
        originalContextParams = originalContextParams != null ? originalContextParams : AttributeMap.empty();
        Validate.validState(Objects.equals(originalContextParams.get(S3ClientContextParams.CROSS_REGION_ACCESS_ENABLED), newContextParams.get(S3ClientContextParams.CROSS_REGION_ACCESS_ENABLED)), "CROSS_REGION_ACCESS_ENABLED cannot be modified by request level plugins", new Object[0]);
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private AwsS3ProtocolFactory init() {
        return ((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)AwsS3ProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("EncryptionTypeMismatch").exceptionBuilderSupplier(EncryptionTypeMismatchException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchUpload").exceptionBuilderSupplier(NoSuchUploadException::builder).httpStatusCode(404).build())).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidObjectState").exceptionBuilderSupplier(InvalidObjectStateException::builder).httpStatusCode(403).build())).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidWriteOffset").exceptionBuilderSupplier(InvalidWriteOffsetException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("BucketAlreadyOwnedByYou").exceptionBuilderSupplier(BucketAlreadyOwnedByYouException::builder).httpStatusCode(409).build())).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchKey").exceptionBuilderSupplier(NoSuchKeyException::builder).httpStatusCode(404).build())).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequest").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ObjectAlreadyInActiveTierError").exceptionBuilderSupplier(ObjectAlreadyInActiveTierErrorException::builder).httpStatusCode(403).build())).registerModeledException(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatch").exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("BucketAlreadyExists").exceptionBuilderSupplier(BucketAlreadyExistsException::builder).httpStatusCode(409).build())).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchBucket").exceptionBuilderSupplier(NoSuchBucketException::builder).httpStatusCode(404).build())).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyParts").exceptionBuilderSupplier(TooManyPartsException::builder).httpStatusCode(400).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ObjectNotInActiveTierError").exceptionBuilderSupplier(ObjectNotInActiveTierErrorException::builder).httpStatusCode(403).build())).clientConfiguration(this.clientConfiguration)).defaultServiceExceptionSupplier(S3Exception::builder)).build();
    }

    @Override
    public final S3ServiceClientConfiguration serviceClientConfiguration() {
        return new S3ServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        this.clientHandler.close();
    }
}

