/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.s3.internal.resource.S3ArnUtils;
import software.amazon.awssdk.services.s3.internal.resource.S3ResourceType;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.UploadPartCopyRequest;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
public final class CustomRequestTransformerUtils {
    private CustomRequestTransformerUtils() {
    }

    public static CopyObjectRequest modifyCopyObjectRequest(CopyObjectRequest request) {
        if (request.copySource() != null) {
            CustomRequestTransformerUtils.requireNotSet(request.sourceBucket(), "sourceBucket");
            CustomRequestTransformerUtils.requireNotSet(request.sourceKey(), "sourceKey");
            CustomRequestTransformerUtils.requireNotSet(request.sourceVersionId(), "sourceVersionId");
            return request;
        }
        String copySource = CustomRequestTransformerUtils.constructCopySource(CustomRequestTransformerUtils.requireSet(request.sourceBucket(), "sourceBucket"), CustomRequestTransformerUtils.requireSet(request.sourceKey(), "sourceKey"), request.sourceVersionId());
        return (CopyObjectRequest)request.toBuilder().sourceBucket(null).sourceKey(null).sourceVersionId(null).copySource(copySource).build();
    }

    public static UploadPartCopyRequest modifyUploadPartCopyRequest(UploadPartCopyRequest request) {
        if (request.copySource() != null) {
            CustomRequestTransformerUtils.requireNotSet(request.sourceBucket(), "sourceBucket");
            CustomRequestTransformerUtils.requireNotSet(request.sourceKey(), "sourceKey");
            CustomRequestTransformerUtils.requireNotSet(request.sourceVersionId(), "sourceVersionId");
            return request;
        }
        String copySource = CustomRequestTransformerUtils.constructCopySource(CustomRequestTransformerUtils.requireSet(request.sourceBucket(), "sourceBucket"), CustomRequestTransformerUtils.requireSet(request.sourceKey(), "sourceKey"), request.sourceVersionId());
        return (UploadPartCopyRequest)request.toBuilder().sourceBucket(null).sourceKey(null).sourceVersionId(null).copySource(copySource).build();
    }

    private static String constructCopySource(String sourceBucket, String sourceKey, String sourceVersionId) {
        StringBuilder copySource = new StringBuilder();
        copySource.append(SdkHttpUtils.urlEncodeIgnoreSlashes(sourceBucket));
        S3ArnUtils.getArnType(sourceBucket).ifPresent(arnType -> {
            if (arnType == S3ResourceType.ACCESS_POINT || arnType == S3ResourceType.OUTPOST) {
                copySource.append("/object");
            }
        });
        copySource.append("/");
        copySource.append(SdkHttpUtils.urlEncodeIgnoreSlashes(sourceKey));
        if (sourceVersionId != null) {
            copySource.append("?versionId=");
            copySource.append(SdkHttpUtils.urlEncodeIgnoreSlashes(sourceVersionId));
        }
        return copySource.toString();
    }

    private static void requireNotSet(Object value, String paramName) {
        Validate.isTrue(value == null, "Parameter 'copySource' must not be used in conjunction with '%s'", paramName);
    }

    private static <T> T requireSet(T value, String paramName) {
        Validate.isTrue(value != null, "Parameter '%s' must not be null", paramName);
        return value;
    }
}

