/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.checksums;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.checksums.ResponseChecksumValidation;
import software.amazon.awssdk.core.checksums.SdkChecksum;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpHeaders;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.services.s3.model.ChecksumMode;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;

@SdkInternalApi
public final class ChecksumsEnabledValidator {
    public static final ExecutionAttribute<SdkChecksum> CHECKSUM = new ExecutionAttribute("checksum");
    public static final ExecutionAttribute<Boolean> SKIP_MD5_TRAILING_CHECKSUM = new ExecutionAttribute("skipMd5TrailingChecksum");

    private ChecksumsEnabledValidator() {
    }

    public static boolean getObjectChecksumEnabledPerRequest(SdkRequest request, ExecutionAttributes executionAttributes) {
        return request instanceof GetObjectRequest && ((GetObjectRequest)request).checksumMode() != ChecksumMode.ENABLED && ChecksumsEnabledValidator.checksumEnabledPerConfigForGet(executionAttributes);
    }

    public static boolean getObjectChecksumEnabledPerResponse(SdkRequest request, SdkHttpHeaders responseHeaders, ExecutionAttributes executionAttributes) {
        if (!(request instanceof GetObjectRequest)) {
            return false;
        }
        ResponseChecksumValidation responseChecksumValidation = executionAttributes.getAttribute(SdkInternalExecutionAttribute.RESPONSE_CHECKSUM_VALIDATION);
        if (responseChecksumValidation != null && responseChecksumValidation == ResponseChecksumValidation.WHEN_REQUIRED) {
            return false;
        }
        return ChecksumsEnabledValidator.checksumEnabledPerResponse(responseHeaders);
    }

    public static boolean responseChecksumIsValid(SdkHttpResponse httpResponse) {
        return !ChecksumsEnabledValidator.hasServerSideEncryptionHeader(httpResponse);
    }

    private static boolean hasServerSideEncryptionHeader(SdkHttpHeaders httpRequest) {
        if (httpRequest.firstMatchingHeader("x-amz-server-side-encryption-customer-algorithm").isPresent()) {
            return true;
        }
        return httpRequest.firstMatchingHeader("x-amz-server-side-encryption").filter(h -> h.contains(ServerSideEncryption.AWS_KMS.toString())).isPresent();
    }

    private static boolean checksumEnabledPerResponse(SdkHttpHeaders responseHeaders) {
        return responseHeaders.firstMatchingHeader("x-amz-transfer-encoding").filter(b -> b.equals("append-md5")).isPresent();
    }

    private static boolean checksumEnabledPerConfigForGet(ExecutionAttributes executionAttributes) {
        Boolean skipTrailingChecksum = executionAttributes.getAttribute(SKIP_MD5_TRAILING_CHECKSUM);
        if (skipTrailingChecksum != null && skipTrailingChecksum.booleanValue()) {
            return false;
        }
        ResponseChecksumValidation responseChecksumValidation = executionAttributes.getAttribute(SdkInternalExecutionAttribute.RESPONSE_CHECKSUM_VALIDATION);
        return responseChecksumValidation == ResponseChecksumValidation.WHEN_SUPPORTED;
    }
}

