/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.io.ByteArrayInputStream;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;

@SdkInternalApi
public class CreateMultipartUploadRequestInterceptor
implements ExecutionInterceptor {
    @Override
    public Optional<RequestBody> modifyHttpContent(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        if (context.request() instanceof CreateMultipartUploadRequest) {
            return Optional.of(RequestBody.fromInputStream(new ByteArrayInputStream(new byte[0]), 0L));
        }
        return context.requestBody();
    }

    @Override
    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        if (context.request() instanceof CreateMultipartUploadRequest) {
            SdkHttpRequest.Builder builder = ((SdkHttpRequest.Builder)context.httpRequest().toBuilder()).putHeader("Content-Length", String.valueOf(0));
            if (!context.httpRequest().firstMatchingHeader("Content-Type").isPresent()) {
                builder.putHeader("Content-Type", "binary/octet-stream");
            }
            return (SdkHttpRequest)builder.build();
        }
        return context.httpRequest();
    }
}

