/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.multipart;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SplittingTransformerConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartDownloadResumeContext;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartDownloadUtils;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartDownloaderSubscriber;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public class DownloadObjectHelper {
    private static final Logger log = Logger.loggerFor(DownloadObjectHelper.class);
    private final S3AsyncClient s3AsyncClient;
    private final long bufferSizeInBytes;

    public DownloadObjectHelper(S3AsyncClient s3AsyncClient, long bufferSizeInBytes) {
        this.s3AsyncClient = s3AsyncClient;
        this.bufferSizeInBytes = bufferSizeInBytes;
    }

    public <T> CompletableFuture<T> downloadObject(GetObjectRequest getObjectRequest, AsyncResponseTransformer<GetObjectResponse, T> asyncResponseTransformer) {
        if (getObjectRequest.range() != null || getObjectRequest.partNumber() != null) {
            this.logSinglePartMessage(getObjectRequest);
            return this.s3AsyncClient.getObject(getObjectRequest, asyncResponseTransformer);
        }
        AsyncResponseTransformer.SplitResult<GetObjectResponse, T> split = asyncResponseTransformer.split((SplittingTransformerConfiguration)SplittingTransformerConfiguration.builder().bufferSizeInBytes(this.bufferSizeInBytes).build());
        MultipartDownloaderSubscriber subscriber = this.subscriber(getObjectRequest);
        split.publisher().subscribe(subscriber);
        CompletableFuture<T> splitFuture = split.resultFuture();
        CompletableFutureUtils.forwardExceptionTo(subscriber.future(), splitFuture);
        return splitFuture;
    }

    private MultipartDownloaderSubscriber subscriber(GetObjectRequest getObjectRequest) {
        Optional<MultipartDownloadResumeContext> multipartDownloadContext = MultipartDownloadUtils.multipartDownloadResumeContext(getObjectRequest);
        return multipartDownloadContext.map(ctx -> new MultipartDownloaderSubscriber(this.s3AsyncClient, getObjectRequest, ctx.highestSequentialCompletedPart())).orElseGet(() -> new MultipartDownloaderSubscriber(this.s3AsyncClient, getObjectRequest));
    }

    private void logSinglePartMessage(GetObjectRequest getObjectRequest) {
        log.debug(() -> {
            String reason = "";
            if (getObjectRequest.range() != null) {
                reason = " because getObjectRequest range is included in the request. range = " + getObjectRequest.range();
            } else if (getObjectRequest.partNumber() != null) {
                reason = " because getObjectRequest part number is included in the request. part number = " + getObjectRequest.partNumber();
            }
            return "Using single part download" + reason;
        });
    }
}

