/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.multipart;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartDownloadResumeContext;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.multipart.S3MultipartExecutionAttribute;

@SdkInternalApi
public final class MultipartDownloadUtils {
    private MultipartDownloadUtils() {
    }

    public static List<Integer> completedParts(GetObjectRequest request) {
        return MultipartDownloadUtils.multipartDownloadResumeContext(request).map(MultipartDownloadResumeContext::completedParts).orElseGet(Collections::emptyList);
    }

    public static Optional<MultipartDownloadResumeContext> multipartDownloadResumeContext(GetObjectRequest request) {
        return request.overrideConfiguration().flatMap(conf -> Optional.ofNullable(conf.executionAttributes().getAttribute(S3MultipartExecutionAttribute.MULTIPART_DOWNLOAD_RESUME_CONTEXT)));
    }
}

