/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.s3express;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.services.s3.internal.s3express.S3ExpressIdentityKey;
import software.amazon.awssdk.services.s3.model.SessionCredentials;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.cache.CachedSupplier;
import software.amazon.awssdk.utils.cache.NonBlocking;
import software.amazon.awssdk.utils.cache.RefreshResult;

@SdkInternalApi
public final class CachedS3ExpressCredentials
implements SdkAutoCloseable {
    private static final Duration DEFAULT_EXPIRATION_TIME = Duration.ofMinutes(5L);
    private static final Duration DEFAULT_STALE_TIME = Duration.ofSeconds(15L);
    private static final Duration DEFAULT_PREFETCH_TIME = Duration.ofSeconds(60L);
    private final Duration staleTime;
    private final Duration prefetchTime;
    private final Function<S3ExpressIdentityKey, SessionCredentials> credentialsSupplier;
    private final S3ExpressIdentityKey key;
    private final CachedSupplier<SessionCredentials> sessionCache;
    private final NonBlocking prefetchStrategy;

    private CachedS3ExpressCredentials(Builder builder) {
        this.credentialsSupplier = builder.supplier;
        this.key = builder.key;
        this.staleTime = Optional.ofNullable(builder.staleTime).orElse(DEFAULT_STALE_TIME);
        this.prefetchTime = Optional.ofNullable(builder.prefetchTime).orElse(DEFAULT_PREFETCH_TIME);
        this.prefetchStrategy = new NonBlocking("s3-express-credentials");
        this.sessionCache = CachedSupplier.builder(() -> this.refreshResult(this.credentialsSupplier, this.key)).prefetchStrategy(this.prefetchStrategy).build();
    }

    public static Builder builder(Function<S3ExpressIdentityKey, SessionCredentials> supplier) {
        return new Builder(supplier);
    }

    @SdkTestInternalApi
    NonBlocking prefetchStrategy() {
        return this.prefetchStrategy;
    }

    public SessionCredentials get() {
        return this.sessionCache.get();
    }

    private RefreshResult<SessionCredentials> refreshResult(Function<S3ExpressIdentityKey, SessionCredentials> identitySupplier, S3ExpressIdentityKey key) {
        SessionCredentials newCredentials = identitySupplier.apply(key);
        Instant expirationTime = newCredentials.expiration();
        if (expirationTime == null) {
            expirationTime = Instant.now().plus(DEFAULT_EXPIRATION_TIME);
        }
        return RefreshResult.builder(newCredentials).prefetchTime(expirationTime.minus(this.prefetchTime)).staleTime(expirationTime.minus(this.staleTime)).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachedS3ExpressCredentials that = (CachedS3ExpressCredentials)o;
        return this.key != null ? this.key.equals(that.key) : that.key == null;
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    @Override
    public void close() {
        this.sessionCache.close();
    }

    public static final class Builder {
        private final Function<S3ExpressIdentityKey, SessionCredentials> supplier;
        private Duration staleTime;
        private Duration prefetchTime;
        private S3ExpressIdentityKey key;

        private Builder(Function<S3ExpressIdentityKey, SessionCredentials> supplier) {
            this.supplier = supplier;
        }

        public Builder key(S3ExpressIdentityKey key) {
            this.key = key;
            return this;
        }

        public Builder staleTime(Duration staleTime) {
            this.staleTime = staleTime;
            return this;
        }

        public Builder prefetchTime(Duration prefetchTime) {
            this.prefetchTime = prefetchTime;
            return this;
        }

        public CachedS3ExpressCredentials build() {
            return new CachedS3ExpressCredentials(this);
        }
    }
}

