/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.services.s3.model.ObjectLockRetentionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ObjectLockRetention
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ObjectLockRetention> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("Mode").getter(ObjectLockRetention.getter(ObjectLockRetention::modeAsString)).setter(ObjectLockRetention.setter(Builder::mode)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").unmarshallLocationName("Mode").build()).build();
    private static final SdkField<Instant> RETAIN_UNTIL_DATE_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("RetainUntilDate").getter(ObjectLockRetention.getter(ObjectLockRetention::retainUntilDate)).setter(ObjectLockRetention.setter(Builder::retainUntilDate)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainUntilDate").unmarshallLocationName("RetainUntilDate").build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, RETAIN_UNTIL_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ObjectLockRetention.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mode;
    private final Instant retainUntilDate;

    private ObjectLockRetention(BuilderImpl builder) {
        this.mode = builder.mode;
        this.retainUntilDate = builder.retainUntilDate;
    }

    public final ObjectLockRetentionMode mode() {
        return ObjectLockRetentionMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final Instant retainUntilDate() {
        return this.retainUntilDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainUntilDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectLockRetention)) {
            return false;
        }
        ObjectLockRetention other = (ObjectLockRetention)obj;
        return Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.retainUntilDate(), other.retainUntilDate());
    }

    public final String toString() {
        return ToString.builder("ObjectLockRetention").add("Mode", this.modeAsString()).add("RetainUntilDate", this.retainUntilDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "RetainUntilDate": {
                return Optional.ofNullable(clazz.cast(this.retainUntilDate()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("Mode", MODE_FIELD);
        map.put("RetainUntilDate", RETAIN_UNTIL_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ObjectLockRetention, T> g) {
        return obj -> g.apply((ObjectLockRetention)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;
        private Instant retainUntilDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectLockRetention model) {
            this.mode(model.mode);
            this.retainUntilDate(model.retainUntilDate);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ObjectLockRetentionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Instant getRetainUntilDate() {
            return this.retainUntilDate;
        }

        public final void setRetainUntilDate(Instant retainUntilDate) {
            this.retainUntilDate = retainUntilDate;
        }

        @Override
        public final Builder retainUntilDate(Instant retainUntilDate) {
            this.retainUntilDate = retainUntilDate;
            return this;
        }

        @Override
        public ObjectLockRetention build() {
            return new ObjectLockRetention(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ObjectLockRetention> {
        public Builder mode(String var1);

        public Builder mode(ObjectLockRetentionMode var1);

        public Builder retainUntilDate(Instant var1);
    }
}

