/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;

public class ListBucketsIterable
implements SdkIterable<ListBucketsResponse> {
    private final S3Client client;
    private final ListBucketsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBucketsIterable(S3Client client, ListBucketsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBucketsResponseFetcher();
    }

    @Override
    public Iterator<ListBucketsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Bucket> buckets() {
        Function<ListBucketsResponse, Iterator> getIterator = response -> {
            if (response != null && response.buckets() != null) {
                return response.buckets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListBucketsResponseFetcher
    implements SyncPageFetcher<ListBucketsResponse> {
        private ListBucketsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListBucketsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.continuationToken());
        }

        @Override
        public ListBucketsResponse nextPage(ListBucketsResponse previousPage) {
            if (previousPage == null) {
                return ListBucketsIterable.this.client.listBuckets(ListBucketsIterable.this.firstRequest);
            }
            return ListBucketsIterable.this.client.listBuckets((ListBucketsRequest)ListBucketsIterable.this.firstRequest.toBuilder().continuationToken(previousPage.continuationToken()).build());
        }
    }
}

