/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.presigner.model;

import java.time.Duration;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.presigner.PresignRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@Immutable
@ThreadSafe
public final class GetObjectPresignRequest
extends PresignRequest
implements ToCopyableBuilder<Builder, GetObjectPresignRequest> {
    private final GetObjectRequest getObjectRequest;

    private GetObjectPresignRequest(DefaultBuilder builder) {
        super(builder);
        this.getObjectRequest = Validate.notNull(builder.getObjectRequest, "getObjectRequest", new Object[0]);
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public GetObjectRequest getObjectRequest() {
        return this.getObjectRequest;
    }

    @Override
    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GetObjectPresignRequest that = (GetObjectPresignRequest)o;
        return this.getObjectRequest.equals(that.getObjectRequest);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getObjectRequest.hashCode();
        return result;
    }

    @SdkInternalApi
    private static final class DefaultBuilder
    extends PresignRequest.DefaultBuilder<DefaultBuilder>
    implements Builder {
        private GetObjectRequest getObjectRequest;

        private DefaultBuilder() {
        }

        private DefaultBuilder(GetObjectPresignRequest request) {
            super(request);
            this.getObjectRequest = request.getObjectRequest;
        }

        @Override
        public Builder getObjectRequest(GetObjectRequest getObjectRequest) {
            this.getObjectRequest = getObjectRequest;
            return this;
        }

        @Override
        public GetObjectPresignRequest build() {
            return new GetObjectPresignRequest(this);
        }
    }

    @SdkPublicApi
    @NotThreadSafe
    public static interface Builder
    extends PresignRequest.Builder,
    CopyableBuilder<Builder, GetObjectPresignRequest> {
        public Builder getObjectRequest(GetObjectRequest var1);

        default public Builder getObjectRequest(Consumer<GetObjectRequest.Builder> getObjectRequest) {
            GetObjectRequest.Builder builder = GetObjectRequest.builder();
            getObjectRequest.accept(builder);
            return this.getObjectRequest((GetObjectRequest)builder.build());
        }

        @Override
        public Builder signatureDuration(Duration var1);

        @Override
        public GetObjectPresignRequest build();
    }
}

