/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.presigner.model;

import java.time.Duration;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.presigner.PresignRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@Immutable
@ThreadSafe
public final class UploadPartPresignRequest
extends PresignRequest
implements ToCopyableBuilder<Builder, UploadPartPresignRequest> {
    private final UploadPartRequest uploadPartRequest;

    private UploadPartPresignRequest(DefaultBuilder builder) {
        super(builder);
        this.uploadPartRequest = Validate.notNull(builder.uploadPartRequest, "uploadPartRequest", new Object[0]);
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public UploadPartRequest uploadPartRequest() {
        return this.uploadPartRequest;
    }

    @Override
    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UploadPartPresignRequest that = (UploadPartPresignRequest)o;
        return this.uploadPartRequest.equals(that.uploadPartRequest);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.uploadPartRequest.hashCode();
        return result;
    }

    @SdkInternalApi
    private static final class DefaultBuilder
    extends PresignRequest.DefaultBuilder<DefaultBuilder>
    implements Builder {
        private UploadPartRequest uploadPartRequest;

        private DefaultBuilder() {
        }

        private DefaultBuilder(UploadPartPresignRequest request) {
            super(request);
            this.uploadPartRequest = request.uploadPartRequest;
        }

        @Override
        public Builder uploadPartRequest(UploadPartRequest uploadPartRequest) {
            this.uploadPartRequest = uploadPartRequest;
            return this;
        }

        @Override
        public UploadPartPresignRequest build() {
            return new UploadPartPresignRequest(this);
        }
    }

    @SdkPublicApi
    @NotThreadSafe
    public static interface Builder
    extends PresignRequest.Builder,
    CopyableBuilder<Builder, UploadPartPresignRequest> {
        public Builder uploadPartRequest(UploadPartRequest var1);

        default public Builder uploadPartRequest(Consumer<UploadPartRequest.Builder> uploadPartRequest) {
            UploadPartRequest.Builder builder = UploadPartRequest.builder();
            uploadPartRequest.accept(builder);
            return this.uploadPartRequest((UploadPartRequest)builder.build());
        }

        @Override
        public Builder signatureDuration(Duration var1);

        @Override
        public UploadPartPresignRequest build();
    }
}

