/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso.model;

import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.awscore.AwsResponseMetadata;
import software.amazon.awssdk.services.sso.model.SsoResponseMetadata;

public abstract class SsoResponse
extends AwsResponse {
    private final SsoResponseMetadata responseMetadata;

    protected SsoResponse(Builder builder) {
        super(builder);
        this.responseMetadata = builder.responseMetadata();
    }

    @Override
    public SsoResponseMetadata responseMetadata() {
        return this.responseMetadata;
    }

    public static interface Builder
    extends AwsResponse.Builder {
        @Override
        public SsoResponse build();

        @Override
        public SsoResponseMetadata responseMetadata();

        @Override
        public Builder responseMetadata(AwsResponseMetadata var1);
    }

    protected static abstract class BuilderImpl
    extends AwsResponse.BuilderImpl
    implements Builder {
        private SsoResponseMetadata responseMetadata;

        protected BuilderImpl() {
        }

        protected BuilderImpl(SsoResponse response) {
            super(response);
            this.responseMetadata = response.responseMetadata();
        }

        @Override
        public SsoResponseMetadata responseMetadata() {
            return this.responseMetadata;
        }

        @Override
        public Builder responseMetadata(AwsResponseMetadata responseMetadata) {
            this.responseMetadata = SsoResponseMetadata.create(responseMetadata);
            return this;
        }
    }
}

