/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sso.SsoClient;
import software.amazon.awssdk.services.sso.internal.UserAgentUtils;
import software.amazon.awssdk.services.sso.model.ListAccountRolesRequest;
import software.amazon.awssdk.services.sso.model.ListAccountRolesResponse;
import software.amazon.awssdk.services.sso.model.RoleInfo;

public class ListAccountRolesIterable
implements SdkIterable<ListAccountRolesResponse> {
    private final SsoClient client;
    private final ListAccountRolesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountRolesIterable(SsoClient client, ListAccountRolesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccountRolesResponseFetcher();
    }

    @Override
    public Iterator<ListAccountRolesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RoleInfo> roleList() {
        Function<ListAccountRolesResponse, Iterator> getIterator = response -> {
            if (response != null && response.roleList() != null) {
                return response.roleList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccountRolesResponseFetcher
    implements SyncPageFetcher<ListAccountRolesResponse> {
        private ListAccountRolesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListAccountRolesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListAccountRolesResponse nextPage(ListAccountRolesResponse previousPage) {
            if (previousPage == null) {
                return ListAccountRolesIterable.this.client.listAccountRoles(ListAccountRolesIterable.this.firstRequest);
            }
            return ListAccountRolesIterable.this.client.listAccountRoles((ListAccountRolesRequest)ListAccountRolesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

