/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.ssoadmin.model.DisplayData;
import software.amazon.awssdk.services.ssoadmin.model.FederationProtocol;
import software.amazon.awssdk.services.ssoadmin.model.ResourceServerConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationProvider> {
    private static final SdkField<String> APPLICATION_PROVIDER_ARN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ApplicationProviderArn").getter(ApplicationProvider.getter(ApplicationProvider::applicationProviderArn)).setter(ApplicationProvider.setter(Builder::applicationProviderArn)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationProviderArn").build()).build();
    private static final SdkField<String> FEDERATION_PROTOCOL_FIELD = SdkField.builder(MarshallingType.STRING).memberName("FederationProtocol").getter(ApplicationProvider.getter(ApplicationProvider::federationProtocolAsString)).setter(ApplicationProvider.setter(Builder::federationProtocol)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederationProtocol").build()).build();
    private static final SdkField<DisplayData> DISPLAY_DATA_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("DisplayData").getter(ApplicationProvider.getter(ApplicationProvider::displayData)).setter(ApplicationProvider.setter(Builder::displayData)).constructor(DisplayData::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayData").build()).build();
    private static final SdkField<ResourceServerConfig> RESOURCE_SERVER_CONFIG_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("ResourceServerConfig").getter(ApplicationProvider.getter(ApplicationProvider::resourceServerConfig)).setter(ApplicationProvider.setter(Builder::resourceServerConfig)).constructor(ResourceServerConfig::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceServerConfig").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_PROVIDER_ARN_FIELD, FEDERATION_PROTOCOL_FIELD, DISPLAY_DATA_FIELD, RESOURCE_SERVER_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationProvider.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationProviderArn;
    private final String federationProtocol;
    private final DisplayData displayData;
    private final ResourceServerConfig resourceServerConfig;

    private ApplicationProvider(BuilderImpl builder) {
        this.applicationProviderArn = builder.applicationProviderArn;
        this.federationProtocol = builder.federationProtocol;
        this.displayData = builder.displayData;
        this.resourceServerConfig = builder.resourceServerConfig;
    }

    public final String applicationProviderArn() {
        return this.applicationProviderArn;
    }

    public final FederationProtocol federationProtocol() {
        return FederationProtocol.fromValue(this.federationProtocol);
    }

    public final String federationProtocolAsString() {
        return this.federationProtocol;
    }

    public final DisplayData displayData() {
        return this.displayData;
    }

    public final ResourceServerConfig resourceServerConfig() {
        return this.resourceServerConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.federationProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayData());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceServerConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationProvider)) {
            return false;
        }
        ApplicationProvider other = (ApplicationProvider)obj;
        return Objects.equals(this.applicationProviderArn(), other.applicationProviderArn()) && Objects.equals(this.federationProtocolAsString(), other.federationProtocolAsString()) && Objects.equals(this.displayData(), other.displayData()) && Objects.equals(this.resourceServerConfig(), other.resourceServerConfig());
    }

    public final String toString() {
        return ToString.builder("ApplicationProvider").add("ApplicationProviderArn", this.applicationProviderArn()).add("FederationProtocol", this.federationProtocolAsString()).add("DisplayData", this.displayData()).add("ResourceServerConfig", this.resourceServerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationProviderArn": {
                return Optional.ofNullable(clazz.cast(this.applicationProviderArn()));
            }
            case "FederationProtocol": {
                return Optional.ofNullable(clazz.cast(this.federationProtocolAsString()));
            }
            case "DisplayData": {
                return Optional.ofNullable(clazz.cast(this.displayData()));
            }
            case "ResourceServerConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceServerConfig()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("ApplicationProviderArn", APPLICATION_PROVIDER_ARN_FIELD);
        map.put("FederationProtocol", FEDERATION_PROTOCOL_FIELD);
        map.put("DisplayData", DISPLAY_DATA_FIELD);
        map.put("ResourceServerConfig", RESOURCE_SERVER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationProvider, T> g) {
        return obj -> g.apply((ApplicationProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationProviderArn;
        private String federationProtocol;
        private DisplayData displayData;
        private ResourceServerConfig resourceServerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationProvider model) {
            this.applicationProviderArn(model.applicationProviderArn);
            this.federationProtocol(model.federationProtocol);
            this.displayData(model.displayData);
            this.resourceServerConfig(model.resourceServerConfig);
        }

        public final String getApplicationProviderArn() {
            return this.applicationProviderArn;
        }

        public final void setApplicationProviderArn(String applicationProviderArn) {
            this.applicationProviderArn = applicationProviderArn;
        }

        @Override
        public final Builder applicationProviderArn(String applicationProviderArn) {
            this.applicationProviderArn = applicationProviderArn;
            return this;
        }

        public final String getFederationProtocol() {
            return this.federationProtocol;
        }

        public final void setFederationProtocol(String federationProtocol) {
            this.federationProtocol = federationProtocol;
        }

        @Override
        public final Builder federationProtocol(String federationProtocol) {
            this.federationProtocol = federationProtocol;
            return this;
        }

        @Override
        public final Builder federationProtocol(FederationProtocol federationProtocol) {
            this.federationProtocol(federationProtocol == null ? null : federationProtocol.toString());
            return this;
        }

        public final DisplayData.Builder getDisplayData() {
            return this.displayData != null ? this.displayData.toBuilder() : null;
        }

        public final void setDisplayData(DisplayData.BuilderImpl displayData) {
            this.displayData = displayData != null ? displayData.build() : null;
        }

        @Override
        public final Builder displayData(DisplayData displayData) {
            this.displayData = displayData;
            return this;
        }

        public final ResourceServerConfig.Builder getResourceServerConfig() {
            return this.resourceServerConfig != null ? this.resourceServerConfig.toBuilder() : null;
        }

        public final void setResourceServerConfig(ResourceServerConfig.BuilderImpl resourceServerConfig) {
            this.resourceServerConfig = resourceServerConfig != null ? resourceServerConfig.build() : null;
        }

        @Override
        public final Builder resourceServerConfig(ResourceServerConfig resourceServerConfig) {
            this.resourceServerConfig = resourceServerConfig;
            return this;
        }

        @Override
        public ApplicationProvider build() {
            return new ApplicationProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationProvider> {
        public Builder applicationProviderArn(String var1);

        public Builder federationProtocol(String var1);

        public Builder federationProtocol(FederationProtocol var1);

        public Builder displayData(DisplayData var1);

        default public Builder displayData(Consumer<DisplayData.Builder> displayData) {
            return this.displayData((DisplayData)DisplayData.builder().applyMutation(displayData).build());
        }

        public Builder resourceServerConfig(ResourceServerConfig var1);

        default public Builder resourceServerConfig(Consumer<ResourceServerConfig.Builder> resourceServerConfig) {
            return this.resourceServerConfig((ResourceServerConfig)ResourceServerConfig.builder().applyMutation(resourceServerConfig).build());
        }
    }
}

