/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.ssoadmin.model.PrincipalType;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicationAssignmentResponse
extends SsoAdminResponse
implements ToCopyableBuilder<Builder, DescribeApplicationAssignmentResponse> {
    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("PrincipalType").getter(DescribeApplicationAssignmentResponse.getter(DescribeApplicationAssignmentResponse::principalTypeAsString)).setter(DescribeApplicationAssignmentResponse.setter(Builder::principalType)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("PrincipalId").getter(DescribeApplicationAssignmentResponse.getter(DescribeApplicationAssignmentResponse::principalId)).setter(DescribeApplicationAssignmentResponse.setter(Builder::principalId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ApplicationArn").getter(DescribeApplicationAssignmentResponse.getter(DescribeApplicationAssignmentResponse::applicationArn)).setter(DescribeApplicationAssignmentResponse.setter(Builder::applicationArn)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_TYPE_FIELD, PRINCIPAL_ID_FIELD, APPLICATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeApplicationAssignmentResponse.memberNameToFieldInitializer();
    private final String principalType;
    private final String principalId;
    private final String applicationArn;

    private DescribeApplicationAssignmentResponse(BuilderImpl builder) {
        super(builder);
        this.principalType = builder.principalType;
        this.principalId = builder.principalId;
        this.applicationArn = builder.applicationArn;
    }

    public final PrincipalType principalType() {
        return PrincipalType.fromValue(this.principalType);
    }

    public final String principalTypeAsString() {
        return this.principalType;
    }

    public final String principalId() {
        return this.principalId;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.principalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationAssignmentResponse)) {
            return false;
        }
        DescribeApplicationAssignmentResponse other = (DescribeApplicationAssignmentResponse)obj;
        return Objects.equals(this.principalTypeAsString(), other.principalTypeAsString()) && Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.applicationArn(), other.applicationArn());
    }

    public final String toString() {
        return ToString.builder("DescribeApplicationAssignmentResponse").add("PrincipalType", this.principalTypeAsString()).add("PrincipalId", this.principalId()).add("ApplicationArn", this.applicationArn()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrincipalType": {
                return Optional.ofNullable(clazz.cast(this.principalTypeAsString()));
            }
            case "PrincipalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("PrincipalType", PRINCIPAL_TYPE_FIELD);
        map.put("PrincipalId", PRINCIPAL_ID_FIELD);
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationAssignmentResponse, T> g) {
        return obj -> g.apply((DescribeApplicationAssignmentResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminResponse.BuilderImpl
    implements Builder {
        private String principalType;
        private String principalId;
        private String applicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationAssignmentResponse model) {
            super(model);
            this.principalType(model.principalType);
            this.principalId(model.principalId);
            this.applicationArn(model.applicationArn);
        }

        public final String getPrincipalType() {
            return this.principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        @Override
        public DescribeApplicationAssignmentResponse build() {
            return new DescribeApplicationAssignmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsoAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApplicationAssignmentResponse> {
        public Builder principalType(String var1);

        public Builder principalType(PrincipalType var1);

        public Builder principalId(String var1);

        public Builder applicationArn(String var1);
    }
}

