/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssoadmin.model.AuthorizationCodeGrant;
import software.amazon.awssdk.services.ssoadmin.model.JwtBearerGrant;
import software.amazon.awssdk.services.ssoadmin.model.RefreshTokenGrant;
import software.amazon.awssdk.services.ssoadmin.model.TokenExchangeGrant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Grant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Grant> {
    private static final SdkField<AuthorizationCodeGrant> AUTHORIZATION_CODE_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("AuthorizationCode").getter(Grant.getter(Grant::authorizationCode)).setter(Grant.setter(Builder::authorizationCode)).constructor(AuthorizationCodeGrant::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationCode").build()).build();
    private static final SdkField<JwtBearerGrant> JWT_BEARER_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("JwtBearer").getter(Grant.getter(Grant::jwtBearer)).setter(Grant.setter(Builder::jwtBearer)).constructor(JwtBearerGrant::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JwtBearer").build()).build();
    private static final SdkField<RefreshTokenGrant> REFRESH_TOKEN_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("RefreshToken").getter(Grant.getter(Grant::refreshToken)).setter(Grant.setter(Builder::refreshToken)).constructor(RefreshTokenGrant::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshToken").build()).build();
    private static final SdkField<TokenExchangeGrant> TOKEN_EXCHANGE_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("TokenExchange").getter(Grant.getter(Grant::tokenExchange)).setter(Grant.setter(Builder::tokenExchange)).constructor(TokenExchangeGrant::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenExchange").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_CODE_FIELD, JWT_BEARER_FIELD, REFRESH_TOKEN_FIELD, TOKEN_EXCHANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Grant.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AuthorizationCodeGrant authorizationCode;
    private final JwtBearerGrant jwtBearer;
    private final RefreshTokenGrant refreshToken;
    private final TokenExchangeGrant tokenExchange;
    private final Type type;

    private Grant(BuilderImpl builder) {
        this.authorizationCode = builder.authorizationCode;
        this.jwtBearer = builder.jwtBearer;
        this.refreshToken = builder.refreshToken;
        this.tokenExchange = builder.tokenExchange;
        this.type = builder.type;
    }

    public final AuthorizationCodeGrant authorizationCode() {
        return this.authorizationCode;
    }

    public final JwtBearerGrant jwtBearer() {
        return this.jwtBearer;
    }

    public final RefreshTokenGrant refreshToken() {
        return this.refreshToken;
    }

    public final TokenExchangeGrant tokenExchange() {
        return this.tokenExchange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.jwtBearer());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenExchange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Grant)) {
            return false;
        }
        Grant other = (Grant)obj;
        return Objects.equals(this.authorizationCode(), other.authorizationCode()) && Objects.equals(this.jwtBearer(), other.jwtBearer()) && Objects.equals(this.refreshToken(), other.refreshToken()) && Objects.equals(this.tokenExchange(), other.tokenExchange());
    }

    public final String toString() {
        return ToString.builder("Grant").add("AuthorizationCode", this.authorizationCode()).add("JwtBearer", this.jwtBearer()).add("RefreshToken", this.refreshToken()).add("TokenExchange", this.tokenExchange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthorizationCode": {
                return Optional.ofNullable(clazz.cast(this.authorizationCode()));
            }
            case "JwtBearer": {
                return Optional.ofNullable(clazz.cast(this.jwtBearer()));
            }
            case "RefreshToken": {
                return Optional.ofNullable(clazz.cast(this.refreshToken()));
            }
            case "TokenExchange": {
                return Optional.ofNullable(clazz.cast(this.tokenExchange()));
            }
        }
        return Optional.empty();
    }

    public static Grant fromAuthorizationCode(AuthorizationCodeGrant authorizationCode) {
        return (Grant)Grant.builder().authorizationCode(authorizationCode).build();
    }

    public static Grant fromAuthorizationCode(Consumer<AuthorizationCodeGrant.Builder> authorizationCode) {
        AuthorizationCodeGrant.Builder builder = AuthorizationCodeGrant.builder();
        authorizationCode.accept(builder);
        return Grant.fromAuthorizationCode((AuthorizationCodeGrant)builder.build());
    }

    public static Grant fromJwtBearer(JwtBearerGrant jwtBearer) {
        return (Grant)Grant.builder().jwtBearer(jwtBearer).build();
    }

    public static Grant fromJwtBearer(Consumer<JwtBearerGrant.Builder> jwtBearer) {
        JwtBearerGrant.Builder builder = JwtBearerGrant.builder();
        jwtBearer.accept(builder);
        return Grant.fromJwtBearer((JwtBearerGrant)builder.build());
    }

    public static Grant fromRefreshToken(RefreshTokenGrant refreshToken) {
        return (Grant)Grant.builder().refreshToken(refreshToken).build();
    }

    public static Grant fromRefreshToken(Consumer<RefreshTokenGrant.Builder> refreshToken) {
        RefreshTokenGrant.Builder builder = RefreshTokenGrant.builder();
        refreshToken.accept(builder);
        return Grant.fromRefreshToken((RefreshTokenGrant)builder.build());
    }

    public static Grant fromTokenExchange(TokenExchangeGrant tokenExchange) {
        return (Grant)Grant.builder().tokenExchange(tokenExchange).build();
    }

    public static Grant fromTokenExchange(Consumer<TokenExchangeGrant.Builder> tokenExchange) {
        TokenExchangeGrant.Builder builder = TokenExchangeGrant.builder();
        tokenExchange.accept(builder);
        return Grant.fromTokenExchange((TokenExchangeGrant)builder.build());
    }

    public Type type() {
        return this.type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SdkPojo>> map = new HashMap<String, SdkField<SdkPojo>>();
        map.put("AuthorizationCode", AUTHORIZATION_CODE_FIELD);
        map.put("JwtBearer", JWT_BEARER_FIELD);
        map.put("RefreshToken", REFRESH_TOKEN_FIELD);
        map.put("TokenExchange", TOKEN_EXCHANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Grant, T> g) {
        return obj -> g.apply((Grant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AuthorizationCodeGrant authorizationCode;
        private JwtBearerGrant jwtBearer;
        private RefreshTokenGrant refreshToken;
        private TokenExchangeGrant tokenExchange;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Grant model) {
            this.authorizationCode(model.authorizationCode);
            this.jwtBearer(model.jwtBearer);
            this.refreshToken(model.refreshToken);
            this.tokenExchange(model.tokenExchange);
        }

        public final AuthorizationCodeGrant.Builder getAuthorizationCode() {
            return this.authorizationCode != null ? this.authorizationCode.toBuilder() : null;
        }

        public final void setAuthorizationCode(AuthorizationCodeGrant.BuilderImpl authorizationCode) {
            AuthorizationCodeGrant oldValue = this.authorizationCode;
            this.authorizationCode = authorizationCode != null ? authorizationCode.build() : null;
            this.handleUnionValueChange(Type.AUTHORIZATION_CODE, oldValue, this.authorizationCode);
        }

        @Override
        public final Builder authorizationCode(AuthorizationCodeGrant authorizationCode) {
            AuthorizationCodeGrant oldValue = this.authorizationCode;
            this.authorizationCode = authorizationCode;
            this.handleUnionValueChange(Type.AUTHORIZATION_CODE, oldValue, this.authorizationCode);
            return this;
        }

        public final JwtBearerGrant.Builder getJwtBearer() {
            return this.jwtBearer != null ? this.jwtBearer.toBuilder() : null;
        }

        public final void setJwtBearer(JwtBearerGrant.BuilderImpl jwtBearer) {
            JwtBearerGrant oldValue = this.jwtBearer;
            this.jwtBearer = jwtBearer != null ? jwtBearer.build() : null;
            this.handleUnionValueChange(Type.JWT_BEARER, oldValue, this.jwtBearer);
        }

        @Override
        public final Builder jwtBearer(JwtBearerGrant jwtBearer) {
            JwtBearerGrant oldValue = this.jwtBearer;
            this.jwtBearer = jwtBearer;
            this.handleUnionValueChange(Type.JWT_BEARER, oldValue, this.jwtBearer);
            return this;
        }

        public final RefreshTokenGrant.Builder getRefreshToken() {
            return this.refreshToken != null ? this.refreshToken.toBuilder() : null;
        }

        public final void setRefreshToken(RefreshTokenGrant.BuilderImpl refreshToken) {
            RefreshTokenGrant oldValue = this.refreshToken;
            this.refreshToken = refreshToken != null ? refreshToken.build() : null;
            this.handleUnionValueChange(Type.REFRESH_TOKEN, oldValue, this.refreshToken);
        }

        @Override
        public final Builder refreshToken(RefreshTokenGrant refreshToken) {
            RefreshTokenGrant oldValue = this.refreshToken;
            this.refreshToken = refreshToken;
            this.handleUnionValueChange(Type.REFRESH_TOKEN, oldValue, this.refreshToken);
            return this;
        }

        public final TokenExchangeGrant.Builder getTokenExchange() {
            return this.tokenExchange != null ? this.tokenExchange.toBuilder() : null;
        }

        public final void setTokenExchange(TokenExchangeGrant.BuilderImpl tokenExchange) {
            TokenExchangeGrant oldValue = this.tokenExchange;
            this.tokenExchange = tokenExchange != null ? tokenExchange.build() : null;
            this.handleUnionValueChange(Type.TOKEN_EXCHANGE, oldValue, this.tokenExchange);
        }

        @Override
        public final Builder tokenExchange(TokenExchangeGrant tokenExchange) {
            TokenExchangeGrant oldValue = this.tokenExchange;
            this.tokenExchange = tokenExchange;
            this.handleUnionValueChange(Type.TOKEN_EXCHANGE, oldValue, this.tokenExchange);
            return this;
        }

        @Override
        public Grant build() {
            return new Grant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static enum Type {
        AUTHORIZATION_CODE,
        JWT_BEARER,
        REFRESH_TOKEN,
        TOKEN_EXCHANGE,
        UNKNOWN_TO_SDK_VERSION;

    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Grant> {
        public Builder authorizationCode(AuthorizationCodeGrant var1);

        default public Builder authorizationCode(Consumer<AuthorizationCodeGrant.Builder> authorizationCode) {
            return this.authorizationCode((AuthorizationCodeGrant)AuthorizationCodeGrant.builder().applyMutation(authorizationCode).build());
        }

        public Builder jwtBearer(JwtBearerGrant var1);

        default public Builder jwtBearer(Consumer<JwtBearerGrant.Builder> jwtBearer) {
            return this.jwtBearer((JwtBearerGrant)JwtBearerGrant.builder().applyMutation(jwtBearer).build());
        }

        public Builder refreshToken(RefreshTokenGrant var1);

        default public Builder refreshToken(Consumer<RefreshTokenGrant.Builder> refreshToken) {
            return this.refreshToken((RefreshTokenGrant)RefreshTokenGrant.builder().applyMutation(refreshToken).build());
        }

        public Builder tokenExchange(TokenExchangeGrant var1);

        default public Builder tokenExchange(Consumer<TokenExchangeGrant.Builder> tokenExchange) {
            return this.tokenExchange((TokenExchangeGrant)TokenExchangeGrant.builder().applyMutation(tokenExchange).build());
        }
    }
}

