/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.PermissionSetListCopier;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPermissionSetsProvisionedToAccountResponse
extends SsoAdminResponse
implements ToCopyableBuilder<Builder, ListPermissionSetsProvisionedToAccountResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("NextToken").getter(ListPermissionSetsProvisionedToAccountResponse.getter(ListPermissionSetsProvisionedToAccountResponse::nextToken)).setter(ListPermissionSetsProvisionedToAccountResponse.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();
    private static final SdkField<List<String>> PERMISSION_SETS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("PermissionSets").getter(ListPermissionSetsProvisionedToAccountResponse.getter(ListPermissionSetsProvisionedToAccountResponse::permissionSets)).setter(ListPermissionSetsProvisionedToAccountResponse.setter(Builder::permissionSets)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PERMISSION_SETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPermissionSetsProvisionedToAccountResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<String> permissionSets;

    private ListPermissionSetsProvisionedToAccountResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.permissionSets = builder.permissionSets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPermissionSets() {
        return this.permissionSets != null && !(this.permissionSets instanceof SdkAutoConstructList);
    }

    public final List<String> permissionSets() {
        return this.permissionSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissionSets() ? this.permissionSets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPermissionSetsProvisionedToAccountResponse)) {
            return false;
        }
        ListPermissionSetsProvisionedToAccountResponse other = (ListPermissionSetsProvisionedToAccountResponse)obj;
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPermissionSets() == other.hasPermissionSets() && Objects.equals(this.permissionSets(), other.permissionSets());
    }

    public final String toString() {
        return ToString.builder("ListPermissionSetsProvisionedToAccountResponse").add("NextToken", this.nextToken()).add("PermissionSets", this.hasPermissionSets() ? this.permissionSets() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PermissionSets": {
                return Optional.ofNullable(clazz.cast(this.permissionSets()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("PermissionSets", PERMISSION_SETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPermissionSetsProvisionedToAccountResponse, T> g) {
        return obj -> g.apply((ListPermissionSetsProvisionedToAccountResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> permissionSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPermissionSetsProvisionedToAccountResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.permissionSets(model.permissionSets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getPermissionSets() {
            if (this.permissionSets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissionSets;
        }

        public final void setPermissionSets(Collection<String> permissionSets) {
            this.permissionSets = PermissionSetListCopier.copy(permissionSets);
        }

        @Override
        public final Builder permissionSets(Collection<String> permissionSets) {
            this.permissionSets = PermissionSetListCopier.copy(permissionSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionSets(String ... permissionSets) {
            this.permissionSets(Arrays.asList(permissionSets));
            return this;
        }

        @Override
        public ListPermissionSetsProvisionedToAccountResponse build() {
            return new ListPermissionSetsProvisionedToAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsoAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPermissionSetsProvisionedToAccountResponse> {
        public Builder nextToken(String var1);

        public Builder permissionSets(Collection<String> var1);

        public Builder permissionSets(String ... var1);
    }
}

